/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xml.ui.internal.outline;

import java.util.List;
import net.sourceforge.phpeclipse.core.model.ISourceReference;
import net.sourceforge.phpeclipse.ui.views.outline.ProblemsLabelDecorator;
import net.sourceforge.phpeclipse.xml.core.model.IXMLDocument;
import net.sourceforge.phpeclipse.xml.ui.internal.editor.XMLDocumentProvider;
import net.sourceforge.phpeclipse.xml.ui.internal.editor.XMLEditor;
import net.sourceforge.phpeclipse.xml.ui.internal.outline.XMLOutlineContentProvider;
import net.sourceforge.phpeclipse.xml.ui.internal.outline.XMLOutlineLabelProvider;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class XMLOutlinePage
extends ContentOutlinePage {
    private XMLEditor editor;

    public XMLOutlinePage(XMLEditor editor) {
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new XMLOutlineContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new XMLOutlineLabelProvider(), (ILabelDecorator)new ProblemsLabelDecorator((ITextEditor)this.editor)));
        viewer.setInput((Object)this.getDocument());
    }

    public void select(ISourceReference element) {
        IStructuredSelection structuredSelection;
        List elements;
        ISelection selection;
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && (selection = viewer.getSelection()) instanceof IStructuredSelection && !(elements = (structuredSelection = (IStructuredSelection)selection).toList()).contains(element)) {
            selection = element == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)element);
            viewer.setSelection(selection, true);
        }
    }

    public void update() {
        Control control;
        TreeViewer viewer;
        IXMLDocument document = this.getDocument();
        if (document != null && (viewer = this.getTreeViewer()) != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
            control.setRedraw(false);
            viewer.setInput((Object)document);
            viewer.expandAll();
            control.setRedraw(true);
        }
    }

    private IXMLDocument getDocument() {
        IDocumentProvider provider = this.editor.getDocumentProvider();
        if (provider instanceof XMLDocumentProvider) {
            XMLDocumentProvider xmlProvider = (XMLDocumentProvider)provider;
            return xmlProvider.getModel(this.editor.getEditorInput());
        }
        return null;
    }
}

