/*******************************************************************************
 * Copyright (c) 2000, 2002 International Business Machines Corp. and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package net.sourceforge.phpdt.ui.text;

/**
 * Color keys used for syntax highlighting PHP code and PHPDoc compliant
 * comments. A <code>IColorManager</code> is responsible for mapping concrete
 * colors to these keys.
 * <p>
 * This interface declares static final fields only; it is not intended to be
 * implemented.
 * </p>
 * 
 * @see IColorManager
 */
public interface IJavaColorConstants {

	/**
	 * Note: This constant is for internal use only. Clients should not use this
	 * constant. The prefix all color constants start with.
	 */
	// String PREFIX= "php_"; //$NON-NLS-1$
	//	
	// /** The color key for multi-line comments in PHP code. */
	// String PHP_MULTI_LINE_COMMENT= "php_multi_line_comment"; //$NON-NLS-1$
	// /** The color key for single-line comments in PHP code. */
	// String PHP_SINGLE_LINE_COMMENT= "php_single_line_comment"; //$NON-NLS-1$
	// /** The color key for PHP keywords in PHP code. */
	// String PHP_KEYWORD= "php_keyword"; //$NON-NLS-1$
	// /** The color key for string and character literals in PHP code. */
	// String PHP_STRING= "php_string"; //$NON-NLS-1$
	// /** The color key for everthing in PHP code for which no other color is
	// specified. */
	// String PHP_DEFAULT= "php_default"; //$NON-NLS-1$
	// /** The color key for predefined PHP function namesin PHP code. */
	// String PHP_FUNCTIONNAME= "php_functionname"; //$NON-NLS-1$
	// /** The color key for ($-)variables in PHP code. */
	// String PHP_VARIABLE= "php_variable"; //$NON-NLS-1$
	// /** The color key for constants in PHP code */
	// String PHP_CONSTANT= "php_constant"; //$NON-NLS-1$
	// /** The color key for the PHP built-in types in PHP code. */
	// String PHP_TYPE= "php_type"; //$NON-NLS-1$

	// /** The color key for PHPDoc keywords (<code>@foo</code>) in PHPDoc
	// comments. */
	// String PHPDOC_KEYWORD= "php_doc_keyword"; //$NON-NLS-1$
	// /** The color key for HTML tags (<code>&lt;foo&gt;</code>) in PHPDoc
	// comments. */
	// String PHPDOC_TAG= "php_doc_tag"; //$NON-NLS-1$
	// /** The color key for PHPDoc links (<code>{foo}</code>) in PHPDoc
	// comments. */
	// String PHPDOC_LINK= "php_doc_link"; //$NON-NLS-1$
	// /** The color key for everthing in PHPDoc comments for which no other
	// color is specified. */
	// String PHPDOC_DEFAULT= "php_doc_default"; //$NON-NLS-1$
}