/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xml.ui.internal.text;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class XMLPartitionScanner
implements IPartitionTokenScanner {
    public static final String XML_PI = "__xml_processing_instruction";
    public static final String XML_COMMENT = "__xml_comment";
    public static final String XML_DECL = "__xml_declaration";
    public static final String XML_TAG = "__xml_tag";
    public static final String XML_ATTRIBUTE = "__xml_attribute";
    public static final String XML_CDATA = "__xml_cdata";
    public static final String DTD_INTERNAL = "__dtd_internal";
    public static final String DTD_INTERNAL_PI = "__dtd_internal_pi";
    public static final String DTD_INTERNAL_COMMENT = "__dtd_internal_comment";
    public static final String DTD_INTERNAL_DECL = "__dtd_internal_declaration";
    public static final String DTD_CONDITIONAL = "__dtd_conditional";
    public static final int STATE_DEFAULT = 0;
    public static final int STATE_TAG = 1;
    public static final int STATE_DECL = 2;
    public static final int STATE_CDATA = 4;
    public static final int STATE_INTERNAL = 8;
    protected IDocument document;
    protected int end;
    protected int offset;
    protected int length;
    protected int position;
    protected int state;
    protected boolean parsedtd;
    protected Map tokens = new HashMap();

    public XMLPartitionScanner(boolean parsedtd) {
        this.parsedtd = parsedtd;
    }

    public IToken nextToken() {
        this.offset += this.length;
        switch (this.state) {
            case 1: {
                return this.nextTagToken();
            }
            case 2: {
                return this.nextDeclToken();
            }
            case 4: {
                return this.nextCDATAToken();
            }
        }
        switch (this.read()) {
            case -1: {
                this.state = 0;
                return this.getToken(null);
            }
            case 60: {
                switch (this.read()) {
                    case -1: {
                        if (this.parsedtd || this.isInternal()) break;
                        this.state = 0;
                        return this.getToken(XML_TAG);
                    }
                    case 63: {
                        return this.nextPIToken();
                    }
                    case 33: {
                        switch (this.read()) {
                            case -1: {
                                this.state = 0;
                                return this.getToken(XML_TAG);
                            }
                            case 45: {
                                switch (this.read()) {
                                    case -1: {
                                        return this.nextDeclToken();
                                    }
                                    case 45: {
                                        return this.nextCommentToken();
                                    }
                                }
                            }
                            case 91: {
                                if (this.parsedtd) {
                                    return this.nextConditionalToken();
                                }
                                if (this.isInternal()) break;
                                return this.nextCDATAToken();
                            }
                        }
                        return this.nextDeclToken();
                    }
                }
                if (this.parsedtd || this.isInternal()) break;
                this.unread();
                return this.nextTagToken();
            }
            case 93: {
                if (!this.isInternal()) break;
                this.unread();
                this.state = 2;
                this.length = 0;
                return this.nextToken();
            }
            default: {
                this.unread();
            }
        }
        block33: while (true) {
            switch (this.read()) {
                case -1: {
                    this.state = 0;
                    return this.getToken(null);
                }
                case 60: {
                    if (this.parsedtd || this.isInternal()) {
                        switch (this.read()) {
                            case -1: {
                                this.state = 0;
                                return this.getToken(null);
                            }
                            case 33: 
                            case 63: {
                                this.unread();
                                break;
                            }
                            default: {
                                continue block33;
                            }
                        }
                    }
                    this.unread();
                    this.state &= 8;
                    return this.getToken(this.isInternal() ? DTD_INTERNAL : null);
                }
                case 93: {
                    if (!this.isInternal()) continue block33;
                    this.unread();
                    this.state = 2;
                    if (this.position == this.offset) {
                        this.length = 0;
                        return this.nextToken();
                    }
                    return this.getToken(DTD_INTERNAL);
                }
            }
        }
    }

    private IToken nextTagToken() {
        int quot = this.read();
        switch (quot) {
            case -1: 
            case 62: {
                this.state = 0;
                return this.getToken(XML_TAG);
            }
            case 34: 
            case 39: {
                while (true) {
                    int ch;
                    if ((ch = this.read()) == quot) {
                        this.state = 1;
                        return this.getToken(XML_ATTRIBUTE);
                    }
                    switch (ch) {
                        case 60: {
                            this.unread();
                        }
                        case -1: {
                            this.state = 0;
                            return this.getToken(XML_ATTRIBUTE);
                        }
                    }
                }
            }
        }
        this.unread();
        while (true) {
            switch (this.read()) {
                case 60: {
                    this.unread();
                }
                case -1: 
                case 62: {
                    this.state = 0;
                    return this.getToken(XML_TAG);
                }
                case 34: 
                case 39: {
                    this.unread();
                    this.state = 1;
                    return this.getToken(XML_TAG);
                }
            }
        }
    }

    private IToken nextDeclToken() {
        block10: while (true) {
            switch (this.read()) {
                case -1: {
                    this.state = 0;
                    return this.getToken(this.isInternal() ? DTD_INTERNAL_DECL : XML_DECL);
                }
                case 60: {
                    if (this.parsedtd || this.isInternal()) {
                        switch (this.read()) {
                            case -1: {
                                this.state = 0;
                                return this.getToken(this.isInternal() ? DTD_INTERNAL : null);
                            }
                            case 33: 
                            case 63: {
                                this.unread();
                                break;
                            }
                            default: {
                                continue block10;
                            }
                        }
                    }
                    this.unread();
                }
                case 62: {
                    this.state &= 8;
                    return this.getToken(this.isInternal() ? DTD_INTERNAL_DECL : XML_DECL);
                }
                case 91: {
                    if (this.isInternal()) continue block10;
                    this.state = 8;
                    return this.getToken(XML_DECL);
                }
            }
        }
    }

    private IToken nextCommentToken() {
        this.state &= 8;
        block11: while (true) {
            switch (this.read()) {
                case -1: {
                    break block11;
                }
                case 45: {
                    switch (this.read()) {
                        case -1: {
                            break block11;
                        }
                        case 45: {
                            switch (this.read()) {
                                case -1: 
                                case 62: {
                                    break block11;
                                }
                            }
                            this.unread();
                        }
                    }
                }
                default: {
                    continue block11;
                }
            }
            break;
        }
        return this.getToken(this.isInternal() ? DTD_INTERNAL_COMMENT : XML_COMMENT);
    }

    private IToken nextPIToken() {
        this.state &= 8;
        block7: while (true) {
            switch (this.read()) {
                case -1: {
                    break block7;
                }
                case 63: {
                    switch (this.read()) {
                        case -1: 
                        case 62: {
                            break block7;
                        }
                    }
                    this.unread();
                }
                default: {
                    continue block7;
                }
            }
            break;
        }
        return this.getToken(this.isInternal() ? DTD_INTERNAL_PI : XML_PI);
    }

    private IToken nextCDATAToken() {
        this.state = 0;
        block11: while (true) {
            switch (this.read()) {
                case -1: {
                    break block11;
                }
                case 93: {
                    switch (this.read()) {
                        case -1: {
                            break block11;
                        }
                        case 93: {
                            switch (this.read()) {
                                case -1: 
                                case 62: {
                                    break block11;
                                }
                            }
                            this.unread();
                            this.unread();
                        }
                    }
                }
                default: {
                    continue block11;
                }
            }
            break;
        }
        return this.getToken(XML_CDATA);
    }

    /*
     * Enabled aggressive block sorting
     */
    private IToken nextConditionalToken() {
        this.state = 0;
        int level = 1;
        while (true) {
            block0 : switch (this.read()) {
                case -1: {
                    return this.getToken(DTD_CONDITIONAL);
                }
                case 60: {
                    block5 : switch (this.read()) {
                        case -1: {
                            return this.getToken(DTD_CONDITIONAL);
                        }
                        case 33: {
                            switch (this.read()) {
                                case -1: {
                                    return this.getToken(DTD_CONDITIONAL);
                                }
                                case 91: {
                                    ++level;
                                    break block5;
                                }
                            }
                            this.unread();
                            break;
                        }
                        default: {
                            this.unread();
                            break;
                        }
                    }
                    break;
                }
                case 93: {
                    switch (this.read()) {
                        case -1: {
                            return this.getToken(DTD_CONDITIONAL);
                        }
                        case 93: {
                            switch (this.read()) {
                                case -1: 
                                case 62: {
                                    if (--level != 0) break block0;
                                    return this.getToken(DTD_CONDITIONAL);
                                }
                                default: {
                                    this.unread();
                                    this.unread();
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private IToken getToken(String type) {
        this.length = this.position - this.offset;
        if (this.length == 0) {
            return Token.EOF;
        }
        if (type == null) {
            return Token.UNDEFINED;
        }
        IToken token = (IToken)this.tokens.get(type);
        if (token == null) {
            token = new Token((Object)type);
            this.tokens.put(type, token);
        }
        return token;
    }

    private boolean isInternal() {
        return (this.state & 8) != 0;
    }

    private int read() {
        if (this.position >= this.end) {
            return -1;
        }
        try {
            return this.document.getChar(this.position++);
        }
        catch (BadLocationException badLocationException) {
            --this.position;
            return -1;
        }
    }

    private void unread() {
        --this.position;
    }

    public int getTokenOffset() {
        Assert.isTrue((this.offset >= 0 ? 1 : 0) != 0, (String)Integer.toString(this.offset));
        return this.offset;
    }

    public int getTokenLength() {
        return this.length;
    }

    public void setRange(IDocument document, int offset, int length) {
        this.document = document;
        this.end = offset + length;
        this.offset = offset;
        this.position = offset;
        this.length = 0;
        this.state = 0;
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        this.document = document;
        this.end = offset + length;
        if (partitionOffset >= 0) {
            offset = partitionOffset;
        }
        this.offset = offset;
        this.position = offset;
        this.length = 0;
        if (contentType == XML_ATTRIBUTE) {
            this.state = 1;
            return;
        }
        if (contentType == XML_TAG) {
            this.state = this.isContinuationPartition() ? 1 : 0;
            return;
        }
        if (contentType == XML_DECL) {
            this.state = this.isContinuationPartition() ? 2 : 0;
            return;
        }
        if (contentType == DTD_INTERNAL || contentType == DTD_INTERNAL_PI || contentType == DTD_INTERNAL_DECL || contentType == DTD_INTERNAL_COMMENT) {
            this.state = 8;
            return;
        }
        this.state = 0;
    }

    private boolean isContinuationPartition() {
        try {
            String type = this.document.getContentType(this.offset - 1);
            if (type != "__dftl_partition_content_type") {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }
}

