/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xml.ui.internal.text;

import net.sourceforge.phpeclipse.ui.text.TextDoubleClickStrategy;
import net.sourceforge.phpeclipse.xml.ui.internal.text.SimpleDoubleClickStrategy;
import net.sourceforge.phpeclipse.xml.ui.text.DTDTextTools;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class DTDConfiguration
extends SourceViewerConfiguration {
    private DTDTextTools dtdTextTools;
    private ITextDoubleClickStrategy dcsDefault;
    private ITextDoubleClickStrategy dcsSimple;

    public DTDConfiguration(DTDTextTools tools) {
        this.dtdTextTools = tools;
        this.dcsDefault = new TextDoubleClickStrategy();
        this.dcsSimple = new SimpleDoubleClickStrategy();
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if ("__xml_processing_instruction".equals(contentType)) {
            return this.dcsSimple;
        }
        if ("__xml_comment".equals(contentType)) {
            return this.dcsSimple;
        }
        if ("__xml_declaration".equals(contentType)) {
            return this.dcsSimple;
        }
        if ("__dtd_conditional".equals(contentType)) {
            return this.dcsSimple;
        }
        return this.dcsDefault;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__xml_processing_instruction", "__xml_comment", "__xml_declaration", "__dtd_conditional"};
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.dtdTextTools.getDTDTextScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        reconciler.setDamager((IPresentationDamager)dr, "__xml_processing_instruction");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_processing_instruction");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.dtdTextTools.getXMLPIScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_processing_instruction");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_processing_instruction");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.dtdTextTools.getXMLCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.dtdTextTools.getXMLDeclScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_declaration");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_declaration");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.dtdTextTools.getDTDConditionalScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dtd_conditional");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dtd_conditional");
        return reconciler;
    }
}

