/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xdebug.php.model;

import net.sourceforge.phpeclipse.xdebug.core.PHPDebugUtils;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugAbstractValue;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugArrayValue;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugBooleanValue;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugElement;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugFloatValue;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugIntValue;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugObjectValue;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugResourceValue;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugStackFrame;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugStringValue;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugTarget;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugValue;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.w3c.dom.Node;

public class XDebugVariable
extends XDebugElement
implements IVariable {
    private String fName;
    private XDebugStackFrame fFrame;
    private XDebugAbstractValue fValue;
    private String fFacet;

    public XDebugVariable(XDebugStackFrame frame, Node property) throws DebugException {
        super((XDebugTarget)frame.getDebugTarget());
        if (frame != null) {
            this.fFrame = frame;
        }
        this.fName = PHPDebugUtils.getAttributeValue(property, "name");
        if ("".equals(this.fName)) {
            this.fName = PHPDebugUtils.getAttributeValue(property, "address");
        }
        this.fFacet = PHPDebugUtils.getAttributeValue(property, "facet");
        String typeName = PHPDebugUtils.getAttributeValue(property, "type");
        this.fValue = typeName.equals("int") ? new XDebugIntValue(frame, property) : (typeName.equals("float") ? new XDebugFloatValue(frame, property) : (typeName.equals("bool") ? new XDebugBooleanValue(frame, property) : (typeName.equals("string") ? new XDebugStringValue(frame, property) : (typeName.equals("array") ? new XDebugArrayValue(frame, property) : (typeName.equals("object") ? new XDebugObjectValue(frame, property) : (typeName.equals("resource") ? new XDebugResourceValue(frame, property) : new XDebugValue(frame, property)))))));
    }

    public IValue getValue() throws DebugException {
        return this.fValue;
    }

    public String getName() throws DebugException {
        return this.fName;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.fValue.getReferenceTypeName();
    }

    public boolean hasValueChanged() throws DebugException {
        return this.fValue.hasChanged();
    }

    public void setValue(String expression) throws DebugException {
        if (this.fFrame.setVariableValue(this, expression)) {
            this.fValue.setValue(expression);
        }
    }

    public void setValue(IValue value) throws DebugException {
    }

    public boolean supportsValueModification() {
        return this.fValue.supportsValueModification();
    }

    public boolean verifyValue(String expression) throws DebugException {
        return this.fValue.verifyValue(expression);
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }

    public String getValueString() throws DebugException {
        return this.fValue.getValueString();
    }

    public String getVisibility() {
        return this.fFacet;
    }
}

