/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xdebug.php.model;

import net.sourceforge.phpeclipse.xdebug.core.PHPDebugUtils;
import net.sourceforge.phpeclipse.xdebug.core.xdebug.XDebugResponse;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugElement;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugStackFrame;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugTarget;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XDebugThread
extends XDebugElement
implements IThread,
IDebugEventSetListener {
    private XDebugStackFrame[] fStackFrames;
    private IBreakpoint[] fBreakpoints;
    private boolean fStepping = false;
    private boolean fTerminated = false;
    private int fStepCount = 0;
    private int fCurrentStepCount = 0;

    public XDebugThread(XDebugTarget target) {
        super(target);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        this.fStackFrames = null;
    }

    public void incrementStepCounter() {
        ++this.fStepCount;
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        if (!this.isSuspended()) {
            return new IStackFrame[0];
        }
        if (this.fStepCount > this.fCurrentStepCount) {
            XDebugResponse dr = ((XDebugTarget)this.getDebugTarget()).getStackFrames();
            XDebugStackFrame[] newStackFrames = this._getStackFrames(dr);
            ++this.fCurrentStepCount;
            this.fStackFrames = newStackFrames;
        }
        return this.fStackFrames;
    }

    private XDebugStackFrame[] _getStackFrames(XDebugResponse lastResponse) {
        if (lastResponse.isError()) {
            return new XDebugStackFrame[0];
        }
        Node response = lastResponse.getParentNode();
        NodeList frames = response.getChildNodes();
        XDebugStackFrame[] theFrames = new XDebugStackFrame[frames.getLength()];
        int i = 0;
        while (i < frames.getLength()) {
            Node stackNode = frames.item(i);
            String fileName = PHPDebugUtils.unescapeString(PHPDebugUtils.getAttributeValue(stackNode, "filename"));
            String lineNo = PHPDebugUtils.getAttributeValue(stackNode, "lineno");
            XDebugStackFrame frame = new XDebugStackFrame(this, i, PHPDebugUtils.getAttributeValue(stackNode, "type"), Integer.parseInt(lineNo), PHPDebugUtils.getAttributeValue(stackNode, "where"), fileName);
            frame.incrementStepCounter();
            theFrames[i] = frame;
            ++i;
        }
        return theFrames;
    }

    public boolean hasStackFrames() throws DebugException {
        return this.isSuspended();
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        IStackFrame[] frames = this.getStackFrames();
        if (frames.length > 0) {
            return frames[0];
        }
        return null;
    }

    public String getName() throws DebugException {
        return "Thread[1]";
    }

    public IBreakpoint[] getBreakpoints() {
        if (this.fBreakpoints == null) {
            return new IBreakpoint[0];
        }
        return this.fBreakpoints;
    }

    protected void setBreakpoints(IBreakpoint[] breakpoints) {
        this.fBreakpoints = breakpoints;
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isTerminated() && !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.getDebugTarget().isSuspended();
    }

    public void resume() throws DebugException {
        this.fBreakpoints = null;
        this.getDebugTarget().resume();
    }

    public void suspend() throws DebugException {
        this.getDebugTarget().suspend();
    }

    public boolean canStepInto() {
        return this.isSuspended();
    }

    public boolean canStepOver() {
        return this.isSuspended();
    }

    public boolean canStepReturn() {
        if (this.fStackFrames != null) {
            return this.fStackFrames.length > 1;
        }
        return false;
    }

    public boolean isStepping() {
        return this.fStepping;
    }

    public void stepInto() throws DebugException {
        this.fBreakpoints = null;
        ((XDebugTarget)this.getDebugTarget()).step_into();
    }

    public void stepOver() throws DebugException {
        this.fBreakpoints = null;
        ((XDebugTarget)this.getDebugTarget()).step_over();
    }

    public void stepReturn() throws DebugException {
        this.fBreakpoints = null;
        ((XDebugTarget)this.getDebugTarget()).step_out();
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    public void terminate() throws DebugException {
        ((XDebugTarget)this.getDebugTarget()).getDebugConnection().stop();
        this.fTerminated = true;
    }

    public void terminated() throws DebugException {
        this.fTerminated = true;
    }

    protected void setStepping(boolean stepping) {
        this.fStepping = stepping;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent de = events[0];
        System.out.println(de.toString());
    }

    public void removeEventListeners() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }

    public void fireResumeEvent(int detail) {
        this.fireEvent(new DebugEvent((Object)this, 1, detail));
    }

    public void fireSuspendEvent(int detail) {
        this.fireEvent(new DebugEvent((Object)this, 2, detail));
    }
}

