/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.launching;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.phpdt.internal.core.JavaProject;
import net.sourceforge.phpdt.internal.launching.PHPInterpreter;
import net.sourceforge.phpdt.internal.launching.PHPLaunchingPlugin;
import net.sourceforge.phpdt.internal.launching.PHPRuntime;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.launchConfigurations.EnvironmentVariable;

public class InterpreterRunnerConfiguration {
    protected ILaunchConfiguration configuration;
    private HashMap fEnvironment;

    public InterpreterRunnerConfiguration(ILaunchConfiguration aConfiguration) {
        this.configuration = aConfiguration;
        this.fEnvironment = new HashMap();
    }

    public String getAbsoluteFileName() {
        Path path = new Path(this.getFileName());
        IProject project = this.getProject().getProject();
        IResource file = project.findMember((IPath)path);
        return file.getProjectRelativePath().toOSString();
    }

    public String getFileName() {
        String fileName = "";
        try {
            fileName = this.configuration.getAttribute("net.sourceforge.phpeclipse.launching.FILE_NAME", "No file specified in configuration");
        }
        catch (CoreException coreException) {}
        return fileName.replace('\\', '/');
    }

    public JavaProject getProject() {
        String projectName = "";
        try {
            projectName = this.configuration.getAttribute("net.sourceforge.phpeclipse.launching.PROJECT_NAME", "");
        }
        catch (CoreException e) {
            PHPLaunchingPlugin.log(e);
        }
        IProject project = PHPLaunchingPlugin.getWorkspace().getRoot().getProject(projectName);
        JavaProject phpProject = new JavaProject();
        phpProject.setProject(project);
        return phpProject;
    }

    public File getAbsoluteWorkingDirectory() {
        String file = null;
        try {
            file = this.configuration.getAttribute("net.sourceforge.phpeclipse.launching.WORKING_DIRECTORY", "");
        }
        catch (CoreException e) {
            PHPLaunchingPlugin.log(e);
        }
        return new File(file);
    }

    public String getInterpreterArguments() {
        try {
            return this.configuration.getAttribute("net.sourceforge.phpeclipse.launching.INTERPRETER_ARGUMENTS", "");
        }
        catch (CoreException coreException) {
            return "";
        }
    }

    public String getProgramArguments() {
        try {
            return this.configuration.getAttribute("net.sourceforge.phpeclipse.launching.PROGRAM_ARGUMENTS", "");
        }
        catch (CoreException coreException) {
            return "";
        }
    }

    public PHPInterpreter getInterpreter() {
        String selectedInterpreter = null;
        try {
            selectedInterpreter = this.configuration.getAttribute("net.sourceforge.phpeclipse.launching.SELECTED_INTERPRETER", "");
        }
        catch (CoreException coreException) {}
        return PHPRuntime.getDefault().getInterpreter(selectedInterpreter);
    }

    public boolean useRemoteDebugger() {
        try {
            return this.configuration.getAttribute("net.sourceforge.phpeclipse.launching.REMOTE_DEBUG", false);
        }
        catch (CoreException e) {
            PHPLaunchingPlugin.log(e);
            return false;
        }
    }

    public boolean usePathTranslation() {
        try {
            return this.configuration.getAttribute("net.sourceforge.phpeclipse.launching.REMOTE_DEBUG_TRANSLATE", false);
        }
        catch (CoreException e) {
            PHPLaunchingPlugin.log(e);
            return false;
        }
    }

    public Map getPathMap() {
        try {
            return this.configuration.getAttribute("net.sourceforge.phpeclipse.launching.FILE_MAP", null);
        }
        catch (CoreException e) {
            PHPLaunchingPlugin.log(e);
            return null;
        }
    }

    public boolean useDBGSessionInBrowser() {
        try {
            return this.configuration.getAttribute("net.sourceforge.phpeclipse.launching.OPEN_DBGSESSION_IN_BROWSER", true);
        }
        catch (CoreException e) {
            PHPLaunchingPlugin.log(e);
            return false;
        }
    }

    public void setEnvironment(String[] envp) {
        if (envp == null) {
            return;
        }
        int i = 0;
        while (i < envp.length) {
            this.addEnvironmentValue(envp[i], true);
            ++i;
        }
    }

    public void addEnvironmentValue(String env, boolean replace) {
        String value = env.substring(env.indexOf(61) + 1);
        String key = env.substring(0, env.indexOf(61));
        this.addEnvironmentValue(key, value, replace);
    }

    public void addEnvironmentValue(String key, String value, boolean replace) {
        if (!replace && this.fEnvironment.containsKey(key)) {
            EnvironmentVariable ev = (EnvironmentVariable)this.fEnvironment.get(key);
            ev.setValue(String.valueOf(ev.getValue()) + ";" + value);
            this.fEnvironment.put(key, ev);
        } else {
            this.fEnvironment.put(key, new EnvironmentVariable(key, value));
        }
    }

    public String[] getEnvironment() {
        Iterator iter = this.fEnvironment.entrySet().iterator();
        ArrayList<String> strings = new ArrayList<String>(this.fEnvironment.size());
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            StringBuffer buffer = new StringBuffer((String)entry.getKey());
            buffer.append('=').append(((EnvironmentVariable)entry.getValue()).getValue());
            strings.add(buffer.toString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    public String getRemoteSourcePath() {
        IProject project = this.getProject().getProject();
        if (!this.useRemoteDebugger()) {
            return project.getFullPath().toOSString();
        }
        try {
            return this.configuration.getAttribute("net.sourceforge.phpeclipse.launching.REMOTE_PATH", "");
        }
        catch (CoreException e) {
            PHPLaunchingPlugin.log(e);
            return "";
        }
    }

    public boolean useDBGSessionInExternalBrowser() {
        try {
            return this.configuration.getAttribute("net.sourceforge.phpeclipse.launching.OPEN_DBGSESSION_IN_EXTERNAL_BROWSER", false);
        }
        catch (CoreException e) {
            PHPLaunchingPlugin.log(e);
            return false;
        }
    }
}

