/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.externaltools.internal.registry;

import java.util.HashMap;
import net.sourceforge.phpdt.externaltools.internal.registry.ExternalToolVariable;
import net.sourceforge.phpeclipse.externaltools.ExternalToolsPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public abstract class ExternalToolVariableRegistry {
    static final String TAG_VARIABLE = "variable";
    static final String TAG_TAG = "tag";
    static final String TAG_DESCRIPTION = "description";
    static final String TAG_COMPONENT_CLASS = "componentClass";
    static final String TAG_EXPANDER_CLASS = "expanderClass";
    private HashMap variables;
    private String extensionPointId;

    public ExternalToolVariableRegistry(String extensionPointId) {
        this.extensionPointId = extensionPointId;
        this.loadVariables();
    }

    protected final void copyVariables(Object[] results) {
        this.variables.values().toArray(results);
    }

    protected final ExternalToolVariable findVariable(String tag) {
        return (ExternalToolVariable)this.variables.get(tag);
    }

    public final int getVariableCount() {
        return this.variables.size();
    }

    private void loadVariables() {
        this.variables = new HashMap();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("net.sourceforge.phpeclipse.externaltools", this.extensionPointId);
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    if (element.getName().equals(TAG_VARIABLE)) {
                        String tag = element.getAttribute(TAG_TAG);
                        String description = element.getAttribute(TAG_DESCRIPTION);
                        String className = element.getAttribute(TAG_EXPANDER_CLASS);
                        boolean valid = true;
                        if (tag == null || tag.length() == 0) {
                            valid = false;
                            ExternalToolsPlugin.getDefault().log("Missing tag attribute value for variable element.", null);
                        }
                        if (description == null || description.length() == 0) {
                            valid = false;
                            ExternalToolsPlugin.getDefault().log("Missing description attribute value for variable element.", null);
                        }
                        if (className == null || className.length() == 0) {
                            valid = false;
                            ExternalToolsPlugin.getDefault().log("Missing expander class attribute value for variable element.", null);
                        }
                        if (valid) {
                            this.variables.put(tag, this.newVariable(tag, description, element));
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    protected abstract ExternalToolVariable newVariable(String var1, String var2, IConfigurationElement var3);
}

