/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.webbrowser.internal;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SWTUtil {
    private static FontMetrics fontMetrics;

    protected static void initializeDialogUnits(Control testControl) {
        GC gc = new GC((Drawable)testControl);
        gc.setFont(JFaceResources.getDialogFont());
        fontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    protected static int getButtonWidthHint(Button button) {
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static Button createButton(Composite comp, String label) {
        Button b = new Button(comp, 8);
        b.setText(label);
        if (fontMetrics == null) {
            SWTUtil.initializeDialogUnits((Control)comp);
        }
        GridData data = new GridData(258);
        data.widthHint = SWTUtil.getButtonWidthHint(b);
        data.heightHint = Dialog.convertVerticalDLUsToPixels((FontMetrics)fontMetrics, (int)14);
        b.setLayoutData((Object)data);
        return b;
    }

    public static Button createCheckbox(Composite comp, String txt, boolean isSelected) {
        Button button = new Button(comp, 32);
        button.setText(txt);
        GridLayout layout = new GridLayout();
        comp.setLayout((Layout)layout);
        GridData data = new GridData(258);
        data.horizontalIndent = 10;
        button.setLayoutData((Object)data);
        button.setSelection(isSelected);
        return button;
    }

    public static Label createLabel(Composite comp, String txt) {
        Label label = new Label(comp, 0);
        label.setText(txt);
        label.setLayoutData((Object)new GridData(34));
        return label;
    }
}

