/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import net.sourceforge.phpdt.core.JavaCore;
import net.sourceforge.phpdt.ui.actions.OpenPHPPerspectiveAction;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.wizards.PHPWizardMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewProjectCreationWizard
extends BasicNewResourceWizard
implements INewWizard,
IExecutableExtension {
    protected WizardNewProjectCreationPage projectPage;
    protected IConfigurationElement configurationElement;
    protected IProject newProject;

    public NewProjectCreationWizard() {
        this.setWindowTitle(PHPWizardMessages.getString("NewProjectCreationWizard.windowTitle"));
    }

    public boolean performFinish() {
        WorkspaceModifyDelegatingOperation projectCreationOperation = new WorkspaceModifyDelegatingOperation(this.getProjectCreationRunnable());
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)projectCreationOperation);
        }
        catch (Exception e) {
            PHPeclipsePlugin.log(e);
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configurationElement);
        this.selectAndReveal((IResource)this.newProject);
        new OpenPHPPerspectiveAction().run();
        return true;
    }

    protected IRunnableWithProgress getProjectCreationRunnable() {
        return new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                URI uriPath;
                int remainingWorkUnits = 10;
                monitor.beginTask(PHPWizardMessages.getString("NewProjectCreationWizard.projectCreationMessage"), remainingWorkUnits);
                IWorkspace workspace = PHPeclipsePlugin.getWorkspace();
                String projectName = NewProjectCreationWizard.this.projectPage.getProjectHandle().getName();
                NewProjectCreationWizard.this.newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                IProjectDescription description = workspace.newProjectDescription(projectName);
                URI uRI = uriPath = !NewProjectCreationWizard.this.projectPage.useDefaults() ? NewProjectCreationWizard.this.projectPage.getLocationURI() : null;
                if (uriPath != null) {
                    description.setLocationURI(uriPath);
                }
                try {
                    try {
                        if (!NewProjectCreationWizard.this.newProject.exists()) {
                            NewProjectCreationWizard.this.newProject.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            --remainingWorkUnits;
                        }
                        if (!NewProjectCreationWizard.this.newProject.isOpen()) {
                            NewProjectCreationWizard.this.newProject.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            --remainingWorkUnits;
                        }
                        JavaCore.addPHPNature(NewProjectCreationWizard.this.newProject, (IProgressMonitor)new SubProgressMonitor(monitor, remainingWorkUnits));
                    }
                    catch (CoreException e) {
                        System.out.println((Object)e);
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var8_10 = null;
                }
                monitor.done();
            }
        };
    }

    public void addPages() {
        super.addPages();
        this.projectPage = new WizardNewProjectCreationPage(PHPWizardMessages.getString("WizardNewProjectCreationPage.pageName"));
        this.projectPage.setTitle(PHPWizardMessages.getString("WizardNewProjectCreationPage.pageTitle"));
        this.projectPage.setDescription(PHPWizardMessages.getString("WizardNewProjectCreationPage.pageDescription"));
        this.addPage((IWizardPage)this.projectPage);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configurationElement = config;
    }
}

