/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.phpeditor.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class RTrimAction
implements IEditorActionDelegate {
    ITextEditor editor = null;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor instanceof ITextEditor) {
            this.editor = (ITextEditor)targetEditor;
        }
    }

    public void run(IAction action) {
        int originalSelectionLength;
        int originalCursorOffset;
        IDocument doc = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        ITextSelection sel = (ITextSelection)this.editor.getSelectionProvider().getSelection();
        int currentLine = 0;
        int cursorOffset = originalCursorOffset = sel.getOffset();
        int selectionLength = originalSelectionLength = sel.getLength();
        try {
            while (currentLine < doc.getNumberOfLines()) {
                int offset = doc.getLineOffset(currentLine);
                int length = doc.getLineLength(currentLine);
                String oldText = doc.get(offset, length);
                String lineDelimiter = doc.getLineDelimiter(currentLine);
                if (lineDelimiter == null) {
                    lineDelimiter = "";
                }
                int lineEnd = oldText.length() - lineDelimiter.length();
                while (lineEnd > 0) {
                    if (oldText.charAt(lineEnd - 1) != '\t' && oldText.charAt(lineEnd - 1) != ' ') break;
                    --lineEnd;
                }
                if (lineEnd != oldText.length() - lineDelimiter.length()) {
                    String newText = String.valueOf(oldText.substring(0, lineEnd)) + lineDelimiter;
                    doc.replace(offset, length, newText);
                    int oldEndOffset = offset + length - lineDelimiter.length();
                    int newEndOffset = offset + lineEnd;
                    if (cursorOffset >= oldEndOffset) {
                        cursorOffset -= oldText.length() - newText.length();
                    } else if (cursorOffset >= newEndOffset) {
                        cursorOffset = newEndOffset;
                    }
                    if (selectionLength > 0) {
                        int selectionEndOffset = cursorOffset + selectionLength;
                        if (selectionEndOffset >= oldEndOffset) {
                            selectionLength = cursorOffset <= newEndOffset ? (selectionLength -= oldText.length() - newText.length()) : (selectionLength -= oldEndOffset - cursorOffset);
                        } else if (selectionEndOffset >= newEndOffset) {
                            selectionLength = cursorOffset <= newEndOffset ? (selectionLength -= selectionEndOffset - newEndOffset) : 0;
                        }
                    }
                }
                ++currentLine;
            }
            TextSelection selection = new TextSelection(doc, cursorOffset, selectionLength);
            this.editor.getSelectionProvider().setSelection((ISelection)selection);
        }
        catch (Exception blx) {
            blx.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

