/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.phpeditor;

import java.util.Iterator;
import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.JavaCore;
import net.sourceforge.phpdt.internal.corext.util.JavaModelUtil;
import net.sourceforge.phpeclipse.phpeditor.EditorUtility;
import net.sourceforge.phpeclipse.phpeditor.IJavaAnnotation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class JavaMarkerAnnotation
extends MarkerAnnotation
implements IJavaAnnotation {
    public static final String JAVA_MARKER_TYPE_PREFIX = "net.sourceforge.phpdt";
    public static final String ERROR_ANNOTATION_TYPE = "net.sourceforge.phpdt.ui.error";
    public static final String WARNING_ANNOTATION_TYPE = "net.sourceforge.phpdt.ui.warning";
    public static final String INFO_ANNOTATION_TYPE = "net.sourceforge.phpdt.ui.info";
    public static final String TASK_ANNOTATION_TYPE = "org.eclipse.ui.workbench.texteditor.task";
    private IJavaAnnotation fOverlay;

    public JavaMarkerAnnotation(IMarker marker) {
        super(marker);
    }

    public Image getImage(Display display) {
        return super.getImage(display);
    }

    public String[] getArguments() {
        IMarker marker = this.getMarker();
        if (marker != null && marker.exists() && this.isProblem()) {
            return JavaModelUtil.getProblemArgumentsFromMarker(marker.getAttribute("arguments", ""));
        }
        return null;
    }

    public int getId() {
        IMarker marker = this.getMarker();
        if (marker == null || !marker.exists()) {
            return -1;
        }
        if (this.isProblem()) {
            return marker.getAttribute("id", -1);
        }
        return -1;
    }

    public boolean isProblem() {
        String type = this.getType();
        return WARNING_ANNOTATION_TYPE.equals(type) || ERROR_ANNOTATION_TYPE.equals(type);
    }

    public void setOverlay(IJavaAnnotation javaAnnotation) {
        if (this.fOverlay != null) {
            this.fOverlay.removeOverlaid(this);
        }
        this.fOverlay = javaAnnotation;
        if (!this.isMarkedDeleted()) {
            this.markDeleted(this.fOverlay != null);
        }
        if (this.fOverlay != null) {
            this.fOverlay.addOverlaid(this);
        }
    }

    public boolean hasOverlay() {
        return this.fOverlay != null;
    }

    public IJavaAnnotation getOverlay() {
        return this.fOverlay;
    }

    public void addOverlaid(IJavaAnnotation annotation) {
    }

    public void removeOverlaid(IJavaAnnotation annotation) {
    }

    public Iterator getOverlaidIterator() {
        return null;
    }

    public ICompilationUnit getCompilationUnit() {
        IJavaElement element = JavaCore.create(this.getMarker().getResource());
        if (element instanceof ICompilationUnit) {
            ICompilationUnit cu = (ICompilationUnit)element;
            ICompilationUnit workingCopy = EditorUtility.getWorkingCopy(cu);
            if (workingCopy != null) {
                return workingCopy;
            }
            return cu;
        }
        return null;
    }
}

