/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.viewsupport;

import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.core.IField;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IMethod;
import net.sourceforge.phpdt.core.IPackageFragment;
import net.sourceforge.phpdt.core.IPackageFragmentRoot;
import net.sourceforge.phpdt.core.IType;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.core.Signature;
import net.sourceforge.phpdt.internal.corext.util.JavaModelUtil;
import net.sourceforge.phpdt.internal.ui.PHPUIMessages;
import net.sourceforge.phpdt.ui.PreferenceConstants;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class JavaElementLabels {
    public static final int M_PARAMETER_TYPES = 1;
    public static final int M_PARAMETER_NAMES = 2;
    public static final int M_EXCEPTIONS = 4;
    public static final int M_APP_RETURNTYPE = 8;
    public static final int M_PRE_RETURNTYPE = 16;
    public static final int M_FULLY_QUALIFIED = 32;
    public static final int M_POST_QUALIFIED = 64;
    public static final int I_FULLY_QUALIFIED = 128;
    public static final int I_POST_QUALIFIED = 256;
    public static final int F_APP_TYPE_SIGNATURE = 512;
    public static final int F_PRE_TYPE_SIGNATURE = 1024;
    public static final int F_FULLY_QUALIFIED = 2048;
    public static final int F_POST_QUALIFIED = 4096;
    public static final int T_FULLY_QUALIFIED = 8192;
    public static final int T_CONTAINER_QUALIFIED = 16384;
    public static final int T_POST_QUALIFIED = 32768;
    public static final int D_QUALIFIED = 65536;
    public static final int D_POST_QUALIFIED = 131072;
    public static final int CF_QUALIFIED = 262144;
    public static final int CF_POST_QUALIFIED = 524288;
    public static final int CU_QUALIFIED = 0x100000;
    public static final int CU_POST_QUALIFIED = 0x200000;
    public static final int P_QUALIFIED = 0x400000;
    public static final int P_POST_QUALIFIED = 0x800000;
    public static final int ROOT_VARIABLE = 0x1000000;
    public static final int ROOT_QUALIFIED = 0x2000000;
    public static final int ROOT_POST_QUALIFIED = 0x4000000;
    public static final int APPEND_ROOT_PATH = 0x8000000;
    public static final int PREPEND_ROOT_PATH = 0x10000000;
    public static final int P_COMPRESSED = 0x20000000;
    public static final int REFERENCED_ROOT_POST_QUALIFIED = 0x40000000;
    public static final int ALL_FULLY_QUALIFIED = 39135392;
    public static final int ALL_POST_QUALIFIED = 78287168;
    public static final int ALL_DEFAULT = 1;
    public static final int DEFAULT_QUALIFIED = 1386656;
    public static final int DEFAULT_POST_QUALIFIED = 2789696;
    public static final String CONCAT_STRING = PHPUIMessages.getString("JavaElementLabels.concat_string");
    public static final String COMMA_STRING = PHPUIMessages.getString("JavaElementLabels.comma_string");
    public static final String DECL_STRING = PHPUIMessages.getString("JavaElementLabels.declseparator_string");
    private static String fgPkgNamePattern = "";
    private static String fgPkgNamePrefix;
    private static String fgPkgNamePostfix;
    private static int fgPkgNameChars;
    private static int fgPkgNameLength;
    static /* synthetic */ Class class$0;

    static {
        fgPkgNameLength = -1;
    }

    private JavaElementLabels() {
    }

    private static boolean getFlag(int flags, int flag) {
        return (flags & flag) != 0;
    }

    public static String getTextLabel(Object obj, int flags) {
        if (obj instanceof IJavaElement) {
            return JavaElementLabels.getElementLabel((IJavaElement)obj, flags);
        }
        if (obj instanceof IAdaptable) {
            IWorkbenchAdapter wbadapter;
            IAdaptable iAdaptable = (IAdaptable)obj;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((wbadapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                return wbadapter.getLabel(obj);
            }
        }
        return "";
    }

    public static String getElementLabel(IJavaElement element, int flags) {
        StringBuffer buf = new StringBuffer(60);
        JavaElementLabels.getElementLabel(element, flags, buf);
        return buf.toString();
    }

    public static void getElementLabel(IJavaElement element, int flags, StringBuffer buf) {
        int type = element.getElementType();
        IPackageFragmentRoot root = null;
        if (type != 1 && type != 2 && type != 3) {
            root = JavaModelUtil.getPackageFragmentRoot(element);
        }
        if (root != null && JavaElementLabels.getFlag(flags, 0x10000000)) {
            JavaElementLabels.getPackageFragmentRootLabel(root, 0x2000000, buf);
            buf.append(CONCAT_STRING);
        }
        switch (type) {
            case 9: {
                JavaElementLabels.getMethodLabel((IMethod)element, flags, buf);
                break;
            }
            case 8: {
                JavaElementLabels.getFieldLabel((IField)element, flags, buf);
                break;
            }
            case 7: {
                JavaElementLabels.getTypeLabel((IType)element, flags, buf);
                break;
            }
            case 5: {
                JavaElementLabels.getCompilationUnitLabel((ICompilationUnit)element, flags, buf);
                break;
            }
            case 4: {
                JavaElementLabels.getPackageFragmentLabel((IPackageFragment)element, flags, buf);
                break;
            }
            case 3: {
                JavaElementLabels.getPackageFragmentRootLabel((IPackageFragmentRoot)element, flags, buf);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                JavaElementLabels.getDeclararionLabel(element, flags, buf);
                break;
            }
            case 1: 
            case 2: {
                buf.append(element.getElementName());
                break;
            }
            default: {
                buf.append(element.getElementName());
            }
        }
        if (root != null && JavaElementLabels.getFlag(flags, 0x8000000)) {
            buf.append(CONCAT_STRING);
            JavaElementLabels.getPackageFragmentRootLabel(root, 0x2000000, buf);
        }
    }

    public static void getMethodLabel(IMethod method, int flags, StringBuffer buf) {
        try {
            String[] types;
            if (JavaElementLabels.getFlag(flags, 16) && method.exists() && !method.isConstructor()) {
                buf.append(Signature.getSimpleName(Signature.toString(method.getReturnType())));
                buf.append(' ');
            }
            if (JavaElementLabels.getFlag(flags, 32)) {
                JavaElementLabels.getTypeLabel(method.getDeclaringType(), 0x2000 | flags & 0x20000000, buf);
                buf.append('.');
            }
            buf.append(method.getElementName());
            if (JavaElementLabels.getFlag(flags, 3)) {
                buf.append('(');
                types = JavaElementLabels.getFlag(flags, 1) ? method.getParameterTypes() : null;
                String[] names = JavaElementLabels.getFlag(flags, 2) && method.exists() ? method.getParameterNames() : null;
                int nParams = types != null ? types.length : names.length;
                int i = 0;
                while (i < nParams) {
                    if (i > 0) {
                        buf.append(COMMA_STRING);
                    }
                    if (types != null) {
                        buf.append(Signature.getSimpleName(Signature.toString(types[i])));
                    }
                    if (names != null) {
                        if (types != null) {
                            buf.append(' ');
                        }
                        buf.append(names[i]);
                    }
                    ++i;
                }
                buf.append(')');
            }
            if (JavaElementLabels.getFlag(flags, 4) && method.exists() && (types = method.getExceptionTypes()).length > 0) {
                buf.append(" throws ");
                int i = 0;
                while (i < types.length) {
                    if (i > 0) {
                        buf.append(COMMA_STRING);
                    }
                    buf.append(Signature.getSimpleName(Signature.toString(types[i])));
                    ++i;
                }
            }
            if (JavaElementLabels.getFlag(flags, 8) && method.exists() && !method.isConstructor()) {
                buf.append(DECL_STRING);
                buf.append(Signature.getSimpleName(Signature.toString(method.getReturnType())));
            }
            if (JavaElementLabels.getFlag(flags, 64)) {
                buf.append(CONCAT_STRING);
                JavaElementLabels.getTypeLabel(method.getDeclaringType(), 0x2000 | flags & 0x20000000, buf);
            }
        }
        catch (JavaModelException e) {
            PHPeclipsePlugin.log((Throwable)((Object)e));
        }
    }

    public static void getFieldLabel(IField field, int flags, StringBuffer buf) {
        try {
            if (JavaElementLabels.getFlag(flags, 1024) && field.exists()) {
                buf.append(Signature.toString(field.getTypeSignature()));
                buf.append(' ');
            }
            if (JavaElementLabels.getFlag(flags, 2048)) {
                JavaElementLabels.getTypeLabel(field.getDeclaringType(), 0x2000 | flags & 0x20000000, buf);
                buf.append('.');
            }
            buf.append(field.getElementName());
            if (JavaElementLabels.getFlag(flags, 512) && field.exists()) {
                buf.append(DECL_STRING);
                buf.append(Signature.toString(field.getTypeSignature()));
            }
            if (JavaElementLabels.getFlag(flags, 4096)) {
                buf.append(CONCAT_STRING);
                JavaElementLabels.getTypeLabel(field.getDeclaringType(), 0x2000 | flags & 0x20000000, buf);
            }
        }
        catch (JavaModelException e) {
            PHPeclipsePlugin.log((Throwable)((Object)e));
        }
    }

    public static void getTypeLabel(IType type, int flags, StringBuffer buf) {
        if (JavaElementLabels.getFlag(flags, 8192)) {
            if (type != null) {
                IPackageFragment pack = type.getPackageFragment();
                if (!pack.isDefaultPackage()) {
                    JavaElementLabels.getPackageFragmentLabel(pack, flags & 0x20000000, buf);
                    buf.append('.');
                }
                buf.append(JavaModelUtil.getTypeQualifiedName(type));
            }
        } else if (JavaElementLabels.getFlag(flags, 16384)) {
            buf.append(JavaModelUtil.getTypeQualifiedName(type));
        } else {
            buf.append(type.getElementName());
        }
        if (JavaElementLabels.getFlag(flags, 32768)) {
            buf.append(CONCAT_STRING);
            IType declaringType = type.getDeclaringType();
            if (declaringType != null) {
                JavaElementLabels.getTypeLabel(declaringType, 0x2000 | flags & 0x20000000, buf);
            } else {
                JavaElementLabels.getPackageFragmentLabel(type.getPackageFragment(), flags & 0x20000000, buf);
            }
        }
    }

    public static void getDeclararionLabel(IJavaElement declaration, int flags, StringBuffer buf) {
        IJavaElement openable;
        if (JavaElementLabels.getFlag(flags, 65536) && (openable = (IJavaElement)((Object)declaration.getOpenable())) != null) {
            buf.append(JavaElementLabels.getElementLabel(openable, 0x140000));
            buf.append('/');
        }
        if (declaration.getElementType() == 12) {
            buf.append(PHPUIMessages.getString("JavaElementLabels.import_container"));
        } else {
            buf.append(declaration.getElementName());
        }
        if (JavaElementLabels.getFlag(flags, 131072) && (openable = (IJavaElement)((Object)declaration.getOpenable())) != null) {
            buf.append(CONCAT_STRING);
            buf.append(JavaElementLabels.getElementLabel(openable, 0x140000));
        }
    }

    public static void getCompilationUnitLabel(ICompilationUnit cu, int flags, StringBuffer buf) {
        IPackageFragment pack;
        if (JavaElementLabels.getFlag(flags, 0x100000) && !(pack = (IPackageFragment)cu.getParent()).isDefaultPackage()) {
            buf.append(pack.getElementName());
            buf.append('.');
        }
        buf.append(cu.getElementName());
        if (JavaElementLabels.getFlag(flags, 0x200000)) {
            buf.append(CONCAT_STRING);
            JavaElementLabels.getPackageFragmentLabel((IPackageFragment)cu.getParent(), 0, buf);
        }
    }

    public static void getPackageFragmentLabel(IPackageFragment pack, int flags, StringBuffer buf) {
        if (JavaElementLabels.getFlag(flags, 0x400000)) {
            JavaElementLabels.getPackageFragmentRootLabel((IPackageFragmentRoot)pack.getParent(), 0x2000000, buf);
            buf.append('/');
        }
        JavaElementLabels.refreshPackageNamePattern();
        if (pack.isDefaultPackage()) {
            buf.append(PHPUIMessages.getString("JavaElementLabels.default_package"));
        } else if (JavaElementLabels.getFlag(flags, 0x20000000) && fgPkgNameLength >= 0) {
            String name = pack.getElementName();
            int start = 0;
            int dot = name.indexOf(46, start);
            while (dot > 0) {
                if (dot - start > fgPkgNameLength - 1) {
                    buf.append(fgPkgNamePrefix);
                    if (fgPkgNameChars > 0) {
                        buf.append(name.substring(start, Math.min(start + fgPkgNameChars, dot)));
                    }
                    buf.append(fgPkgNamePostfix);
                } else {
                    buf.append(name.substring(start, dot + 1));
                }
                start = dot + 1;
                dot = name.indexOf(46, start);
            }
            buf.append(name.substring(start));
        } else {
            buf.append(pack.getElementName());
        }
        if (JavaElementLabels.getFlag(flags, 0x800000)) {
            buf.append(CONCAT_STRING);
            JavaElementLabels.getPackageFragmentRootLabel((IPackageFragmentRoot)pack.getParent(), 0x2000000, buf);
        }
    }

    public static void getPackageFragmentRootLabel(IPackageFragmentRoot root, int flags, StringBuffer buf) {
        if (root.isArchive()) {
            JavaElementLabels.getArchiveLabel(root, flags, buf);
        } else {
            JavaElementLabels.getFolderLabel(root, flags, buf);
        }
    }

    private static void getArchiveLabel(IPackageFragmentRoot root, int flags, StringBuffer buf) {
        if (JavaElementLabels.getFlag(flags, 0x1000000) && JavaElementLabels.getVariableLabel(root, flags, buf)) {
            return;
        }
        boolean external = root.isExternal();
        if (external) {
            JavaElementLabels.getExternalArchiveLabel(root, flags, buf);
        } else {
            JavaElementLabels.getInternalArchiveLabel(root, flags, buf);
        }
    }

    private static boolean getVariableLabel(IPackageFragmentRoot root, int flags, StringBuffer buf) {
        return false;
    }

    private static void getExternalArchiveLabel(IPackageFragmentRoot root, int flags, StringBuffer buf) {
        IPath path = root.getPath();
        if (JavaElementLabels.getFlag(flags, 0x40000000)) {
            int segements = path.segmentCount();
            if (segements > 0) {
                buf.append(path.segment(segements - 1));
                if (segements > 1 || path.getDevice() != null) {
                    buf.append(CONCAT_STRING);
                    buf.append(path.removeLastSegments(1).toOSString());
                }
            } else {
                buf.append(path.toOSString());
            }
        } else {
            buf.append(path.toOSString());
        }
    }

    private static void getInternalArchiveLabel(IPackageFragmentRoot root, int flags, StringBuffer buf) {
        boolean referencedQualified;
        IResource resource = root.getResource();
        boolean rootQualified = JavaElementLabels.getFlag(flags, 0x2000000);
        boolean bl = referencedQualified = JavaElementLabels.getFlag(flags, 0x40000000) && JavaModelUtil.isReferenced(root) && resource != null;
        if (rootQualified) {
            buf.append(root.getPath().makeRelative().toString());
        } else {
            buf.append(root.getElementName());
            if (referencedQualified) {
                buf.append(CONCAT_STRING);
                buf.append(resource.getParent().getFullPath().makeRelative().toString());
            } else if (JavaElementLabels.getFlag(flags, 0x4000000)) {
                buf.append(CONCAT_STRING);
                buf.append(root.getParent().getPath().makeRelative().toString());
            }
        }
    }

    private static void getFolderLabel(IPackageFragmentRoot root, int flags, StringBuffer buf) {
        boolean referencedQualified;
        IResource resource = root.getResource();
        boolean rootQualified = JavaElementLabels.getFlag(flags, 0x2000000);
        boolean bl = referencedQualified = JavaElementLabels.getFlag(flags, 0x40000000) && JavaModelUtil.isReferenced(root) && resource != null;
        if (rootQualified) {
            buf.append(root.getPath().makeRelative().toString());
        } else {
            if (resource != null) {
                buf.append(resource.getProjectRelativePath().toString());
            } else {
                buf.append(root.getElementName());
            }
            if (referencedQualified) {
                buf.append(CONCAT_STRING);
                buf.append(resource.getProject().getName());
            } else if (JavaElementLabels.getFlag(flags, 0x4000000)) {
                buf.append(CONCAT_STRING);
                buf.append(root.getParent().getElementName());
            }
        }
    }

    private static void refreshPackageNamePattern() {
        String pattern = JavaElementLabels.getPkgNamePatternForPackagesView();
        if (pattern.equals(fgPkgNamePattern)) {
            return;
        }
        if (pattern.equals("")) {
            fgPkgNamePattern = "";
            fgPkgNameLength = -1;
            return;
        }
        fgPkgNamePattern = pattern;
        int i = 0;
        fgPkgNameChars = 0;
        fgPkgNamePrefix = "";
        fgPkgNamePostfix = "";
        while (i < pattern.length()) {
            char ch = pattern.charAt(i);
            if (Character.isDigit(ch)) {
                fgPkgNameChars = ch - 48;
                if (i > 0) {
                    fgPkgNamePrefix = pattern.substring(0, i);
                }
                if (i >= 0) {
                    fgPkgNamePostfix = pattern.substring(i + 1);
                }
                fgPkgNameLength = fgPkgNamePrefix.length() + fgPkgNameChars + fgPkgNamePostfix.length();
                return;
            }
            ++i;
        }
        fgPkgNamePrefix = pattern;
        fgPkgNameLength = pattern.length();
    }

    private static String getPkgNamePatternForPackagesView() {
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        if (!store.getBoolean("net.sourceforge.phpdt.ui.compresspackagenames")) {
            return "";
        }
        return store.getString("PackagesView.pkgNamePatternForPackagesView");
    }
}

