/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.util;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class ResourceSelector {
    protected static final String EMPTY_STRING = "";
    protected Composite composite;
    protected Button browseButton;
    protected Text textField;
    protected String browseDialogMessage = "";
    protected String browseDialogTitle = "";
    protected String validatedSelectionText = "";

    public ResourceSelector(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.marginWidth = 0;
        compositeLayout.marginHeight = 0;
        compositeLayout.numColumns = 2;
        this.composite.setLayout((Layout)compositeLayout);
        this.textField = new Text(this.composite, 2052);
        this.textField.setLayoutData((Object)new GridData(768));
        this.textField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ResourceSelector.this.validatedSelectionText = ResourceSelector.this.validateResourceSelection();
            }
        });
        this.browseButton = new Button(this.composite, 8);
        this.browseButton.setText("Browse...");
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceSelector.this.handleBrowseSelected();
            }
        });
    }

    protected abstract void handleBrowseSelected();

    protected abstract String validateResourceSelection();

    protected Shell getShell() {
        return this.composite.getShell();
    }

    public void setLayoutData(Object layoutData) {
        this.composite.setLayoutData(layoutData);
    }

    public void addModifyListener(ModifyListener aListener) {
        this.textField.addModifyListener(aListener);
    }

    public void setBrowseDialogMessage(String aMessage) {
        this.browseDialogMessage = aMessage;
    }

    public void setBrowseDialogTitle(String aTitle) {
        this.browseDialogTitle = aTitle;
    }

    public void setEnabled(boolean enabled) {
        this.composite.setEnabled(enabled);
        this.textField.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
    }

    public String getSelectionText() {
        return this.textField.getText();
    }

    public String getValidatedSelectionText() {
        return this.validatedSelectionText;
    }

    public void setSelectionText(String newText) {
        this.textField.setText(newText);
    }
}

