/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.phpdt.internal.corext.Assert;
import net.sourceforge.phpdt.internal.ui.PHPUIMessages;
import net.sourceforge.phpdt.internal.ui.text.HTMLPrinter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;

public class JavaAnnotationHover
implements IAnnotationHover {
    public static final JavaAnnotationHoverType OVERVIEW_RULER_HOVER = new JavaAnnotationHoverType();
    public static final JavaAnnotationHoverType TEXT_RULER_HOVER = new JavaAnnotationHoverType();
    public static final JavaAnnotationHoverType VERTICAL_RULER_HOVER = new JavaAnnotationHoverType();
    private IPreferenceStore fStore = EditorsUI.getPreferenceStore();
    private JavaAnnotationHoverType fType;

    public JavaAnnotationHover(JavaAnnotationHoverType type) {
        Assert.isTrue(OVERVIEW_RULER_HOVER.equals(type) || TEXT_RULER_HOVER.equals(type) || VERTICAL_RULER_HOVER.equals(type));
        this.fType = type;
    }

    protected int compareRulerLine(Position position, IDocument document, int line) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            int javaAnnotationLine;
            block5: {
                try {
                    javaAnnotationLine = document.getLineOfOffset(position.getOffset());
                    if (line != javaAnnotationLine) break block5;
                    return 1;
                }
                catch (BadLocationException badLocationException) {}
            }
            if (javaAnnotationLine <= line && line <= document.getLineOfOffset(position.getOffset() + position.getLength())) {
                return 2;
            }
        }
        return 0;
    }

    protected List select(List exactMatch, List including) {
        return exactMatch;
    }

    protected List getJavaAnnotationsForLine(ISourceViewer viewer, int line) {
        IDocument document = viewer.getDocument();
        IAnnotationModel model = viewer.getAnnotationModel();
        if (model == null) {
            return null;
        }
        ArrayList<Annotation> exact = new ArrayList<Annotation>();
        ArrayList<Annotation> including = new ArrayList<Annotation>();
        Iterator e = model.getAnnotationIterator();
        HashMap messagesAtPosition = new HashMap();
        while (e.hasNext()) {
            String key;
            AnnotationPreference preference;
            Position position;
            Annotation annotation = (Annotation)e.next();
            if (annotation.getText() == null || (position = model.getPosition(annotation)) == null || (preference = this.getAnnotationPreference(annotation)) == null || (!OVERVIEW_RULER_HOVER.equals(this.fType) ? (!TEXT_RULER_HOVER.equals(this.fType) ? VERTICAL_RULER_HOVER.equals(this.fType) && (key = preference.getVerticalRulerPreferenceKey()) != null && !this.fStore.getBoolean(key) : ((key = preference.getTextPreferenceKey()) != null ? !this.fStore.getBoolean(key) : (key = preference.getHighlightPreferenceKey()) == null || !this.fStore.getBoolean(key))) : (key = preference.getOverviewRulerPreferenceKey()) == null || !this.fStore.getBoolean(key)) || this.isDuplicateJavaAnnotation(messagesAtPosition, position, annotation.getText())) continue;
            switch (this.compareRulerLine(position, document, line)) {
                case 1: {
                    exact.add(annotation);
                    break;
                }
                case 2: {
                    including.add(annotation);
                }
            }
        }
        return this.select(exact, including);
    }

    private boolean isDuplicateJavaAnnotation(Map messagesAtPosition, Position position, String message) {
        if (messagesAtPosition.containsKey(position)) {
            Object value = messagesAtPosition.get(position);
            if (message.equals(value)) {
                return true;
            }
            if (value instanceof List) {
                List messages = (List)value;
                if (messages.contains(message)) {
                    return true;
                }
                messages.add(message);
            } else {
                ArrayList<Object> messages = new ArrayList<Object>();
                messages.add(value);
                messages.add(message);
                messagesAtPosition.put(position, messages);
            }
        } else {
            messagesAtPosition.put(position, message);
        }
        return false;
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        List javaAnnotations = this.getJavaAnnotationsForLine(sourceViewer, lineNumber);
        if (javaAnnotations != null) {
            if (javaAnnotations.size() == 1) {
                Annotation annotation = (Annotation)javaAnnotations.get(0);
                String message = annotation.getText();
                if (message != null && message.trim().length() > 0) {
                    return this.formatSingleMessage(message);
                }
            } else {
                ArrayList<String> messages = new ArrayList<String>();
                Iterator e = javaAnnotations.iterator();
                while (e.hasNext()) {
                    Annotation annotation = (Annotation)e.next();
                    String message = annotation.getText();
                    if (message == null || message.trim().length() <= 0) continue;
                    messages.add(message.trim());
                }
                if (messages.size() == 1) {
                    return this.formatSingleMessage((String)messages.get(0));
                }
                if (messages.size() > 1) {
                    return this.formatMultipleMessages(messages);
                }
            }
        }
        return null;
    }

    private String formatSingleMessage(String message) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addPageProlog(buffer);
        HTMLPrinter.addParagraph(buffer, HTMLPrinter.convertToHTMLContent(message));
        HTMLPrinter.addPageEpilog(buffer);
        return buffer.toString();
    }

    private String formatMultipleMessages(List messages) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addPageProlog(buffer);
        HTMLPrinter.addParagraph(buffer, HTMLPrinter.convertToHTMLContent(PHPUIMessages.getString("JavaAnnotationHover.multipleMarkersAtThisLine")));
        HTMLPrinter.startBulletList(buffer);
        Iterator e = messages.iterator();
        while (e.hasNext()) {
            HTMLPrinter.addBullet(buffer, HTMLPrinter.convertToHTMLContent((String)e.next()));
        }
        HTMLPrinter.endBulletList(buffer);
        HTMLPrinter.addPageEpilog(buffer);
        return buffer.toString();
    }

    private AnnotationPreference getAnnotationPreference(Annotation annotation) {
        return EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
    }

    private static class JavaAnnotationHoverType {
        private JavaAnnotationHoverType() {
        }
    }
}

