/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.corext.textmanipulation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.phpdt.internal.corext.textmanipulation.MoveTextEdit;
import net.sourceforge.phpdt.internal.corext.textmanipulation.NopTextEdit;
import net.sourceforge.phpdt.internal.corext.textmanipulation.TextBuffer;
import net.sourceforge.phpdt.internal.corext.textmanipulation.TextEdit;
import net.sourceforge.phpdt.internal.corext.textmanipulation.TextRange;
import net.sourceforge.phpdt.internal.corext.textmanipulation.UndoMemento;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;

abstract class TextEditNode {
    TextEditNode fParent;
    List fChildren;
    TextEdit fEdit;

    static TextEditNode create(TextEdit edit) {
        if (edit instanceof MoveTextEdit) {
            return new MoveNode(edit);
        }
        if (edit instanceof MoveTextEdit.TargetMark) {
            return new TargetMarkNode(edit);
        }
        return new DefaultNode(edit);
    }

    static RootNode createRoot(int length) {
        return new RootNode(length);
    }

    private TextEditNode(TextEdit edit) {
        this.fEdit = edit;
    }

    protected void add(TextEditNode node) {
        TextEditNode child;
        if (this.fChildren == null) {
            this.fChildren = new ArrayList(1);
            node.fParent = this;
            this.fChildren.add(node);
            return;
        }
        Iterator iter = this.fChildren.iterator();
        while (iter.hasNext()) {
            child = (TextEditNode)iter.next();
            if (!child.covers(node)) continue;
            child.add(node);
            return;
        }
        int i = 0;
        while (i < this.fChildren.size()) {
            child = (TextEditNode)this.fChildren.get(i);
            if (node.covers(child)) {
                this.fChildren.remove(i);
                node.add(child);
                continue;
            }
            ++i;
        }
        node.fParent = this;
        this.fChildren.add(node);
    }

    public boolean covers(TextEditNode node) {
        return false;
    }

    protected RootNode getRoot() {
        TextEditNode candidate = this;
        while (candidate.fParent != null) {
            candidate = candidate.fParent;
        }
        return (RootNode)candidate;
    }

    protected boolean isSynthetic() {
        return this.fEdit.isSynthetic;
    }

    public boolean isMove() {
        return false;
    }

    protected void checkRange(DocumentEvent event) {
        this.getTextRange();
        int eventOffset = event.getOffset();
        int eventLength = event.getLength();
    }

    protected TextRange getTextRange() {
        return this.fEdit.getTextRange();
    }

    protected TextRange getChildRange() {
        return this.getTextRange();
    }

    protected TextRange getParentRange() {
        return this.getTextRange();
    }

    public boolean validate(int bufferLength) {
        if (this.fChildren == null) {
            return true;
        }
        if (!(this.fEdit instanceof MoveTextEdit) && !(this.fEdit instanceof NopTextEdit)) {
            return false;
        }
        TextRange lastRange = null;
        Iterator iter = this.fChildren.iterator();
        while (iter.hasNext()) {
            TextEditNode node = (TextEditNode)iter.next();
            if (!node.validate(bufferLength)) {
                return false;
            }
            TextRange range = node.fEdit.getTextRange();
            if (!range.isValid() || range.fOffset + range.fLength > bufferLength) {
                return false;
            }
            if (lastRange != null && !range.isInsertionPointAt(lastRange.fOffset) && !range.liesBehind(lastRange)) {
                return false;
            }
            lastRange = range;
        }
        return true;
    }

    protected boolean activeNodeChanged(int delta) {
        TextRange range = this.getTextRange();
        range.fLength += delta;
        return false;
    }

    protected void previousNodeChanged(int delta) {
        TextRange range = this.getTextRange();
        range.fOffset += delta;
    }

    protected void childNodeChanged(int delta) {
        this.getTextRange().fLength += delta;
    }

    protected void performDo(TextBuffer buffer, RangeUpdater updater, UndoMemento undo, IProgressMonitor pm) throws CoreException {
        int size = this.fChildren != null ? this.fChildren.size() : 0;
        int i = size - 1;
        while (i >= 0) {
            TextEditNode child = (TextEditNode)this.fChildren.get(i);
            child.performDo(buffer, updater, undo, pm);
            --i;
        }
        updater.setActiveNode(this);
        if (this.isSynthetic()) {
            this.fEdit.perform(buffer);
        } else {
            undo.add(this.fEdit.perform(buffer));
        }
        pm.worked(1);
    }

    public void performedDo() {
        int size = this.fChildren != null ? this.fChildren.size() : 0;
        int i = size - 1;
        while (i >= 0) {
            TextEditNode child = (TextEditNode)this.fChildren.get(i);
            child.performedDo();
            --i;
        }
        this.fEdit.performed();
    }

    protected void performUndo(TextBuffer buffer, RangeUpdater updater, UndoMemento undo, IProgressMonitor pm) throws CoreException {
        int size = this.fChildren != null ? this.fChildren.size() : 0;
        int i = 0;
        while (i < size) {
            this.setUndoIndex(i);
            TextEditNode child = (TextEditNode)this.fChildren.get(i);
            child.performUndo(buffer, updater, undo, pm);
            ++i;
        }
        updater.setActiveNode(this);
        if (this.isSynthetic()) {
            this.fEdit.perform(buffer);
        } else {
            undo.add(this.fEdit.perform(buffer));
        }
        pm.worked(1);
    }

    protected void setUndoIndex(int index) {
    }

    public void performedUndo() {
        int size = this.fChildren != null ? this.fChildren.size() : 0;
        int i = 0;
        while (i < size) {
            TextEditNode child = (TextEditNode)this.fChildren.get(i);
            child.performedUndo();
            ++i;
        }
        this.fEdit.performed();
    }

    /* synthetic */ TextEditNode(TextEdit textEdit, TextEditNode textEditNode) {
        this(textEdit);
    }

    static abstract class AbstractMoveNode
    extends TextEditNode {
        private int state;
        private int fTargetIndex;
        private int fSourceIndex;
        private List fAffectedChildren;

        public AbstractMoveNode(TextEdit edit) {
            super(edit, null);
            this.reset();
        }

        protected abstract TextRange getSourceRange();

        protected abstract TextRange getTargetRange();

        protected abstract boolean isUpMove();

        protected boolean isDownMove() {
            return !this.isUpMove();
        }

        public boolean isMove() {
            return true;
        }

        protected void checkRange(DocumentEvent event) {
            this.getChildRange();
            int eventOffset = event.getOffset();
            int eventLength = event.getLength();
        }

        protected boolean activeNodeChanged(int delta) {
            TextRange targetRange = this.getTargetRange();
            TextRange sourceRange = this.getSourceRange();
            switch (this.state) {
                case 0: {
                    this.init();
                    if (this.isUpMove()) {
                        AbstractMoveNode.updateOffset(this.fAffectedChildren, delta);
                        targetRange.fOffset += delta;
                    }
                    sourceRange.fLength = 0;
                    this.state = 1;
                    break;
                }
                case 1: {
                    TextEditNode target = (TextEditNode)this.fParent.fChildren.get(this.fTargetIndex);
                    TextEditNode source = (TextEditNode)this.fParent.fChildren.get(this.fSourceIndex);
                    AbstractMoveNode.updateOffset(source.fChildren, targetRange.fOffset - sourceRange.fOffset);
                    target.fChildren = source.fChildren;
                    if (target.fChildren != null) {
                        Iterator iter = target.fChildren.iterator();
                        while (iter.hasNext()) {
                            ((TextEditNode)iter.next()).fParent = target;
                        }
                    }
                    source.fChildren = null;
                    if (this.isDownMove()) {
                        AbstractMoveNode.updateOffset(this.fAffectedChildren, delta);
                        sourceRange.fOffset += delta;
                    }
                    targetRange.fLength = delta;
                    this.reset();
                }
            }
            return true;
        }

        private static void updateOffset(List nodes, int delta) {
            if (nodes == null) {
                return;
            }
            int i = nodes.size() - 1;
            while (i >= 0) {
                TextEditNode node = (TextEditNode)nodes.get(i);
                TextRange range = node.getTextRange();
                range.fOffset += delta;
                AbstractMoveNode.updateOffset(node.fChildren, delta);
                --i;
            }
        }

        private void init() {
            TextRange source = this.getSourceRange();
            TextRange target = this.getTargetRange();
            List children = this.fParent.fChildren;
            int i = children.size() - 1;
            while (i >= 0) {
                TextEditNode child = (TextEditNode)children.get(i);
                TextRange range = child.fEdit.getTextRange();
                if (range == source) {
                    this.fSourceIndex = i;
                } else if (range == target) {
                    this.fTargetIndex = i;
                }
                --i;
            }
            int start = Math.min(this.fTargetIndex, this.fSourceIndex);
            int end = Math.max(this.fTargetIndex, this.fSourceIndex);
            this.fAffectedChildren = new ArrayList(3);
            int i2 = start + 1;
            while (i2 < end) {
                this.fAffectedChildren.add(children.get(i2));
                ++i2;
            }
        }

        private void reset() {
            this.state = 0;
            this.fSourceIndex = -1;
            this.fTargetIndex = -1;
        }
    }

    static class DefaultNode
    extends TextEditNode {
        public DefaultNode(TextEdit edit) {
            super(edit, null);
        }
    }

    private static class DoRangeUpdater
    extends RangeUpdater {
        private List fProcessedNodes = new ArrayList(10);

        private DoRangeUpdater() {
        }

        public void setActiveNode(TextEditNode node) {
            if (this.fActiveNode != null) {
                this.fProcessedNodes.add(this.fActiveNode);
            }
            super.setActiveNode(node);
        }

        public void documentChanged(DocumentEvent event) {
            this.fActiveNode.checkRange(event);
            int delta = DoRangeUpdater.getDelta(event);
            if (!this.fActiveNode.activeNodeChanged(delta)) {
                Iterator iter = this.fProcessedNodes.iterator();
                while (iter.hasNext()) {
                    ((TextEditNode)iter.next()).previousNodeChanged(delta);
                }
            }
            this.updateParents(delta);
        }
    }

    static class MoveNode
    extends AbstractMoveNode {
        public MoveNode(TextEdit edit) {
            super(edit);
        }

        protected TextRange getChildRange() {
            return ((MoveTextEdit)this.fEdit).getChildRange();
        }

        protected TextRange getSourceRange() {
            return ((MoveTextEdit)this.fEdit).getSourceRange();
        }

        protected TextRange getTargetRange() {
            return ((MoveTextEdit)this.fEdit).getTargetRange();
        }

        protected boolean isUpMove() {
            return ((MoveTextEdit)this.fEdit).isUpMove();
        }

        public boolean isMovePartner(TextEditNode other) {
            if (!(other instanceof TargetMarkNode)) {
                return false;
            }
            return this.fEdit == ((MoveTextEdit.TargetMark)other.fEdit).getMoveTextEdit();
        }

        public boolean covers(TextEditNode node) {
            MoveTextEdit.TargetMark edit;
            if (node instanceof TargetMarkNode && (edit = (MoveTextEdit.TargetMark)node.fEdit).getMoveTextEdit() == this.fEdit) {
                return false;
            }
            return this.getParentRange().covers(node.getChildRange());
        }
    }

    private static abstract class RangeUpdater
    implements IDocumentListener {
        protected TextEditNode fActiveNode;

        private RangeUpdater() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void setActiveNode(TextEditNode node) {
            this.fActiveNode = node;
        }

        public void updateParents(int delta) {
            TextEditNode node = this.fActiveNode.fParent;
            while (node != null) {
                node.childNodeChanged(delta);
                node = node.fParent;
            }
        }

        public static int getDelta(DocumentEvent event) {
            return (event.getText() == null ? 0 : event.getText().length()) - event.getLength();
        }
    }

    static class RootNode
    extends TextEditNode {
        private int fUndoIndex;

        public RootNode(int length) {
            super(new NopTextEdit(new TextRange(0, length)), null);
            this.fEdit.isSynthetic = true;
        }

        public boolean covers(TextEditNode node) {
            return true;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public UndoMemento performDo(TextBuffer buffer, IProgressMonitor pm) throws CoreException {
            DoRangeUpdater updater = new DoRangeUpdater();
            UndoMemento undo = new UndoMemento(2);
            try {
                buffer.registerUpdater(updater);
                this.performDo(buffer, updater, undo, pm);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                buffer.unregisterUpdater(updater);
                updater.setActiveNode(null);
                throw throwable;
            }
            {
                Object var5_7 = null;
                buffer.unregisterUpdater(updater);
                updater.setActiveNode(null);
                return undo;
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public UndoMemento performUndo(TextBuffer buffer, IProgressMonitor pm) throws CoreException {
            UndoRangeUpdater updater = new UndoRangeUpdater(this);
            UndoMemento undo = new UndoMemento(1);
            try {
                buffer.registerUpdater(updater);
                this.performUndo(buffer, updater, undo, pm);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                buffer.unregisterUpdater(updater);
                updater.setActiveNode(null);
                throw throwable;
            }
            {
                Object var5_7 = null;
                buffer.unregisterUpdater(updater);
                updater.setActiveNode(null);
                return undo;
            }
        }

        protected void setUndoIndex(int index) {
            this.fUndoIndex = index;
        }

        protected int getUndoIndex() {
            return this.fUndoIndex;
        }
    }

    static class TargetMarkNode
    extends AbstractMoveNode {
        public TargetMarkNode(TextEdit edit) {
            super(edit);
        }

        protected TextRange getChildRange() {
            return ((MoveTextEdit.TargetMark)this.fEdit).getMoveTextEdit().getChildRange();
        }

        protected TextRange getSourceRange() {
            return ((MoveTextEdit.TargetMark)this.fEdit).getMoveTextEdit().getSourceRange();
        }

        protected TextRange getTargetRange() {
            return ((MoveTextEdit.TargetMark)this.fEdit).getMoveTextEdit().getTargetRange();
        }

        protected boolean isUpMove() {
            return ((MoveTextEdit.TargetMark)this.fEdit).getMoveTextEdit().isUpMove();
        }

        public boolean isMovePartner(TextEditNode other) {
            return ((MoveTextEdit.TargetMark)this.fEdit).getMoveTextEdit() == other.fEdit;
        }
    }

    private static class UndoRangeUpdater
    extends RangeUpdater {
        private RootNode fRootNode;

        public UndoRangeUpdater(RootNode root) {
            this.fRootNode = root;
        }

        public void setActiveNode(TextEditNode node) {
            super.setActiveNode(node);
        }

        public void documentChanged(DocumentEvent event) {
            this.fActiveNode.checkRange(event);
            int delta = UndoRangeUpdater.getDelta(event);
            if (!this.fActiveNode.activeNodeChanged(delta)) {
                int start = this.fRootNode.getUndoIndex() + 1;
                List children = this.fRootNode.fChildren;
                int size = children != null ? children.size() : 0;
                int i = start;
                while (i < size) {
                    this.updateUndo((TextEditNode)children.get(i), delta);
                    ++i;
                }
            }
            this.updateParents(delta);
        }

        private void updateUndo(TextEditNode node, int delta) {
            node.previousNodeChanged(delta);
            List children = node.fChildren;
            int size = children != null ? children.size() : 0;
            int i = 0;
            while (i < size) {
                this.updateUndo((TextEditNode)children.get(i), delta);
                ++i;
            }
        }
    }
}

