/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.corext.template.php;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.sourceforge.phpdt.core.CompletionRequestorAdapter;
import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.core.compiler.IProblem;

class CompilationUnitCompletion
extends CompletionRequestorAdapter {
    private ICompilationUnit fUnit;
    private List fLocalVariables = new ArrayList();
    private Map fTypes = new HashMap();
    private boolean fError;

    public CompilationUnitCompletion(ICompilationUnit unit) {
        this.reset(unit);
    }

    public void reset(ICompilationUnit unit) {
        this.fUnit = unit;
        this.fLocalVariables.clear();
        this.fTypes.clear();
        this.fError = false;
    }

    public void acceptError(IProblem error) {
        this.fError = true;
    }

    public void acceptLocalVariable(char[] name, char[] typePackageName, char[] typeName, int modifiers, int completionStart, int completionEnd, int relevance) {
        this.fLocalVariables.add(new LocalVariable(new String(name), new String(typePackageName), new String(typeName)));
    }

    public boolean hasErrors() {
        return this.fError;
    }

    boolean existsLocalName(String name) {
        Iterator iterator = this.fLocalVariables.iterator();
        while (iterator.hasNext()) {
            LocalVariable localVariable = (LocalVariable)iterator.next();
            if (!localVariable.name.equals(name)) continue;
            return true;
        }
        return false;
    }

    String[] getLocalVariableNames() {
        String[] res = new String[this.fLocalVariables.size()];
        int i = 0;
        Iterator iterator = this.fLocalVariables.iterator();
        while (iterator.hasNext()) {
            LocalVariable localVariable = (LocalVariable)iterator.next();
            res[i++] = localVariable.name;
        }
        return res;
    }

    LocalVariable[] findLocalArrays() {
        Vector<LocalVariable> vector = new Vector<LocalVariable>();
        Iterator iterator = this.fLocalVariables.iterator();
        while (iterator.hasNext()) {
            LocalVariable localVariable = (LocalVariable)iterator.next();
            if (!CompilationUnitCompletion.isArray(localVariable.typeName)) continue;
            vector.add(localVariable);
        }
        return vector.toArray(new LocalVariable[vector.size()]);
    }

    String simplifyTypeName(String qualifiedName) {
        return (String)this.fTypes.get(qualifiedName);
    }

    private static boolean isArray(String type) {
        return type.endsWith("[]");
    }

    public void acceptClass(char[] packageName, char[] className, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
        String qualifiedName = CompilationUnitCompletion.createQualifiedTypeName(packageName, className);
        this.fTypes.put(qualifiedName, String.valueOf(completionName));
    }

    public void acceptInterface(char[] packageName, char[] interfaceName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
        String qualifiedName = CompilationUnitCompletion.createQualifiedTypeName(packageName, interfaceName);
        this.fTypes.put(qualifiedName, String.valueOf(completionName));
    }

    private static String createQualifiedTypeName(char[] packageName, char[] className) {
        StringBuffer buffer = new StringBuffer();
        if (packageName.length != 0) {
            buffer.append(packageName);
            buffer.append('.');
        }
        buffer.append(className);
        return buffer.toString();
    }

    static class LocalVariable {
        String name;
        String typePackageName;
        String typeName;

        LocalVariable(String name, String typePackageName, String typeName) {
            this.name = name;
            this.typePackageName = typePackageName;
            this.typeName = typeName;
        }
    }
}

