/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.corext.phpdoc;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import net.sourceforge.phpdt.internal.corext.phpdoc.PHPDocCharArrayCommentReader;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.builder.PHPIdentifierLocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PHPDocUtil {
    public static void appendPHPDoc(StringBuffer hoverInfoBuffer, String filename, PHPIdentifierLocation location) {
        hoverInfoBuffer.append(location.toString());
        hoverInfoBuffer.append(" - <b>");
        try {
            hoverInfoBuffer.append(PHPDocUtil.getUsage(filename, location));
            hoverInfoBuffer.append("</b><br>");
            if (location.getPHPDocOffset() >= 0) {
                InputStreamReader phpFileReader = PHPDocUtil.createReader(filename);
                if (phpFileReader == null) {
                    return;
                }
                char[] phpDocDeclarationCharArray = new char[location.getPHPDocLength()];
                phpFileReader.skip(location.getPHPDocOffset());
                phpFileReader.read(phpDocDeclarationCharArray, 0, location.getPHPDocLength());
                PHPDocCharArrayCommentReader phpdocConverter = new PHPDocCharArrayCommentReader(phpDocDeclarationCharArray);
                hoverInfoBuffer.append(phpdocConverter.getString());
                phpFileReader.close();
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    static String getEncoding(String filename) {
        String encoding = null;
        IFile file = PHPeclipsePlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(filename));
        if (file != null) {
            try {
                encoding = file.getCharset();
            }
            catch (CoreException coreException) {}
        }
        return encoding;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getUsage(String filename, PHPIdentifierLocation location) {
        String usage = location.getUsage();
        if (usage != null) {
            return usage;
        }
        usage = "";
        try {
            InputStreamReader phpFileReader = PHPDocUtil.createReader(filename);
            if (phpFileReader == null) {
                return "";
            }
            if (location.getOffset() >= 0 && (location.isMethod() || location.isConstructor() || location.isFunction() || location.isDefine())) {
                char[] functionDeclarationCharArray = new char[256];
                int offset = location.getOffset();
                phpFileReader.skip(offset);
                int length = phpFileReader.read(functionDeclarationCharArray, 0, 256);
                if (length == -1) {
                    length = 256;
                }
                if (location.isDefine()) {
                    length = PHPDocUtil.getClosingParenthesis(functionDeclarationCharArray);
                    if (length < 0) {
                        return "";
                    }
                } else {
                    int i = 0;
                    while (i < length) {
                        if (functionDeclarationCharArray[i] == ')') {
                            length = i + 1;
                            break;
                        }
                        if (functionDeclarationCharArray[i] == '{' || functionDeclarationCharArray[i] == '}') {
                            length = i;
                            break;
                        }
                        ++i;
                    }
                }
                usage = new String(functionDeclarationCharArray, 0, length);
                location.setUsage(usage);
            }
            phpFileReader.close();
            return usage;
        }
        catch (IOException iOException) {}
        return usage;
    }

    private static InputStreamReader createReader(String filename) {
        IFile file = PHPeclipsePlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(filename));
        if (file != null) {
            try {
                return new InputStreamReader((InputStream)new FileInputStream(file.getLocation().toString()), file.getCharset());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    private static int getClosingParenthesis(char[] buffer) {
        int p = 0;
        boolean dq = false;
        boolean sq = false;
        int i = 0;
        while (i < buffer.length) {
            if (buffer[i] == '\\') {
                ++i;
            } else if (dq) {
                dq = buffer[i] != '\"';
            } else if (sq) {
                sq = buffer[i] != '\'';
            } else {
                switch (buffer[i]) {
                    case '(': {
                        ++p;
                        break;
                    }
                    case ')': {
                        if (--p >= 0) break;
                        return i;
                    }
                    case '\"': {
                        dq = true;
                        break;
                    }
                    case '\'': {
                        sq = true;
                    }
                }
            }
            ++i;
        }
        return -1;
    }
}

