/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.corext.phpdoc;

import net.sourceforge.phpdt.core.IBuffer;
import net.sourceforge.phpdt.internal.corext.phpdoc.SingleCharReader;
import net.sourceforge.phpdt.internal.corext.util.Strings;

public class PHPDocBufferCommentReader
extends SingleCharReader {
    private IBuffer fBuffer;
    private int fCurrPos;
    private int fStartPos;
    private int fEndPos;
    private boolean fWasNewLine;

    public PHPDocBufferCommentReader(IBuffer buf, int start, int end) {
        this.fBuffer = buf;
        this.fStartPos = start + 3;
        this.fEndPos = end - 2;
        this.reset();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read() {
        char ch;
        if (this.fCurrPos >= this.fEndPos) return -1;
        if (this.fWasNewLine) {
            do {
                ch = this.fBuffer.getChar(this.fCurrPos++);
            } while (this.fCurrPos < this.fEndPos && Character.isWhitespace(ch));
            if (ch == '*') {
                if (this.fCurrPos >= this.fEndPos) return -1;
                while ((ch = this.fBuffer.getChar(this.fCurrPos++)) == '*') {
                }
            }
        } else {
            ch = this.fBuffer.getChar(this.fCurrPos++);
        }
        this.fWasNewLine = Strings.isLineDelimiterChar(ch);
        return ch;
    }

    public void close() {
        this.fBuffer = null;
    }

    public void reset() {
        this.fCurrPos = this.fStartPos;
        this.fWasNewLine = true;
    }
}

