/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core.util;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UTFDataFormatException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.JavaCore;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.core.Signature;
import net.sourceforge.phpdt.core.compiler.CharOperation;
import net.sourceforge.phpdt.internal.compiler.ast.TypeReference;
import net.sourceforge.phpdt.internal.core.Assert;
import net.sourceforge.phpdt.internal.core.PackageFragmentRoot;
import net.sourceforge.phpdt.internal.core.util.CharArrayBuffer;
import net.sourceforge.phpdt.internal.core.util.SimpleDocument;
import net.sourceforge.phpdt.internal.ui.util.PHPFileUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class Util {
    private static final String ARGUMENTS_DELIMITER = "#";
    protected static ResourceBundle bundle;
    private static final String bundleName = "net.sourceforge.phpdt.internal.core.util.messages";
    private static final char[] DOUBLE_QUOTES;
    private static final String EMPTY_ARGUMENT = "   ";
    public static final String[] fgEmptyStringArray;
    private static final char[] SINGLE_QUOTE;

    static {
        DOUBLE_QUOTES = "''".toCharArray();
        fgEmptyStringArray = new String[0];
        SINGLE_QUOTE = "'".toCharArray();
        Util.relocalize();
    }

    private Util() {
    }

    public static String bind(String id) {
        return Util.bind(id, null);
    }

    public static String bind(String id, String binding) {
        return Util.bind(id, new String[]{binding});
    }

    public static String bind(String id, String binding1, String binding2) {
        return Util.bind(id, new String[]{binding1, binding2});
    }

    public static String bind(String id, String[] bindings) {
        StringBuffer output;
        block15: {
            if (id == null) {
                return "No message available";
            }
            String message = null;
            try {
                message = bundle.getString(id);
            }
            catch (MissingResourceException missingResourceException) {
                return "Missing message: " + id + " in: " + bundleName;
            }
            char[] messageWithNoDoubleQuotes = CharOperation.replace(message.toCharArray(), DOUBLE_QUOTES, SINGLE_QUOTE);
            if (bindings == null) {
                return new String(messageWithNoDoubleQuotes);
            }
            int length = messageWithNoDoubleQuotes.length;
            int start = 0;
            int end = length;
            output = null;
            while ((end = CharOperation.indexOf('{', messageWithNoDoubleQuotes, start)) > -1) {
                if (output == null) {
                    output = new StringBuffer(length + bindings.length * 20);
                }
                output.append(messageWithNoDoubleQuotes, start, end - start);
                start = CharOperation.indexOf('}', messageWithNoDoubleQuotes, end + 1);
                if (start > -1) {
                    int index = -1;
                    String argId = new String(messageWithNoDoubleQuotes, end + 1, start - end - 1);
                    try {
                        index = Integer.parseInt(argId);
                        output.append(bindings[index]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        boolean done = false;
                        if (!id.equals(argId)) {
                            String argMessage = null;
                            try {
                                argMessage = bundle.getString(argId);
                                output.append(argMessage);
                                done = true;
                            }
                            catch (MissingResourceException missingResourceException) {}
                        }
                        if (!done) {
                            output.append(messageWithNoDoubleQuotes, end + 1, start - end);
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        output.append("{missing " + Integer.toString(index) + "}");
                    }
                    ++start;
                    continue;
                }
                output.append(messageWithNoDoubleQuotes, end, length);
                break block15;
            }
            if (output == null) {
                return new String(messageWithNoDoubleQuotes);
            }
            output.append(messageWithNoDoubleQuotes, start, length - start);
        }
        return output.toString();
    }

    private static int checkTypeSignature(String sig, int start, int end, boolean allowVoid) {
        if (start >= end) {
            return -1;
        }
        int i = start;
        char c = sig.charAt(i++);
        int nestingDepth = 0;
        while (c == '[') {
            ++nestingDepth;
            if (i >= end) {
                return -1;
            }
            c = sig.charAt(i++);
        }
        switch (c) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                break;
            }
            case 'V': {
                if (!allowVoid) {
                    return -1;
                }
                if (nestingDepth == 0) break;
                return -1;
            }
            case 'L': {
                int semicolon = sig.indexOf(59, i);
                if (semicolon <= i || semicolon >= end) {
                    return -1;
                }
                i = semicolon + 1;
                break;
            }
            default: {
                return -1;
            }
        }
        return i;
    }

    public static int combineHashCodes(int hashCode1, int hashCode2) {
        return hashCode1 * 17 + hashCode2;
    }

    public static int compare(byte[] a, byte[] b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        int len = Math.min(a.length, b.length);
        int i = 0;
        while (i < len) {
            int diff = a[i] - b[i];
            if (diff != 0) {
                return diff;
            }
            ++i;
        }
        if (a.length > len) {
            return 1;
        }
        if (b.length > len) {
            return -1;
        }
        return 0;
    }

    public static int compare(char[] str1, char[] str2) {
        int len1 = str1.length;
        int len2 = str2.length;
        int n = Math.min(len1, len2);
        int i = 0;
        while (n-- != 0) {
            char c2;
            char c1 = str1[i];
            if (c1 == (c2 = str2[i++])) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public static String concat(String s1, char c, String s2) {
        if (s1 == null) {
            s1 = "null";
        }
        if (s2 == null) {
            s2 = "null";
        }
        int l1 = s1.length();
        int l2 = s2.length();
        char[] buf = new char[l1 + 1 + l2];
        s1.getChars(0, l1, buf, 0);
        buf[l1] = c;
        s2.getChars(0, l2, buf, l1 + 1);
        return new String(buf);
    }

    public static String concat(String s1, String s2) {
        if (s1 == null) {
            s1 = "null";
        }
        if (s2 == null) {
            s2 = "null";
        }
        int l1 = s1.length();
        int l2 = s2.length();
        char[] buf = new char[l1 + l2];
        s1.getChars(0, l1, buf, 0);
        s2.getChars(0, l2, buf, l1);
        return new String(buf);
    }

    public static String concat(String s1, String s2, String s3) {
        if (s1 == null) {
            s1 = "null";
        }
        if (s2 == null) {
            s2 = "null";
        }
        if (s3 == null) {
            s3 = "null";
        }
        int l1 = s1.length();
        int l2 = s2.length();
        int l3 = s3.length();
        char[] buf = new char[l1 + l2 + l3];
        s1.getChars(0, l1, buf, 0);
        s2.getChars(0, l2, buf, l1);
        s3.getChars(0, l3, buf, l1 + l2);
        return new String(buf);
    }

    public static String convertTypeSignature(char[] sig) {
        return new String(sig).replace('/', '.');
    }

    public static final String editedString(String original, TextEdit edit) {
        if (edit == null) {
            return original;
        }
        SimpleDocument document = new SimpleDocument(original);
        try {
            edit.apply((IDocument)document, 0);
            return document.get();
        }
        catch (MalformedTreeException e) {
            e.printStackTrace();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return original;
    }

    public static final boolean endsWithIgnoreCase(String str, String end) {
        int endLength;
        int strLength = str == null ? 0 : str.length();
        int n = endLength = end == null ? 0 : end.length();
        if (endLength > strLength) {
            return false;
        }
        int i = 1;
        while (i <= endLength) {
            if (Character.toLowerCase(end.charAt(endLength - i)) != Character.toLowerCase(str.charAt(strLength - i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalArraysOrNull(int[] a, int[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int len = a.length;
        if (len != b.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalArraysOrNull(Object[] a, Object[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int len = a.length;
        if (len != b.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (a[i] == null ? b[i] != null : !a[i].equals(b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalArraysOrNullSortFirst(Comparable[] a, Comparable[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int len = a.length;
        if (len != b.length) {
            return false;
        }
        if (len >= 2) {
            a = Util.sortCopy(a);
            b = Util.sortCopy(b);
        }
        int i = 0;
        while (i < len) {
            if (!a[i].equals(b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalArraysOrNullSortFirst(String[] a, String[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int len = a.length;
        if (len != b.length) {
            return false;
        }
        if (len >= 2) {
            a = Util.sortCopy(a);
            b = Util.sortCopy(b);
        }
        int i = 0;
        while (i < len) {
            if (!a[i].equals(b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalOrNull(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static String extractLastName(String qualifiedName) {
        int i = qualifiedName.lastIndexOf(46);
        if (i == -1) {
            return qualifiedName;
        }
        return qualifiedName.substring(i + 1);
    }

    public static String[] extractParameterTypes(char[] sig) {
        char c;
        int count = Util.getParameterCount(sig);
        String[] result = new String[count];
        if (count == 0) {
            return result;
        }
        int i = CharOperation.indexOf('(', sig) + 1;
        count = 0;
        int len = sig.length;
        int start = i;
        while (i != len && (c = sig[i]) != ')') {
            if (c == '[') {
                ++i;
                continue;
            }
            if (c == 'L') {
                Assert.isTrue((i = CharOperation.indexOf(';', sig, i + 1) + 1) != 0);
                result[count++] = Util.convertTypeSignature(CharOperation.subarray(sig, start, i));
                start = i;
                continue;
            }
            result[count++] = Util.convertTypeSignature(CharOperation.subarray(sig, start, ++i));
            start = i;
        }
        return result;
    }

    public static String extractReturnType(String sig) {
        int i = sig.lastIndexOf(41);
        Assert.isTrue(i != -1);
        return sig.substring(i + 1);
    }

    private static IFile findFirstClassFile(IFolder folder) {
        try {
            IResource[] members = folder.members();
            int i = 0;
            int max = members.length;
            while (i < max) {
                IResource member = members[i];
                if (member.getType() == 2) {
                    return Util.findFirstClassFile((IFolder)member);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static String findLineSeparator(char[] text) {
        int length = text.length;
        if (length > 0) {
            int nextChar = text[0];
            int i = 0;
            while (i < length) {
                int currentChar = nextChar;
                nextChar = i < length - 1 ? text[i + 1] : 32;
                switch (currentChar) {
                    case 10: {
                        return "\n";
                    }
                    case 13: {
                        return nextChar == 10 ? "\r\n" : "\r";
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private static String getLineSeparator(char[] text, char[] buffer) {
        String lineSeparator = Util.findLineSeparator(buffer);
        if (lineSeparator == null && (lineSeparator = Util.findLineSeparator(text)) == null) {
            return net.sourceforge.phpdt.internal.compiler.util.Util.LINE_SEPARATOR;
        }
        return lineSeparator;
    }

    public static int getParameterCount(char[] sig) {
        char c;
        int i = CharOperation.indexOf('(', sig) + 1;
        Assert.isTrue(i != 0);
        int count = 0;
        int len = sig.length;
        while (i != len && (c = sig[i]) != ')') {
            if (c == '[') {
                ++i;
                continue;
            }
            if (c == 'L') {
                ++count;
                Assert.isTrue((i = CharOperation.indexOf(';', sig, i + 1) + 1) != 0);
                continue;
            }
            ++count;
            ++i;
        }
        return count;
    }

    public static String getProblemArgumentsForMarker(String[] arguments) {
        StringBuffer args = new StringBuffer(10);
        args.append(arguments.length);
        args.append(':');
        int j = 0;
        while (j < arguments.length) {
            if (j != 0) {
                args.append(ARGUMENTS_DELIMITER);
            }
            if (arguments[j].length() == 0) {
                args.append(EMPTY_ARGUMENT);
            } else {
                args.append(arguments[j]);
            }
            ++j;
        }
        return args.toString();
    }

    public static String[] getProblemArgumentsFromMarker(String argumentsString) {
        int numberOfArg;
        if (argumentsString == null) {
            return null;
        }
        int index = argumentsString.indexOf(58);
        if (index == -1) {
            return null;
        }
        int length = argumentsString.length();
        try {
            numberOfArg = Integer.parseInt(argumentsString.substring(0, index));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        argumentsString = argumentsString.substring(index + 1, length);
        String[] args = new String[length];
        int count = 0;
        StringTokenizer tokenizer = new StringTokenizer(argumentsString, ARGUMENTS_DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            String argument = tokenizer.nextToken();
            if (argument.equals(EMPTY_ARGUMENT)) {
                argument = "";
            }
            args[count++] = argument;
        }
        if (count != numberOfArg) {
            return null;
        }
        String[] stringArray = args;
        args = new String[count];
        System.arraycopy(stringArray, 0, args, 0, count);
        return args;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getResourceContentsAsByteArray(IFile file) throws JavaModelException {
        byte[] byArray;
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(file.getContents(true));
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
        try {
            try {
                byArray = net.sourceforge.phpdt.internal.compiler.util.Util.getInputStreamAsByteArray(stream, -1);
                Object var3_5 = null;
            }
            catch (IOException e) {
                throw new JavaModelException(e, 985);
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            try {
                ((InputStream)stream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {}
        ((InputStream)stream).close();
        return byArray;
    }

    public static char[] getResourceContentsAsCharArray(IFile file) throws JavaModelException {
        String encoding = null;
        try {
            encoding = file.getCharset();
        }
        catch (CoreException coreException) {}
        return Util.getResourceContentsAsCharArray(file, encoding);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char[] getResourceContentsAsCharArray(IFile file, String encoding) throws JavaModelException {
        char[] cArray;
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(file.getContents(true));
        }
        catch (CoreException e) {
            throw new JavaModelException(e, 969);
        }
        try {
            try {
                cArray = net.sourceforge.phpdt.internal.compiler.util.Util.getInputStreamAsCharArray(stream, -1, encoding);
                Object var4_6 = null;
            }
            catch (IOException e) {
                throw new JavaModelException(e, 985);
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            try {
                ((InputStream)stream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {}
        ((InputStream)stream).close();
        return cArray;
    }

    public static String[] getTrimmedSimpleNames(String name) {
        String[] result = Signature.getSimpleNames(name);
        if (result == null) {
            return null;
        }
        int i = 0;
        int length = result.length;
        while (i < length) {
            result[i] = result[i].trim();
            ++i;
        }
        return result;
    }

    public static int indexOfEnclosingPath(IPath checkedPath, IPath[] paths, int pathCount) {
        int bestMatch = -1;
        int bestLength = -1;
        int i = 0;
        while (i < pathCount) {
            int currentLength;
            if (!paths[i].equals((Object)checkedPath) && paths[i].isPrefixOf(checkedPath) && (currentLength = paths[i].segmentCount()) > bestLength) {
                bestLength = currentLength;
                bestMatch = i;
            }
            ++i;
        }
        return bestMatch;
    }

    public static int indexOfMatchingPath(IPath checkedPath, IPath[] paths, int pathCount) {
        int i = 0;
        while (i < pathCount) {
            if (paths[i].equals((Object)checkedPath)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOfNestedPath(IPath checkedPath, IPath[] paths, int pathCount) {
        int i = 0;
        while (i < pathCount) {
            if (!checkedPath.equals((Object)paths[i]) && checkedPath.isPrefixOf(paths[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final boolean isExcluded(IJavaElement element) {
        int elementType = element.getElementType();
        switch (elementType) {
            case 1: 
            case 2: 
            case 3: {
                return false;
            }
            case 5: {
                PackageFragmentRoot cfr_ignored_0 = (PackageFragmentRoot)element.getAncestor(3);
                element.getResource();
                return Util.isExcluded(element.getParent());
            }
        }
        IJavaElement cu = element.getAncestor(5);
        return cu != null && Util.isExcluded(cu);
    }

    public static final boolean isExcluded(IPath resourcePath, char[][] inclusionPatterns, char[][] exclusionPatterns, boolean isFolderPath) {
        int length;
        int i;
        char[] path;
        block9: {
            if (inclusionPatterns == null && exclusionPatterns == null) {
                return false;
            }
            path = resourcePath.toString().toCharArray();
            if (inclusionPatterns != null) {
                i = 0;
                length = inclusionPatterns.length;
                while (i < length) {
                    int star;
                    int lastSlash;
                    char[] pattern;
                    char[] folderPattern = pattern = inclusionPatterns[i];
                    if (isFolderPath && (lastSlash = CharOperation.lastIndexOf('/', pattern)) != -1 && lastSlash != pattern.length - 1 && ((star = CharOperation.indexOf('*', pattern, lastSlash)) == -1 || star >= pattern.length - 1 || pattern[star + 1] != '*')) {
                        folderPattern = CharOperation.subarray(pattern, 0, lastSlash);
                    }
                    if (!CharOperation.pathMatch(folderPattern, path, true, '/')) {
                        ++i;
                        continue;
                    }
                    break block9;
                }
                return true;
            }
        }
        if (isFolderPath) {
            path = CharOperation.concat(path, new char[]{'*'}, '/');
        }
        if (exclusionPatterns != null) {
            i = 0;
            length = exclusionPatterns.length;
            while (i < length) {
                if (CharOperation.pathMatch(exclusionPatterns[i], path, true, '/')) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static final boolean isExcluded(IResource resource, char[][] exclusionPatterns) {
        IPath path = resource.getFullPath();
        return Util.isExcluded(path, null, exclusionPatterns, resource.getType() == 2);
    }

    public static final boolean isExcluded(IResource resource, char[][] inclusionPatterns, char[][] exclusionPatterns) {
        IPath path = resource.getFullPath();
        return Util.isExcluded(path, inclusionPatterns, exclusionPatterns, resource.getType() == 2);
    }

    public static boolean isValidCompilationUnitName(String name) {
        return PHPFileUtil.isPHPFileName(name);
    }

    public static boolean isValidFolderNameForPackage(String folderName) {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isValidMethodSignature(String sig) {
        len = sig.length();
        if (len == 0) {
            return false;
        }
        i = 0;
        if ((c = sig.charAt(i++)) != '(') {
            return false;
        }
        if (i < len) ** GOTO lbl13
        return false;
lbl-1000:
        // 1 sources

        {
            if ((i = Util.checkTypeSignature(sig, i, len, false)) == -1) {
                return false;
            }
            if (i < len) continue;
            return false;
lbl13:
            // 2 sources

            ** while (sig.charAt((int)i) != ')')
        }
lbl14:
        // 1 sources

        ++i;
        return (i = Util.checkTypeSignature(sig, i, len, true)) == len;
    }

    public static boolean isValidTypeSignature(String sig, boolean allowVoid) {
        int len = sig.length();
        return Util.checkTypeSignature(sig, 0, len, allowVoid) == len;
    }

    public static void log(Throwable e, String message) {
        Throwable nestedException;
        if (e instanceof JavaModelException && (nestedException = ((JavaModelException)((Object)e)).getException()) != null) {
            e = nestedException;
        }
        Status status = new Status(4, "net.sourceforge.phpeclipse", 4, message, e);
        JavaCore.getPlugin().getLog().log((IStatus)status);
    }

    public static char[] normalizeCRs(char[] text, char[] buffer) {
        CharArrayBuffer result = new CharArrayBuffer();
        int lineStart = 0;
        int length = text.length;
        if (length == 0) {
            return text;
        }
        String lineSeparator = Util.getLineSeparator(text, buffer);
        int nextChar = text[0];
        int i = 0;
        while (i < length) {
            int currentChar = nextChar;
            nextChar = i < length - 1 ? text[i + 1] : 32;
            switch (currentChar) {
                case 10: {
                    int lineLength = i - lineStart;
                    char[] line = new char[lineLength];
                    System.arraycopy(text, lineStart, line, 0, lineLength);
                    result.append(line);
                    result.append(lineSeparator);
                    lineStart = i + 1;
                    break;
                }
                case 13: {
                    char[] line;
                    int lineLength = i - lineStart;
                    if (lineLength >= 0) {
                        line = new char[lineLength];
                        System.arraycopy(text, lineStart, line, 0, lineLength);
                        result.append(line);
                        result.append(lineSeparator);
                        if (nextChar == 10) {
                            nextChar = 32;
                            lineStart = i + 2;
                            break;
                        }
                        lineStart = i + 1;
                        break;
                    }
                    lineStart = i + 1;
                }
            }
            ++i;
        }
        if (lineStart > 0) {
            int lastLineLength = length - lineStart;
            if (lastLineLength > 0) {
                char[] lastLine = new char[lastLineLength];
                System.arraycopy(text, lineStart, lastLine, 0, lastLineLength);
                result.append(lastLine);
            }
            return result.getContents();
        }
        return text;
    }

    public static String normalizeCRs(String text, String buffer) {
        return new String(Util.normalizeCRs(text.toCharArray(), buffer.toCharArray()));
    }

    public static String packageName(IPath pkgPath) {
        StringBuffer pkgName = new StringBuffer("");
        int j = 0;
        int max = pkgPath.segmentCount();
        while (j < max) {
            String segment = pkgPath.segment(j);
            pkgName.append(segment);
            if (j < pkgPath.segmentCount() - 1) {
                pkgName.append(".");
            }
            ++j;
        }
        return pkgName.toString();
    }

    public static int prefixLength(char[] s1, char[] s2) {
        int len = 0;
        int max = Math.min(s1.length, s2.length);
        int i = 0;
        while (i < max && s1[i] == s2[i]) {
            ++len;
            ++i;
        }
        return len;
    }

    public static int prefixLength(String s1, String s2) {
        int len = 0;
        int max = Math.min(s1.length(), s2.length());
        int i = 0;
        while (i < max && s1.charAt(i) == s2.charAt(i)) {
            ++len;
            ++i;
        }
        return len;
    }

    private static void quickSort(char[][] list, int left, int right) {
        int original_left = left;
        int original_right = right;
        char[] mid = list[(left + right) / 2];
        while (true) {
            if (Util.compare(list[left], mid) < 0) {
                ++left;
                continue;
            }
            while (Util.compare(mid, list[right]) < 0) {
                --right;
            }
            if (left <= right) {
                char[] tmp = list[left];
                list[left] = list[right];
                list[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(list, original_left, right);
        }
        if (left < original_right) {
            Util.quickSort(list, left, original_right);
        }
    }

    private static void quickSort(Comparable[] sortedCollection, int left, int right) {
        int original_left = left;
        int original_right = right;
        Comparable mid = sortedCollection[(left + right) / 2];
        while (true) {
            if (sortedCollection[left].compareTo(mid) < 0) {
                ++left;
                continue;
            }
            while (mid.compareTo(sortedCollection[right]) < 0) {
                --right;
            }
            if (left <= right) {
                Comparable tmp = sortedCollection[left];
                sortedCollection[left] = sortedCollection[right];
                sortedCollection[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(sortedCollection, original_left, right);
        }
        if (left < original_right) {
            Util.quickSort(sortedCollection, left, original_right);
        }
    }

    private static void quickSort(int[] list, int left, int right) {
        int original_left = left;
        int original_right = right;
        int mid = list[(left + right) / 2];
        while (true) {
            if (list[left] < mid) {
                ++left;
                continue;
            }
            while (mid < list[right]) {
                --right;
            }
            if (left <= right) {
                int tmp = list[left];
                list[left] = list[right];
                list[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(list, original_left, right);
        }
        if (left < original_right) {
            Util.quickSort(list, left, original_right);
        }
    }

    private static void quickSort(Object[] sortedCollection, int left, int right, Comparer comparer) {
        int original_left = left;
        int original_right = right;
        Object mid = sortedCollection[(left + right) / 2];
        while (true) {
            if (comparer.compare(sortedCollection[left], mid) < 0) {
                ++left;
                continue;
            }
            while (comparer.compare(mid, sortedCollection[right]) < 0) {
                --right;
            }
            if (left <= right) {
                Object tmp = sortedCollection[left];
                sortedCollection[left] = sortedCollection[right];
                sortedCollection[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(sortedCollection, original_left, right, comparer);
        }
        if (left < original_right) {
            Util.quickSort(sortedCollection, left, original_right, comparer);
        }
    }

    private static void quickSort(Object[] sortedCollection, int left, int right, int[] sortOrder) {
        int original_left = left;
        int original_right = right;
        int mid = sortOrder[(left + right) / 2];
        while (true) {
            if (sortOrder[left] < mid) {
                ++left;
                continue;
            }
            while (mid < sortOrder[right]) {
                --right;
            }
            if (left <= right) {
                Object tmp = sortedCollection[left];
                sortedCollection[left] = sortedCollection[right];
                sortedCollection[right] = tmp;
                int tmp2 = sortOrder[left];
                sortOrder[left] = sortOrder[right];
                sortOrder[right] = tmp2;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(sortedCollection, original_left, right, sortOrder);
        }
        if (left < original_right) {
            Util.quickSort(sortedCollection, left, original_right, sortOrder);
        }
    }

    private static void quickSort(String[] sortedCollection, int left, int right) {
        int original_left = left;
        int original_right = right;
        String mid = sortedCollection[(left + right) / 2];
        while (true) {
            if (sortedCollection[left].compareTo(mid) < 0) {
                ++left;
                continue;
            }
            while (mid.compareTo(sortedCollection[right]) < 0) {
                --right;
            }
            if (left <= right) {
                String tmp = sortedCollection[left];
                sortedCollection[left] = sortedCollection[right];
                sortedCollection[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(sortedCollection, original_left, right);
        }
        if (left < original_right) {
            Util.quickSort(sortedCollection, left, original_right);
        }
    }

    private static void quickSortReverse(String[] sortedCollection, int left, int right) {
        int original_left = left;
        int original_right = right;
        String mid = sortedCollection[(left + right) / 2];
        while (true) {
            if (sortedCollection[left].compareTo(mid) > 0) {
                ++left;
                continue;
            }
            while (mid.compareTo(sortedCollection[right]) > 0) {
                --right;
            }
            if (left <= right) {
                String tmp = sortedCollection[left];
                sortedCollection[left] = sortedCollection[right];
                sortedCollection[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSortReverse(sortedCollection, original_left, right);
        }
        if (left < original_right) {
            Util.quickSortReverse(sortedCollection, left, original_right);
        }
    }

    public static final char[] readUTF(DataInput in) throws IOException {
        int utflen = in.readUnsignedShort();
        char[] str = new char[utflen];
        int count = 0;
        int strlen = 0;
        while (count < utflen) {
            int c = in.readUnsignedByte();
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str[strlen++] = (char)c;
                    break;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    int char2 = in.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    break;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    int char2 = in.readUnsignedByte();
                    int char3 = in.readUnsignedByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        if (strlen < utflen) {
            char[] cArray = str;
            str = new char[strlen];
            System.arraycopy(cArray, 0, str, 0, strlen);
        }
        return str;
    }

    public static void relocalize() {
        try {
            bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault());
        }
        catch (MissingResourceException e) {
            System.out.println("Missing resource : " + bundleName.replace('.', '/') + ".properties for locale " + Locale.getDefault());
            throw e;
        }
    }

    public static void sort(char[][] list) {
        if (list.length > 1) {
            Util.quickSort(list, 0, list.length - 1);
        }
    }

    public static void sort(Comparable[] objects) {
        if (objects.length > 1) {
            Util.quickSort(objects, 0, objects.length - 1);
        }
    }

    public static void sort(int[] list) {
        if (list.length > 1) {
            Util.quickSort(list, 0, list.length - 1);
        }
    }

    public static void sort(Object[] objects, Comparer comparer) {
        if (objects.length > 1) {
            Util.quickSort(objects, 0, objects.length - 1, comparer);
        }
    }

    public static void sort(Object[] objects, int[] sortOrder) {
        if (objects.length > 1) {
            Util.quickSort(objects, 0, objects.length - 1, sortOrder);
        }
    }

    public static void sort(String[] strings) {
        if (strings.length > 1) {
            Util.quickSort(strings, 0, strings.length - 1);
        }
    }

    public static Comparable[] sortCopy(Comparable[] objects) {
        int len = objects.length;
        Comparable[] copy = new Comparable[len];
        System.arraycopy(objects, 0, copy, 0, len);
        Util.sort(copy);
        return copy;
    }

    public static Object[] sortCopy(Object[] objects, Comparer comparer) {
        int len = objects.length;
        Object[] copy = new Object[len];
        System.arraycopy(objects, 0, copy, 0, len);
        Util.sort(copy, comparer);
        return copy;
    }

    public static String[] sortCopy(String[] objects) {
        int len = objects.length;
        String[] copy = new String[len];
        System.arraycopy(objects, 0, copy, 0, len);
        Util.sort(copy);
        return copy;
    }

    public static void sortReverseOrder(String[] strings) {
        if (strings.length > 1) {
            Util.quickSortReverse(strings, 0, strings.length - 1);
        }
    }

    public static char[][] toCharArrays(String[] a) {
        int len = a.length;
        char[][] result = new char[len][];
        int i = 0;
        while (i < len) {
            result[i] = Util.toChars(a[i]);
            ++i;
        }
        return result;
    }

    public static char[] toChars(String s) {
        int len = s.length();
        char[] chars = new char[len];
        s.getChars(0, len, chars, 0);
        return chars;
    }

    public static char[][] toCompoundChars(String s) {
        int len = s.length();
        if (len == 0) {
            return CharOperation.NO_CHAR_CHAR;
        }
        int segCount = 1;
        int off = s.indexOf(46);
        while (off != -1) {
            ++segCount;
            off = s.indexOf(46, off + 1);
        }
        char[][] segs = new char[segCount][];
        int start = 0;
        int i = 0;
        while (i < segCount) {
            int dot = s.indexOf(46, start);
            int end = dot == -1 ? s.length() : dot;
            segs[i] = new char[end - start];
            s.getChars(start, end, segs[i], 0);
            start = end + 1;
            ++i;
        }
        return segs;
    }

    public static String toString(char[] c) {
        return new String(c);
    }

    public static String toString(char[][] c) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int max = c.length;
        while (i < max) {
            if (i != 0) {
                sb.append('.');
            }
            sb.append(c[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String toString(char[][] c, char[] d) {
        if (c == null) {
            return new String(d);
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int max = c.length;
        while (i < max) {
            sb.append(c[i]);
            sb.append('.');
            ++i;
        }
        sb.append(d);
        return sb.toString();
    }

    public static String typeSignature(TypeReference type) {
        char[][] compoundName = type.getTypeName();
        char[] typeName = CharOperation.concatWith(compoundName, '.');
        String signature = Signature.createTypeSignature(typeName, false);
        int dimensions = type.dimensions();
        if (dimensions > 0) {
            signature = Signature.createArraySignature(signature, dimensions);
        }
        return signature;
    }

    public static void validateMethodSignature(String sig) {
        Assert.isTrue(Util.isValidMethodSignature(sig));
    }

    public static void validateTypeSignature(String sig, boolean allowVoid) {
        Assert.isTrue(Util.isValidTypeSignature(sig, allowVoid));
    }

    public static void verbose(String log) {
        Util.verbose(log, System.out);
    }

    public static synchronized void verbose(String log, PrintStream printStream) {
        int end;
        int start = 0;
        do {
            end = log.indexOf(10, start);
            printStream.print(Thread.currentThread());
            printStream.print(" ");
            printStream.print(log.substring(start, end == -1 ? log.length() : end + 1));
        } while ((start = end + 1) != 0);
        printStream.println();
    }

    public static int writeUTF(OutputStream out, char[] str) throws IOException {
        char c;
        int strlen = str.length;
        int utflen = 0;
        int i = 0;
        while (i < strlen) {
            c = str[i];
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        out.write(utflen >>> 8 & 0xFF);
        out.write(utflen >>> 0 & 0xFF);
        if (strlen == utflen) {
            i = 0;
            while (i < strlen) {
                out.write(str[i]);
                ++i;
            }
        } else {
            i = 0;
            while (i < strlen) {
                c = str[i];
                if (c >= '\u0001' && c <= '\u007f') {
                    out.write(c);
                } else if (c > '\u07ff') {
                    out.write(0xE0 | c >> 12 & 0xF);
                    out.write(0x80 | c >> 6 & 0x3F);
                    out.write(0x80 | c >> 0 & 0x3F);
                } else {
                    out.write(0xC0 | c >> 6 & 0x1F);
                    out.write(0x80 | c >> 0 & 0x3F);
                }
                ++i;
            }
        }
        return utflen + 2;
    }

    public static interface Comparable {
        public int compareTo(Comparable var1);
    }

    public static interface Comparer {
        public int compare(Object var1, Object var2);
    }
}

