/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core.builder;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import net.sourceforge.phpdt.internal.core.builder.ClasspathMultiDirectory;
import net.sourceforge.phpdt.internal.core.builder.PHPBuilder;
import net.sourceforge.phpdt.internal.core.util.SimpleLookupTable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;

public class State {
    String javaProjectName;
    ClasspathMultiDirectory[] sourceLocations;
    int buildNumber;
    long lastStructuralBuildTime;
    SimpleLookupTable structuralBuildTimes;
    private String[] knownPackageNames;
    static final byte VERSION = 7;
    static final byte SOURCE_FOLDER = 1;

    State() {
    }

    protected State(PHPBuilder javaBuilder) {
        this.knownPackageNames = null;
        this.javaProjectName = javaBuilder.currentProject.getName();
        this.sourceLocations = javaBuilder.nameEnvironment.sourceLocations;
        this.buildNumber = 0;
        this.lastStructuralBuildTime = System.currentTimeMillis();
        this.structuralBuildTimes = new SimpleLookupTable(3);
    }

    void copyFrom(State lastState) {
        this.knownPackageNames = null;
        this.buildNumber = lastState.buildNumber + 1;
        this.lastStructuralBuildTime = lastState.lastStructuralBuildTime;
    }

    void recordStructuralDependency(IProject prereqProject, State prereqState) {
        if (prereqState != null) {
            this.structuralBuildTimes.put(prereqProject.getName(), new Long(prereqState.lastStructuralBuildTime));
        }
    }

    void removePackage(IResourceDelta sourceDelta) {
        IResource resource = sourceDelta.getResource();
        switch (resource.getType()) {
            case 2: {
                IResourceDelta[] children = sourceDelta.getAffectedChildren();
                int i = 0;
                int l = children.length;
                while (i < l) {
                    this.removePackage(children[i]);
                    ++i;
                }
                return;
            }
            case 1: {
                resource.getProjectRelativePath();
            }
        }
    }

    static State read(IProject project, DataInputStream in) throws IOException {
        if (PHPBuilder.DEBUG) {
            System.out.println("About to read state...");
        }
        if (7 != in.readByte()) {
            if (PHPBuilder.DEBUG) {
                System.out.println("Found non-compatible state version... answered null");
            }
            return null;
        }
        State newState = new State();
        newState.javaProjectName = in.readUTF();
        if (!project.getName().equals(newState.javaProjectName)) {
            if (PHPBuilder.DEBUG) {
                System.out.println("Project's name does not match... answered null");
            }
            return null;
        }
        newState.buildNumber = in.readInt();
        newState.lastStructuralBuildTime = in.readLong();
        int length = in.readInt();
        newState.structuralBuildTimes = new SimpleLookupTable(length);
        int i = 0;
        while (i < length) {
            newState.structuralBuildTimes.put(in.readUTF(), new Long(in.readLong()));
            ++i;
        }
        if (PHPBuilder.DEBUG) {
            System.out.println("Successfully read state for " + newState.javaProjectName);
        }
        return newState;
    }

    private static char[][] readNames(DataInputStream in) throws IOException {
        int length = in.readInt();
        char[][] names = new char[length][];
        int i = 0;
        while (i < length) {
            int nLength = in.readInt();
            char[] name = new char[nLength];
            int j = 0;
            while (j < nLength) {
                name[j] = in.readChar();
                ++j;
            }
            names[i] = name;
            ++i;
        }
        return names;
    }

    void tagAsNoopBuild() {
        this.buildNumber = -1;
    }

    boolean wasNoopBuild() {
        return this.buildNumber == -1;
    }

    void tagAsStructurallyChanged() {
        this.lastStructuralBuildTime = System.currentTimeMillis();
    }

    boolean wasStructurallyChanged(IProject prereqProject, State prereqState) {
        if (prereqState != null) {
            long previous;
            Object o = this.structuralBuildTimes.get(prereqProject.getName());
            long l = previous = o == null ? 0L : (Long)o;
            if (previous == prereqState.lastStructuralBuildTime) {
                return false;
            }
        }
        return true;
    }

    void write(DataOutputStream out) throws IOException {
        out.writeByte(7);
        out.writeUTF(this.javaProjectName);
        out.writeInt(this.buildNumber);
        out.writeLong(this.lastStructuralBuildTime);
        int length = this.structuralBuildTimes.elementSize;
        out.writeInt(length);
        if (length > 0) {
            Object[] keyTable = this.structuralBuildTimes.keyTable;
            Object[] valueTable = this.structuralBuildTimes.valueTable;
            int i = 0;
            int l = keyTable.length;
            while (i < l) {
                if (keyTable[i] != null) {
                    --length;
                    out.writeUTF((String)keyTable[i]);
                    out.writeLong((Long)valueTable[i]);
                }
                ++i;
            }
            if (PHPBuilder.DEBUG && length != 0) {
                System.out.println("structuralBuildNumbers table is inconsistent");
            }
        }
    }

    private void writeNames(char[][] names, DataOutputStream out) throws IOException {
        int length = names == null ? 0 : names.length;
        out.writeInt(length);
        int i = 0;
        while (i < length) {
            char[] name = names[i];
            int nLength = name.length;
            out.writeInt(nLength);
            int j = 0;
            while (j < nLength) {
                out.writeChar(name[j]);
                ++j;
            }
            ++i;
        }
    }

    public String toString() {
        return "State for " + this.javaProjectName + " (#" + this.buildNumber + " @ " + new Date(this.lastStructuralBuildTime) + ")";
    }
}

