/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core.builder;

import java.util.ArrayList;
import net.sourceforge.phpdt.core.IClasspathEntry;
import net.sourceforge.phpdt.core.IJavaProject;
import net.sourceforge.phpdt.core.JavaCore;
import net.sourceforge.phpdt.core.compiler.CharOperation;
import net.sourceforge.phpdt.internal.compiler.env.INameEnvironment;
import net.sourceforge.phpdt.internal.compiler.env.NameEnvironmentAnswer;
import net.sourceforge.phpdt.internal.compiler.problem.AbortCompilation;
import net.sourceforge.phpdt.internal.core.ClasspathEntry;
import net.sourceforge.phpdt.internal.core.JavaModel;
import net.sourceforge.phpdt.internal.core.JavaProject;
import net.sourceforge.phpdt.internal.core.builder.AbortIncrementalBuildException;
import net.sourceforge.phpdt.internal.core.builder.ClasspathLocation;
import net.sourceforge.phpdt.internal.core.builder.ClasspathMultiDirectory;
import net.sourceforge.phpdt.internal.core.builder.SourceFile;
import net.sourceforge.phpdt.internal.core.util.SimpleLookupTable;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class NameEnvironment
implements INameEnvironment {
    boolean isIncrementalBuild = false;
    ClasspathMultiDirectory[] sourceLocations;
    String[] initialTypeNames;
    SourceFile[] additionalUnits;

    NameEnvironment(IWorkspaceRoot root, JavaProject javaProject, SimpleLookupTable binaryLocationsPerProject) throws CoreException {
        this.computeClasspathLocations(root, javaProject, binaryLocationsPerProject);
        this.setNames(null, null);
    }

    public NameEnvironment(IJavaProject javaProject) {
        try {
            this.computeClasspathLocations(javaProject.getProject().getWorkspace().getRoot(), (JavaProject)javaProject, null);
        }
        catch (CoreException coreException) {}
        this.setNames(null, null);
    }

    private void computeClasspathLocations(IWorkspaceRoot root, JavaProject javaProject, SimpleLookupTable binaryLocationsPerProject) throws CoreException {
        IMarker cycleMarker = javaProject.getCycleMarker();
        if (cycleMarker != null) {
            int severity;
            int n = severity = "error".equals(javaProject.getOption("net.sourceforge.phpeclipse.circularClasspath", true)) ? 2 : 1;
            if (severity != (Integer)cycleMarker.getAttribute("severity")) {
                cycleMarker.setAttribute("severity", severity);
            }
        }
        IClasspathEntry[] classpathEntries = javaProject.getExpandedClasspath(true, false, null, null);
        ArrayList<ClasspathLocation> sLocations = new ArrayList<ClasspathLocation>(classpathEntries.length);
        ArrayList<ClasspathLocation> bLocations = new ArrayList<ClasspathLocation>(classpathEntries.length);
        int i = 0;
        int l = classpathEntries.length;
        while (i < l) {
            ClasspathEntry entry = (ClasspathEntry)classpathEntries[i];
            IPath path = entry.getPath();
            Object target = JavaModel.getTarget((IContainer)root, path, true);
            if (target != null) {
                switch (entry.getEntryKind()) {
                    case 3: {
                        if (!(target instanceof IContainer)) break;
                        IContainer outputFolder = null;
                        sLocations.add(ClasspathLocation.forSourceFolder((IContainer)target, outputFolder, entry.fullExclusionPatternChars()));
                        break;
                    }
                    case 2: {
                        IProject prereqProject;
                        if (!(target instanceof IProject) || !JavaProject.hasJavaNature(prereqProject = (IProject)target)) break;
                        JavaProject prereqJavaProject = (JavaProject)JavaCore.create(prereqProject);
                        IClasspathEntry[] prereqClasspathEntries = prereqJavaProject.getRawClasspath();
                        ArrayList<IProject> seen = new ArrayList<IProject>();
                        int j = 0;
                        int m = prereqClasspathEntries.length;
                        while (j < m) {
                            Object prereqTarget;
                            IClasspathEntry prereqEntry = prereqClasspathEntries[j];
                            if (prereqEntry.getEntryKind() == 3 && (prereqTarget = JavaModel.getTarget((IContainer)root, prereqEntry.getPath(), true)) instanceof IContainer) {
                                IProject binaryFolder;
                                IPath prereqOutputPath = prereqEntry.getOutputLocation() != null ? prereqEntry.getOutputLocation() : prereqJavaProject.getOutputLocation();
                                Object object = binaryFolder = prereqOutputPath.segmentCount() == 1 ? prereqProject : root.getFolder(prereqOutputPath);
                                if (binaryFolder.exists() && !seen.contains(binaryFolder)) {
                                    seen.add(binaryFolder);
                                    ClasspathLocation bLocation = ClasspathLocation.forBinaryFolder((IContainer)binaryFolder, true);
                                    bLocations.add(bLocation);
                                    if (binaryLocationsPerProject != null) {
                                        ClasspathLocation[] existingLocations = (ClasspathLocation[])binaryLocationsPerProject.get(prereqProject);
                                        if (existingLocations == null) {
                                            existingLocations = new ClasspathLocation[]{bLocation};
                                        } else {
                                            int size = existingLocations.length;
                                            ClasspathLocation[] classpathLocationArray = existingLocations;
                                            existingLocations = new ClasspathLocation[size + 1];
                                            System.arraycopy(classpathLocationArray, 0, existingLocations, 0, size);
                                            existingLocations[size] = bLocation;
                                        }
                                        binaryLocationsPerProject.put(prereqProject, existingLocations);
                                    }
                                }
                            }
                            ++j;
                        }
                        break;
                    }
                }
            }
            ++i;
        }
        ArrayList<ClasspathMultiDirectory> outputFolders = new ArrayList<ClasspathMultiDirectory>(1);
        this.sourceLocations = new ClasspathMultiDirectory[sLocations.size()];
        if (!sLocations.isEmpty()) {
            sLocations.toArray(this.sourceLocations);
            int i2 = 0;
            int l2 = this.sourceLocations.length;
            while (i2 < l2) {
                ClasspathMultiDirectory md = this.sourceLocations[i2];
                outputFolders.add(md);
                md.hasIndependentOutputFolder = true;
                ++i2;
            }
        }
    }

    public void cleanup() {
        this.initialTypeNames = null;
        this.additionalUnits = null;
        int i = 0;
        int l = this.sourceLocations.length;
        while (i < l) {
            this.sourceLocations[i].cleanup();
            ++i;
        }
    }

    private void createFolder(IContainer folder) throws CoreException {
        if (!folder.exists()) {
            this.createFolder(folder.getParent());
            ((IFolder)folder).create(true, true, null);
        }
    }

    private NameEnvironmentAnswer findClass(String qualifiedTypeName, char[] typeName) {
        if (this.initialTypeNames != null) {
            int i = 0;
            int l = this.initialTypeNames.length;
            while (i < l) {
                if (qualifiedTypeName.equals(this.initialTypeNames[i])) {
                    if (this.isIncrementalBuild) {
                        throw new AbortCompilation(true, new AbortIncrementalBuildException(qualifiedTypeName));
                    }
                    return null;
                }
                ++i;
            }
        }
        if (this.additionalUnits != null && this.sourceLocations.length > 0) {
            Path qSourceFilePath = new Path(String.valueOf(qualifiedTypeName) + ".java");
            int qSegmentCount = qSourceFilePath.segmentCount();
            int i = 0;
            int l = this.additionalUnits.length;
            while (i < l) {
                block9: {
                    SourceFile additionalUnit = this.additionalUnits[i];
                    IPath fullPath = additionalUnit.resource.getFullPath();
                    int prefixCount = additionalUnit.sourceLocation.sourceFolder.getFullPath().segmentCount();
                    if (qSegmentCount == fullPath.segmentCount() - prefixCount) {
                        int j = 0;
                        while (j < qSegmentCount) {
                            if (qSourceFilePath.segment(j).equals(fullPath.segment(j + prefixCount))) {
                                ++j;
                                continue;
                            }
                            break block9;
                        }
                        return new NameEnvironmentAnswer(additionalUnit);
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public NameEnvironmentAnswer findType(char[][] compoundName) {
        if (compoundName != null) {
            return this.findClass(new String(CharOperation.concatWith(compoundName, '/')), compoundName[compoundName.length - 1]);
        }
        return null;
    }

    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
        if (typeName != null) {
            return this.findClass(new String(CharOperation.concatWith(packageName, typeName, '/')), typeName);
        }
        return null;
    }

    public boolean isPackage(char[][] compoundName, char[] packageName) {
        return this.isPackage(new String(CharOperation.concatWith(compoundName, packageName, '/')));
    }

    public boolean isPackage(String qualifiedPackageName) {
        return false;
    }

    void setNames(String[] initialTypeNames, SourceFile[] additionalUnits) {
        this.initialTypeNames = initialTypeNames;
        this.additionalUnits = additionalUnits;
        int i = 0;
        int l = this.sourceLocations.length;
        while (i < l) {
            this.sourceLocations[i].reset();
            ++i;
        }
    }
}

