/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core;

import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IJavaModelStatus;
import net.sourceforge.phpdt.core.ISourceReference;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.internal.core.JavaModelStatus;
import net.sourceforge.phpdt.internal.core.MoveElementsOperation;
import net.sourceforge.phpdt.internal.core.util.Util;

public class RenameElementsOperation
extends MoveElementsOperation {
    public RenameElementsOperation(IJavaElement[] elements, IJavaElement[] destinations, String[] newNames, boolean force) {
        super(elements, destinations, force);
        this.setRenamings(newNames);
    }

    protected String getMainTaskName() {
        return Util.bind("operation.renameElementProgress");
    }

    protected boolean isRename() {
        return true;
    }

    protected IJavaModelStatus verify() {
        IJavaModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        if (this.fRenamingsList == null || this.fRenamingsList.length == 0) {
            return new JavaModelStatus(982);
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    protected void verify(IJavaElement element) throws JavaModelException {
        int elementType = element.getElementType();
        if (element == null || !element.exists()) {
            this.error(969, element);
        }
        if (element.isReadOnly()) {
            this.error(976, element);
        }
        if (!(element instanceof ISourceReference)) {
            this.error(967, element);
        }
        if (elementType < 7 || elementType == 10) {
            this.error(967, element);
        }
        this.verifyRenaming(element);
    }
}

