/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core;

import java.util.ArrayList;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IJavaElementDelta;
import net.sourceforge.phpdt.internal.core.JavaElement;
import net.sourceforge.phpdt.internal.core.SimpleDelta;
import org.eclipse.core.resources.IResourceDelta;

public class JavaElementDelta
extends SimpleDelta
implements IJavaElementDelta {
    protected IJavaElement fChangedElement;
    private int fKind = 0;
    private int fChangeFlags = 0;
    protected IJavaElementDelta[] fAffectedChildren = fgEmptyDelta;
    protected IResourceDelta[] resourceDeltas = null;
    protected int resourceDeltasCounter;
    protected IJavaElement fMovedFromHandle = null;
    protected IJavaElement fMovedToHandle = null;
    protected static IJavaElementDelta[] fgEmptyDelta = new IJavaElementDelta[0];

    public JavaElementDelta(IJavaElement element) {
        this.fChangedElement = element;
    }

    protected void addAffectedChild(JavaElementDelta child) {
        switch (this.fKind) {
            case 1: 
            case 2: {
                return;
            }
            case 4: {
                this.fChangeFlags |= 8;
                break;
            }
            default: {
                this.fKind = 4;
                this.fChangeFlags |= 8;
            }
        }
        if (this.fChangedElement.getElementType() >= 5) {
            this.fineGrained();
        }
        if (this.fAffectedChildren.length == 0) {
            this.fAffectedChildren = new IJavaElementDelta[]{child};
            return;
        }
        IJavaElementDelta existingChild = null;
        int existingChildIndex = -1;
        if (this.fAffectedChildren != null) {
            int i = 0;
            while (i < this.fAffectedChildren.length) {
                if (this.equalsAndSameParent(this.fAffectedChildren[i].getElement(), child.getElement())) {
                    existingChild = this.fAffectedChildren[i];
                    existingChildIndex = i;
                    break;
                }
                ++i;
            }
        }
        if (existingChild == null) {
            this.fAffectedChildren = this.growAndAddToArray(this.fAffectedChildren, child);
        } else {
            switch (existingChild.getKind()) {
                case 1: {
                    switch (child.getKind()) {
                        case 1: 
                        case 4: {
                            return;
                        }
                        case 2: {
                            this.fAffectedChildren = this.removeAndShrinkArray(this.fAffectedChildren, existingChildIndex);
                            return;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (child.getKind()) {
                        case 1: {
                            child.fKind = 4;
                            this.fAffectedChildren[existingChildIndex] = child;
                            return;
                        }
                        case 2: 
                        case 4: {
                            return;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (child.getKind()) {
                        case 1: 
                        case 2: {
                            this.fAffectedChildren[existingChildIndex] = child;
                            return;
                        }
                        case 4: {
                            IJavaElementDelta[] children = child.getAffectedChildren();
                            int i = 0;
                            while (i < children.length) {
                                JavaElementDelta childsChild = (JavaElementDelta)children[i];
                                ((JavaElementDelta)existingChild).addAffectedChild(childsChild);
                                ++i;
                            }
                            switch (((JavaElementDelta)existingChild).fChangeFlags) {
                                case 64: 
                                case 128: 
                                case 4096: 
                                case 8192: {
                                    ((JavaElementDelta)existingChild).fChangeFlags |= child.fChangeFlags;
                                }
                            }
                            IResourceDelta[] resDeltas = child.getResourceDeltas();
                            if (resDeltas != null) {
                                ((JavaElementDelta)existingChild).resourceDeltas = resDeltas;
                                ((JavaElementDelta)existingChild).resourceDeltasCounter = child.resourceDeltasCounter;
                            }
                            return;
                        }
                    }
                    break;
                }
                default: {
                    int flags = existingChild.getFlags();
                    this.fAffectedChildren[existingChildIndex] = child;
                    child.fChangeFlags |= flags;
                }
            }
        }
    }

    public void added(IJavaElement element) {
        this.added(element, 0);
    }

    public void added(IJavaElement element, int flags) {
        JavaElementDelta addedDelta = new JavaElementDelta(element);
        addedDelta.added();
        addedDelta.changeFlags |= flags;
        this.insertDeltaTree(element, addedDelta);
    }

    protected void addResourceDelta(IResourceDelta child) {
        switch (this.fKind) {
            case 1: 
            case 2: {
                return;
            }
            case 4: {
                this.fChangeFlags |= 1;
                break;
            }
            default: {
                this.fKind = 4;
                this.fChangeFlags |= 1;
            }
        }
        if (this.resourceDeltas == null) {
            this.resourceDeltas = new IResourceDelta[5];
            this.resourceDeltas[this.resourceDeltasCounter++] = child;
            return;
        }
        if (this.resourceDeltas.length == this.resourceDeltasCounter) {
            this.resourceDeltas = new IResourceDelta[this.resourceDeltasCounter * 2];
            System.arraycopy(this.resourceDeltas, 0, this.resourceDeltas, 0, this.resourceDeltasCounter);
        }
        this.resourceDeltas[this.resourceDeltasCounter++] = child;
    }

    public JavaElementDelta changed(IJavaElement element, int changeFlag) {
        JavaElementDelta changedDelta = new JavaElementDelta(element);
        changedDelta.changed(changeFlag);
        this.insertDeltaTree(element, changedDelta);
        return changedDelta;
    }

    public void contentChanged() {
        this.fChangeFlags |= 1;
    }

    public void closed(IJavaElement element) {
        JavaElementDelta delta = new JavaElementDelta(element);
        delta.fKind = 4;
        delta.fChangeFlags |= 0x400;
        this.insertDeltaTree(element, delta);
    }

    protected JavaElementDelta createDeltaTree(IJavaElement element, JavaElementDelta delta) {
        JavaElementDelta childDelta = delta;
        ArrayList ancestors = this.getAncestors(element);
        if (ancestors == null) {
            if (this.equalsAndSameParent(delta.getElement(), this.getElement())) {
                this.fKind = delta.fKind;
                this.fChangeFlags = delta.fChangeFlags;
                this.fMovedToHandle = delta.fMovedToHandle;
                this.fMovedFromHandle = delta.fMovedFromHandle;
            }
        } else {
            int i = 0;
            int size = ancestors.size();
            while (i < size) {
                IJavaElement ancestor = (IJavaElement)ancestors.get(i);
                JavaElementDelta ancestorDelta = new JavaElementDelta(ancestor);
                ancestorDelta.addAffectedChild(childDelta);
                childDelta = ancestorDelta;
                ++i;
            }
        }
        return childDelta;
    }

    protected boolean equalsAndSameParent(IJavaElement e1, IJavaElement e2) {
        IJavaElement parent1;
        return e1.equals(e2) && (parent1 = e1.getParent()) != null && parent1.equals(e2.getParent());
    }

    protected JavaElementDelta find(IJavaElement e) {
        if (this.equalsAndSameParent(this.fChangedElement, e)) {
            return this;
        }
        int i = 0;
        while (i < this.fAffectedChildren.length) {
            JavaElementDelta delta = ((JavaElementDelta)this.fAffectedChildren[i]).find(e);
            if (delta != null) {
                return delta;
            }
            ++i;
        }
        return null;
    }

    public void fineGrained() {
        if (this.fKind == 0) {
            this.fKind = 4;
        }
        this.fChangeFlags |= 0x4000;
    }

    public IJavaElementDelta[] getAddedChildren() {
        return this.getChildrenOfType(1);
    }

    public IJavaElementDelta[] getAffectedChildren() {
        return this.fAffectedChildren;
    }

    private ArrayList getAncestors(IJavaElement element) {
        IJavaElement parent = element.getParent();
        if (parent == null) {
            return null;
        }
        ArrayList<IJavaElement> parents = new ArrayList<IJavaElement>();
        while (!parent.equals(this.fChangedElement)) {
            parents.add(parent);
            parent = parent.getParent();
            if (parent != null) continue;
            return null;
        }
        parents.trimToSize();
        return parents;
    }

    public IJavaElementDelta[] getChangedChildren() {
        return this.getChildrenOfType(4);
    }

    protected IJavaElementDelta[] getChildrenOfType(int type) {
        int length = this.fAffectedChildren.length;
        if (length == 0) {
            return new IJavaElementDelta[0];
        }
        ArrayList<IJavaElementDelta> children = new ArrayList<IJavaElementDelta>(length);
        int i = 0;
        while (i < length) {
            if (this.fAffectedChildren[i].getKind() == type) {
                children.add(this.fAffectedChildren[i]);
            }
            ++i;
        }
        IJavaElementDelta[] childrenOfType = new IJavaElementDelta[children.size()];
        children.toArray(childrenOfType);
        return childrenOfType;
    }

    protected JavaElementDelta getDeltaFor(IJavaElement element) {
        if (this.equalsAndSameParent(this.getElement(), element)) {
            return this;
        }
        if (this.fAffectedChildren.length == 0) {
            return null;
        }
        int childrenCount = this.fAffectedChildren.length;
        int i = 0;
        while (i < childrenCount) {
            JavaElementDelta delta = (JavaElementDelta)this.fAffectedChildren[i];
            if (this.equalsAndSameParent(delta.getElement(), element)) {
                return delta;
            }
            if ((delta = delta.getDeltaFor(element)) != null) {
                return delta;
            }
            ++i;
        }
        return null;
    }

    public IJavaElement getElement() {
        return this.fChangedElement;
    }

    public int getFlags() {
        return this.fChangeFlags;
    }

    public int getKind() {
        return this.fKind;
    }

    public IJavaElement getMovedFromElement() {
        return this.fMovedFromHandle;
    }

    public IJavaElement getMovedToElement() {
        return this.fMovedToHandle;
    }

    public IJavaElementDelta[] getRemovedChildren() {
        return this.getChildrenOfType(2);
    }

    public IResourceDelta[] getResourceDeltas() {
        if (this.resourceDeltas == null) {
            return null;
        }
        if (this.resourceDeltas.length != this.resourceDeltasCounter) {
            this.resourceDeltas = new IResourceDelta[this.resourceDeltasCounter];
            System.arraycopy(this.resourceDeltas, 0, this.resourceDeltas, 0, this.resourceDeltasCounter);
        }
        return this.resourceDeltas;
    }

    protected IJavaElementDelta[] growAndAddToArray(IJavaElementDelta[] array, IJavaElementDelta addition) {
        IJavaElementDelta[] old = array;
        array = new IJavaElementDelta[old.length + 1];
        System.arraycopy(old, 0, array, 0, old.length);
        array[old.length] = addition;
        return array;
    }

    protected void insertDeltaTree(IJavaElement element, JavaElementDelta delta) {
        JavaElementDelta childDelta = this.createDeltaTree(element, delta);
        if (!this.equalsAndSameParent(element, this.getElement())) {
            this.addAffectedChild(childDelta);
        }
    }

    public void movedFrom(IJavaElement movedFromElement, IJavaElement movedToElement) {
        JavaElementDelta removedDelta = new JavaElementDelta(movedFromElement);
        removedDelta.fKind = 2;
        removedDelta.fChangeFlags |= 0x20;
        removedDelta.fMovedToHandle = movedToElement;
        this.insertDeltaTree(movedFromElement, removedDelta);
    }

    public void movedTo(IJavaElement movedToElement, IJavaElement movedFromElement) {
        JavaElementDelta addedDelta = new JavaElementDelta(movedToElement);
        addedDelta.fKind = 1;
        addedDelta.fChangeFlags |= 0x10;
        addedDelta.fMovedFromHandle = movedFromElement;
        this.insertDeltaTree(movedToElement, addedDelta);
    }

    public void opened(IJavaElement element) {
        JavaElementDelta delta = new JavaElementDelta(element);
        delta.fKind = 4;
        delta.fChangeFlags |= 0x200;
        this.insertDeltaTree(element, delta);
    }

    protected void removeAffectedChild(JavaElementDelta child) {
        int index = -1;
        if (this.fAffectedChildren != null) {
            int i = 0;
            while (i < this.fAffectedChildren.length) {
                if (this.equalsAndSameParent(this.fAffectedChildren[i].getElement(), child.getElement())) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        if (index >= 0) {
            this.fAffectedChildren = this.removeAndShrinkArray(this.fAffectedChildren, index);
        }
    }

    protected IJavaElementDelta[] removeAndShrinkArray(IJavaElementDelta[] old, int index) {
        int rest;
        IJavaElementDelta[] array = new IJavaElementDelta[old.length - 1];
        if (index > 0) {
            System.arraycopy(old, 0, array, 0, index);
        }
        if ((rest = old.length - index - 1) > 0) {
            System.arraycopy(old, index + 1, array, index, rest);
        }
        return array;
    }

    public void removed(IJavaElement element) {
        this.removed(element, 0);
    }

    public void removed(IJavaElement element, int flags) {
        JavaElementDelta removedDelta = new JavaElementDelta(element);
        this.insertDeltaTree(element, removedDelta);
        JavaElementDelta actualDelta = this.getDeltaFor(element);
        if (actualDelta != null) {
            actualDelta.removed();
            actualDelta.changeFlags |= flags;
            actualDelta.fAffectedChildren = fgEmptyDelta;
        }
    }

    public void sourceAttached(IJavaElement element) {
        JavaElementDelta attachedDelta = new JavaElementDelta(element);
        attachedDelta.fKind = 4;
        attachedDelta.fChangeFlags |= 0x1000;
        this.insertDeltaTree(element, attachedDelta);
    }

    public void sourceDetached(IJavaElement element) {
        JavaElementDelta detachedDelta = new JavaElementDelta(element);
        detachedDelta.fKind = 4;
        detachedDelta.fChangeFlags |= 0x2000;
        this.insertDeltaTree(element, detachedDelta);
    }

    public String toDebugString(int depth) {
        int i;
        StringBuffer buffer = new StringBuffer();
        int i2 = 0;
        while (i2 < depth) {
            buffer.append('\t');
            ++i2;
        }
        buffer.append(((JavaElement)this.getElement()).toDebugString());
        buffer.append("[");
        switch (this.getKind()) {
            case 1: {
                buffer.append('+');
                break;
            }
            case 2: {
                buffer.append('-');
                break;
            }
            case 4: {
                buffer.append('*');
                break;
            }
            default: {
                buffer.append('?');
            }
        }
        buffer.append("]: {");
        int changeFlags = this.getFlags();
        boolean prev = false;
        if ((changeFlags & 8) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("CHILDREN");
            prev = true;
        }
        if ((changeFlags & 1) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("CONTENT");
            prev = true;
        }
        if ((changeFlags & 0x10) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("MOVED_FROM(" + ((JavaElement)this.getMovedFromElement()).toStringWithAncestors() + ")");
            prev = true;
        }
        if ((changeFlags & 0x20) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("MOVED_TO(" + ((JavaElement)this.getMovedToElement()).toStringWithAncestors() + ")");
            prev = true;
        }
        if ((changeFlags & 0x40) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("ADDED TO CLASSPATH");
            prev = true;
        }
        if ((changeFlags & 0x80) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("REMOVED FROM CLASSPATH");
            prev = true;
        }
        if ((changeFlags & 0x100) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("REORDERED");
            prev = true;
        }
        if ((changeFlags & 0x8000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("ARCHIVE CONTENT CHANGED");
            prev = true;
        }
        if ((changeFlags & 0x1000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("SOURCE ATTACHED");
            prev = true;
        }
        if ((changeFlags & 0x2000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("SOURCE DETACHED");
            prev = true;
        }
        if ((changeFlags & 2) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("MODIFIERS CHANGED");
            prev = true;
        }
        if ((changeFlags & 0x800) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("SUPER TYPES CHANGED");
            prev = true;
        }
        if ((changeFlags & 0x4000) != 0) {
            if (prev) {
                buffer.append(" | ");
            }
            buffer.append("FINE GRAINED");
            prev = true;
        }
        buffer.append("}");
        IJavaElementDelta[] children = this.getAffectedChildren();
        if (children != null) {
            i = 0;
            while (i < children.length) {
                buffer.append("\n");
                buffer.append(((JavaElementDelta)children[i]).toDebugString(depth + 1));
                ++i;
            }
        }
        i = 0;
        while (i < this.resourceDeltasCounter) {
            buffer.append("\n");
            int j = 0;
            while (j < depth + 1) {
                buffer.append('\t');
                ++j;
            }
            IResourceDelta resourceDelta = this.resourceDeltas[i];
            buffer.append(resourceDelta.toString());
            buffer.append("[");
            switch (resourceDelta.getKind()) {
                case 1: {
                    buffer.append('+');
                    break;
                }
                case 2: {
                    buffer.append('-');
                    break;
                }
                case 4: {
                    buffer.append('*');
                    break;
                }
                default: {
                    buffer.append('?');
                }
            }
            buffer.append("]");
            ++i;
        }
        return buffer.toString();
    }

    public String toString() {
        return this.toDebugString(0);
    }
}

