/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IJavaModelStatus;
import net.sourceforge.phpdt.core.IMember;
import net.sourceforge.phpdt.core.IParent;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.core.jdom.DOMFactory;
import net.sourceforge.phpdt.core.jdom.IDOMCompilationUnit;
import net.sourceforge.phpdt.core.jdom.IDOMNode;
import net.sourceforge.phpdt.internal.core.CreateElementInCUOperation;
import net.sourceforge.phpdt.internal.core.DeleteElementsOperation;
import net.sourceforge.phpdt.internal.core.JavaElement;
import net.sourceforge.phpdt.internal.core.JavaModelOperation;
import net.sourceforge.phpdt.internal.core.JavaModelStatus;
import net.sourceforge.phpdt.internal.core.MultiOperation;
import net.sourceforge.phpdt.internal.core.util.Util;

public class CopyElementsOperation
extends MultiOperation {
    private Map fSources = new HashMap();

    public CopyElementsOperation(IJavaElement[] elementsToCopy, IJavaElement[] destContainers, boolean force) {
        super(elementsToCopy, destContainers, force);
    }

    public CopyElementsOperation(IJavaElement[] elementsToCopy, IJavaElement destContainer, boolean force) {
        this(elementsToCopy, new IJavaElement[]{destContainer}, force);
    }

    protected String getMainTaskName() {
        return Util.bind("operation.copyElementProgress");
    }

    protected JavaModelOperation getNestedOperation(IJavaElement element) {
        return null;
    }

    private String getSourceFor(IJavaElement element) throws JavaModelException {
        String source = (String)this.fSources.get(element);
        if (source == null && element instanceof IMember) {
            IMember member = (IMember)element;
            ICompilationUnit cu = member.getCompilationUnit();
            String cuSource = cu.getSource();
            IDOMCompilationUnit domCU = new DOMFactory().createCompilationUnit(cuSource, cu.getElementName());
            IDOMNode node = ((JavaElement)element).findNode(domCU);
            source = new String(node.getCharacters());
            this.fSources.put(element, source);
        }
        return source;
    }

    protected boolean isRenamingMainType(IJavaElement element, IJavaElement dest) {
        if ((this.isRename() || this.getNewNameFor(element) != null) && dest.getElementType() == 5) {
            String typeName = dest.getElementName();
            typeName = typeName.substring(0, typeName.length() - 5);
            return element.getElementName().equals(typeName) && element.getParent().equals(dest);
        }
        return false;
    }

    protected void processElement(IJavaElement element) throws JavaModelException {
        JavaModelOperation op = this.getNestedOperation(element);
        boolean createElementInCUOperation = op instanceof CreateElementInCUOperation;
        if (op == null) {
            return;
        }
        if (createElementInCUOperation) {
            IJavaElement anchor;
            IJavaElement sibling = (IJavaElement)this.fInsertBeforeElements.get(element);
            if (sibling != null) {
                ((CreateElementInCUOperation)op).setRelativePosition(sibling, 3);
            } else if (this.isRename() && (anchor = this.resolveRenameAnchor(element)) != null) {
                ((CreateElementInCUOperation)op).setRelativePosition(anchor, 2);
            }
            String newName = this.getNewNameFor(element);
            if (newName != null) {
                ((CreateElementInCUOperation)op).setAlteredName(newName);
            }
        }
        this.executeNestedOperation(op, 1);
        JavaElement destination = (JavaElement)this.getDestinationParent(element);
        ICompilationUnit unit = destination.getCompilationUnit();
        if (!unit.isWorkingCopy()) {
            unit.close();
        }
        if (createElementInCUOperation && this.isMove() && !this.isRenamingMainType(element, destination)) {
            DeleteElementsOperation deleteOp = new DeleteElementsOperation(new IJavaElement[]{element}, this.force);
            this.executeNestedOperation(deleteOp, 1);
        }
    }

    private IJavaElement resolveRenameAnchor(IJavaElement element) throws JavaModelException {
        IParent parent = (IParent)((Object)element.getParent());
        IJavaElement[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            IJavaElement child = children[i];
            if (child.equals(element)) {
                return child;
            }
            ++i;
        }
        return null;
    }

    protected IJavaModelStatus verify() {
        IJavaModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        if (this.fRenamingsList != null && this.fRenamingsList.length != this.fElementsToProcess.length) {
            return new JavaModelStatus(980);
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    protected void verify(IJavaElement element) throws JavaModelException {
        if (element == null || !element.exists()) {
            this.error(969, element);
        }
        if (element.getElementType() < 7) {
            this.error(967, element);
        }
        if (element.isReadOnly()) {
            this.error(976, element);
        }
        IJavaElement dest = this.getDestinationParent(element);
        this.verifyDestination(element, dest);
        this.verifySibling(element, dest);
        if (this.fRenamingsList != null) {
            this.verifyRenaming(element);
        }
    }
}

