/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core;

import java.util.Enumeration;
import net.sourceforge.phpdt.core.IBuffer;
import net.sourceforge.phpdt.core.IBufferFactory;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IOpenable;
import net.sourceforge.phpdt.internal.core.Buffer;
import net.sourceforge.phpdt.internal.core.BufferCache;
import net.sourceforge.phpdt.internal.core.OverflowingLRUCache;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class BufferManager
implements IBufferFactory {
    protected static BufferManager DEFAULT_BUFFER_MANAGER;
    protected OverflowingLRUCache openBuffers = new BufferCache(60);

    protected void addBuffer(IBuffer buffer) {
        this.openBuffers.put(buffer.getOwner(), buffer);
    }

    public IBuffer createBuffer(IOpenable owner) {
        IJavaElement element = (IJavaElement)((Object)owner);
        IResource resource = element.getResource();
        return new Buffer(resource instanceof IFile ? (IFile)resource : null, owner, element.isReadOnly());
    }

    public IBuffer getBuffer(IOpenable owner) {
        return (IBuffer)this.openBuffers.get(owner);
    }

    public static synchronized BufferManager getDefaultBufferManager() {
        if (DEFAULT_BUFFER_MANAGER == null) {
            DEFAULT_BUFFER_MANAGER = new BufferManager();
        }
        return DEFAULT_BUFFER_MANAGER;
    }

    public IBufferFactory getDefaultBufferFactory() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getOpenBuffers() {
        OverflowingLRUCache overflowingLRUCache = this.openBuffers;
        synchronized (overflowingLRUCache) {
            this.openBuffers.shrink();
            return this.openBuffers.elements();
        }
    }

    protected void removeBuffer(IBuffer buffer) {
        this.openBuffers.remove(buffer.getOwner());
    }
}

