/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.problem;

import net.sourceforge.phpdt.core.compiler.IProblem;
import net.sourceforge.phpdt.internal.compiler.problem.ProblemSeverities;
import net.sourceforge.phpdt.internal.compiler.util.Util;

public class DefaultProblem
implements ProblemSeverities,
IProblem {
    private char[] fileName;
    private int id;
    private int startPosition;
    private int endPosition;
    private int line;
    private int severity;
    private String[] arguments;
    private String message;

    public DefaultProblem(char[] originatingFileName, String message, int id, String[] stringArguments, int severity, int startPosition, int endPosition, int line) {
        this.fileName = originatingFileName;
        this.message = message;
        this.id = id;
        this.arguments = stringArguments;
        this.severity = severity;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.line = line;
    }

    public String errorReportSource(char[] unitSource) {
        char c;
        if (this.startPosition > this.endPosition || this.startPosition < 0 && this.endPosition < 0) {
            return Util.bind("problem.noSourceInformation");
        }
        StringBuffer errorBuffer = new StringBuffer(" ");
        errorBuffer.append(Util.bind("problem.atLine", String.valueOf(this.line)));
        errorBuffer.append("\n\t");
        int length = unitSource.length;
        int begin = this.startPosition >= length ? length - 1 : this.startPosition;
        while (begin > 0) {
            c = unitSource[begin - 1];
            if (c == '\n' || c == '\r') break;
            --begin;
        }
        int end = this.endPosition >= length ? length - 1 : this.endPosition;
        while (end + 1 < length) {
            c = unitSource[end + 1];
            if (c == '\r' || c == '\n') break;
            ++end;
        }
        while ((c = unitSource[begin]) == ' ' || c == '\t') {
            ++begin;
        }
        errorBuffer.append(unitSource, begin, end - begin + 1);
        errorBuffer.append("\n\t");
        int i = begin;
        while (i < this.startPosition) {
            errorBuffer.append(unitSource[i] == '\t' ? (char)'\t' : ' ');
            ++i;
        }
        i = this.startPosition;
        while (i <= (this.endPosition >= length ? length - 1 : this.endPosition)) {
            errorBuffer.append('^');
            ++i;
        }
        return errorBuffer.toString();
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public int getID() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    public char[] getOriginatingFileName() {
        return this.fileName;
    }

    public int getSourceEnd() {
        return this.endPosition;
    }

    public int getSourceLineNumber() {
        return this.line;
    }

    public int getSourceStart() {
        return this.startPosition;
    }

    public boolean isError() {
        return (this.severity & 1) != 0;
    }

    public boolean isWarning() {
        return (this.severity & 1) == 0;
    }

    public void setSourceEnd(int sourceEnd) {
        this.endPosition = sourceEnd;
    }

    public void setSourceLineNumber(int lineNumber) {
        this.line = lineNumber;
    }

    public void setSourceStart(int sourceStart) {
        this.startPosition = sourceStart;
    }

    public String toString() {
        String s = "Pb(" + (this.id & 0xFFFFFF) + ") ";
        if (this.message != null) {
            s = String.valueOf(s) + this.message;
        } else if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                s = String.valueOf(s) + " " + this.arguments[i];
                ++i;
            }
        }
        return s;
    }
}

