/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.lookup;

import net.sourceforge.phpdt.internal.compiler.ast.FieldDeclaration;
import net.sourceforge.phpdt.internal.compiler.impl.Constant;
import net.sourceforge.phpdt.internal.compiler.lookup.ArrayBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.InvocationSite;
import net.sourceforge.phpdt.internal.compiler.lookup.PackageBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.ReferenceBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.Scope;
import net.sourceforge.phpdt.internal.compiler.lookup.SourceTypeBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.VariableBinding;

public class FieldBinding
extends VariableBinding {
    public ReferenceBinding declaringClass;

    protected FieldBinding() {
    }

    public FieldBinding(char[] name, TypeBinding type, int modifiers, ReferenceBinding declaringClass, Constant constant) {
        this.modifiers = modifiers;
        this.type = type;
        this.name = name;
        this.declaringClass = declaringClass;
        this.constant = constant;
        if (this.declaringClass != null && this.declaringClass.isViewedAsDeprecated() && !this.isDeprecated()) {
            this.modifiers |= 0x200000;
        }
    }

    public FieldBinding(FieldDeclaration field, TypeBinding type, ReferenceBinding declaringClass) {
        this(field.name, type, field.modifiers, declaringClass, null);
        field.binding = this;
    }

    public FieldBinding(FieldBinding initialFieldBinding, ReferenceBinding declaringClass) {
        this.modifiers = initialFieldBinding.modifiers;
        this.type = initialFieldBinding.type;
        this.name = initialFieldBinding.name;
        this.declaringClass = declaringClass;
        this.constant = initialFieldBinding.constant;
        this.id = initialFieldBinding.id;
    }

    public final int bindingType() {
        return 1;
    }

    public final boolean canBeSeenBy(TypeBinding receiverType, InvocationSite invocationSite, Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding invocationType = scope.enclosingSourceType();
        if (invocationType == this.declaringClass && invocationType == receiverType) {
            return true;
        }
        if (this.isProtected()) {
            if (invocationType == this.declaringClass) {
                return true;
            }
            if (invocationType.fPackage == this.declaringClass.fPackage) {
                return true;
            }
            ReferenceBinding currentType = invocationType;
            int depth = 0;
            do {
                if (this.declaringClass.isSuperclassOf(currentType)) {
                    if (invocationSite.isSuperAccess()) {
                        return true;
                    }
                    if (receiverType instanceof ArrayBinding) {
                        return false;
                    }
                    if (this.isStatic()) {
                        return true;
                    }
                    if (currentType == receiverType || currentType.isSuperclassOf((ReferenceBinding)receiverType)) {
                        if (depth > 0) {
                            invocationSite.setDepth(depth);
                        }
                        return true;
                    }
                }
                ++depth;
            } while ((currentType = currentType.enclosingType()) != null);
            return false;
        }
        if (this.isPrivate()) {
            if (receiverType != this.declaringClass) {
                return false;
            }
            if (invocationType != this.declaringClass) {
                ReferenceBinding outerInvocationType = invocationType;
                ReferenceBinding temp = outerInvocationType.enclosingType();
                while (temp != null) {
                    outerInvocationType = temp;
                    temp = temp.enclosingType();
                }
                ReferenceBinding outerDeclaringClass = this.declaringClass;
                temp = outerDeclaringClass.enclosingType();
                while (temp != null) {
                    outerDeclaringClass = temp;
                    temp = temp.enclosingType();
                }
                if (outerInvocationType != outerDeclaringClass) {
                    return false;
                }
            }
            return true;
        }
        if (invocationType.fPackage != this.declaringClass.fPackage) {
            return false;
        }
        if (receiverType instanceof ArrayBinding) {
            return false;
        }
        ReferenceBinding type = (ReferenceBinding)receiverType;
        PackageBinding declaringPackage = this.declaringClass.fPackage;
        do {
            if (this.declaringClass == type) {
                return true;
            }
            if (declaringPackage == type.fPackage) continue;
            return false;
        } while ((type = type.superclass()) != null);
        return false;
    }

    public final int getAccessFlags() {
        return this.modifiers & 0xFFFF;
    }

    public final boolean isDefault() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x100000) != 0;
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isPrivateUsed() {
        return (this.modifiers & 0x8000000) != 0;
    }

    public final boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public final boolean isViewedAsDeprecated() {
        return (this.modifiers & 0x100000) != 0 || (this.modifiers & 0x200000) != 0;
    }
}

