/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.OperatorExpression;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.impl.Constant;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;

public class UnaryExpression
extends OperatorExpression {
    public Expression expression;
    public Constant optimizedBooleanConstant;

    public UnaryExpression(Expression expression, int operator) {
        this.expression = expression;
        this.bits |= operator << 6;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if ((this.bits & 0xFC0) >> 6 == 11) {
            return this.expression.analyseCode(currentScope, flowContext, flowInfo).asNegatedCondition();
        }
        return this.expression.analyseCode(currentScope, flowContext, flowInfo);
    }

    public Constant optimizedBooleanConstant() {
        return this.optimizedBooleanConstant == null ? this.constant : this.optimizedBooleanConstant;
    }

    public TypeBinding resolveType(BlockScope scope) {
        int tableId;
        TypeBinding expressionType = this.expression.resolveType(scope);
        if (expressionType == null) {
            this.constant = NotAConstant;
            return null;
        }
        int expressionId = expressionType.id;
        if (expressionId > 15) {
            this.constant = NotAConstant;
            scope.problemReporter().invalidOperator(this, expressionType);
            return null;
        }
        switch ((this.bits & 0xFC0) >> 6) {
            case 11: {
                tableId = 0;
                break;
            }
            case 12: {
                tableId = 10;
                break;
            }
            default: {
                tableId = 13;
            }
        }
        int result = ResolveTypeTables[tableId][(expressionId << 4) + expressionId];
        this.expression.implicitConversion = result >>> 12;
        this.bits |= result & 0xF;
        switch (result & 0xF) {
            case 5: {
                this.resolvedType = BooleanBinding;
                break;
            }
            case 3: {
                this.resolvedType = ByteBinding;
                break;
            }
            case 2: {
                this.resolvedType = CharBinding;
                break;
            }
            case 8: {
                this.resolvedType = DoubleBinding;
                break;
            }
            case 9: {
                this.resolvedType = FloatBinding;
                break;
            }
            case 10: {
                this.resolvedType = IntBinding;
                break;
            }
            case 7: {
                this.resolvedType = LongBinding;
                break;
            }
            default: {
                this.constant = Constant.NotAConstant;
                if (expressionId != 0) {
                    scope.problemReporter().invalidOperator(this, expressionType);
                }
                return null;
            }
        }
        if (this.expression.constant != Constant.NotAConstant) {
            this.constant = Constant.computeConstantOperation(this.expression.constant, expressionId, (this.bits & 0xFC0) >> 6);
        } else {
            Constant cst;
            this.constant = Constant.NotAConstant;
            if ((this.bits & 0xFC0) >> 6 == 11 && (cst = this.expression.optimizedBooleanConstant()) != Constant.NotAConstant) {
                this.optimizedBooleanConstant = Constant.fromValue(!cst.booleanValue());
            }
        }
        return this.resolvedType;
    }

    public StringBuffer printExpressionNoParenthesis(int indent, StringBuffer output) {
        output.append(this.operatorToString()).append(' ');
        return this.expression.printExpression(0, output);
    }

    public String toStringExpressionNoParenthesis() {
        return String.valueOf(this.operatorToString()) + " " + this.expression.toStringExpression();
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.expression.traverse(visitor, blockScope);
        }
        visitor.endVisit(this, blockScope);
    }
}

