/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.AbstractMethodDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.Argument;
import net.sourceforge.phpdt.internal.compiler.ast.Block;
import net.sourceforge.phpdt.internal.compiler.ast.Statement;
import net.sourceforge.phpdt.internal.compiler.codegen.Label;
import net.sourceforge.phpdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FinallyFlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.flow.InsideSubRoutineFlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.UnconditionalFlowInfo;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.LocalVariableBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.MethodBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.MethodScope;
import net.sourceforge.phpdt.internal.compiler.lookup.ReferenceBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;

public class TryStatement
extends Statement {
    public Block tryBlock;
    public Block[] catchBlocks;
    public Argument[] catchArguments;
    public Block finallyBlock;
    BlockScope scope;
    public boolean subRoutineCannotReturn = true;
    public UnconditionalFlowInfo subRoutineInits;
    ReferenceBinding[] caughtExceptionTypes;
    boolean tryBlockExit;
    boolean[] catchExits;
    public int[] preserveExceptionHandler;
    Label subRoutineStartLabel;
    public LocalVariableBinding anyExceptionVariable;
    public LocalVariableBinding returnAddressVariable;
    public LocalVariableBinding secretReturnValue;
    public static final char[] SecretReturnName = " returnAddress".toCharArray();
    public static final char[] SecretAnyHandlerName = " anyExceptionHandler".toCharArray();
    public static final char[] SecretLocalDeclarationName = " returnValue".toCharArray();
    int preTryInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo tryInfo;
        UnconditionalFlowInfo subInfo;
        FinallyFlowContext finallyContext;
        InsideSubRoutineFlowContext insideSubContext;
        this.preTryInitStateIndex = currentScope.methodScope().recordInitializationStates(flowInfo);
        if (this.anyExceptionVariable != null) {
            this.anyExceptionVariable.useFlag = 1;
        }
        if (this.returnAddressVariable != null) {
            this.returnAddressVariable.useFlag = 1;
        }
        if (this.subRoutineStartLabel == null) {
            insideSubContext = null;
            finallyContext = null;
            subInfo = null;
        } else {
            insideSubContext = new InsideSubRoutineFlowContext(flowContext, this);
            finallyContext = new FinallyFlowContext(flowContext, this.finallyBlock);
            subInfo = this.finallyBlock.analyseCode(currentScope, finallyContext, flowInfo.copy()).unconditionalInits();
            if (subInfo.isReachable()) {
                this.subRoutineCannotReturn = false;
            }
            this.subRoutineInits = subInfo;
        }
        ExceptionHandlingFlowContext handlingContext = new ExceptionHandlingFlowContext(insideSubContext == null ? flowContext : insideSubContext, this.tryBlock, this.caughtExceptionTypes, this.scope, flowInfo.unconditionalInits());
        if (this.tryBlock.statements == null) {
            tryInfo = flowInfo;
            this.tryBlockExit = false;
        } else {
            tryInfo = this.tryBlock.analyseCode(currentScope, handlingContext, flowInfo.copy());
            boolean bl = this.tryBlockExit = !tryInfo.isReachable();
        }
        if (this.catchArguments != null) {
            int catchCount = this.catchBlocks.length;
            this.catchExits = new boolean[catchCount];
            int i = 0;
            while (i < catchCount) {
                FlowInfo catchInfo = flowInfo.copy().unconditionalInits().addPotentialInitializationsFrom(handlingContext.initsOnException(this.caughtExceptionTypes[i]).unconditionalInits()).addPotentialInitializationsFrom(tryInfo.unconditionalInits()).addPotentialInitializationsFrom(handlingContext.initsOnReturn);
                catchInfo.markAsDefinitelyAssigned(this.catchArguments[i].binding);
                if (this.tryBlock.statements == null) {
                    catchInfo.setReachMode(1);
                }
                catchInfo = this.catchBlocks[i].analyseCode(currentScope, insideSubContext == null ? flowContext : insideSubContext, catchInfo);
                this.catchExits[i] = !catchInfo.isReachable();
                tryInfo = tryInfo.mergedWith(catchInfo.unconditionalInits());
                ++i;
            }
        }
        if (this.subRoutineStartLabel == null) {
            this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(tryInfo);
            return tryInfo;
        }
        finallyContext.complainOnRedundantFinalAssignments(tryInfo.isReachable() ? tryInfo.addPotentialInitializationsFrom(insideSubContext.initsOnReturn) : insideSubContext.initsOnReturn, currentScope);
        if (subInfo == FlowInfo.DEAD_END) {
            this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(subInfo);
            return subInfo;
        }
        FlowInfo mergedInfo = tryInfo.addInitializationsFrom(subInfo);
        this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
        return mergedInfo;
    }

    public boolean cannotReturn() {
        return this.subRoutineCannotReturn;
    }

    public void resetStateForCodeGeneration() {
        if (this.subRoutineStartLabel != null) {
            this.subRoutineStartLabel.resetStateForCodeGeneration();
        }
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        TryStatement.printIndent(indent, output).append("try \n");
        this.tryBlock.printStatement(indent + 1, output);
        if (this.catchBlocks != null) {
            int i = 0;
            while (i < this.catchBlocks.length) {
                output.append('\n');
                TryStatement.printIndent(indent, output).append("catch (");
                this.catchArguments[i].print(0, output).append(") ");
                this.catchBlocks[i].printStatement(indent + 1, output);
                ++i;
            }
        }
        if (this.finallyBlock != null) {
            output.append('\n');
            TryStatement.printIndent(indent, output).append("finally\n");
            this.finallyBlock.printStatement(indent + 1, output);
        }
        return output;
    }

    public void resolve(BlockScope upperScope) {
        this.scope = new BlockScope(upperScope);
        BlockScope tryScope = new BlockScope(this.scope);
        BlockScope finallyScope = null;
        if (this.finallyBlock != null && this.finallyBlock.statements != null) {
            MethodBinding methodBinding;
            finallyScope = new BlockScope(this.scope, false);
            MethodScope methodScope = this.scope.methodScope();
            this.returnAddressVariable = new LocalVariableBinding(SecretReturnName, (TypeBinding)upperScope.getJavaLangObject(), 0, false);
            finallyScope.addLocalVariable(this.returnAddressVariable);
            this.returnAddressVariable.constant = NotAConstant;
            this.subRoutineStartLabel = new Label();
            this.anyExceptionVariable = new LocalVariableBinding(SecretAnyHandlerName, (TypeBinding)this.scope.getJavaLangThrowable(), 0, false);
            finallyScope.addLocalVariable(this.anyExceptionVariable);
            this.anyExceptionVariable.constant = NotAConstant;
            if (!methodScope.isInsideInitializer() && (methodBinding = ((AbstractMethodDeclaration)methodScope.referenceContext).binding) != null) {
                TypeBinding methodReturnType = methodBinding.returnType;
                if (methodReturnType.id != 6) {
                    this.secretReturnValue = new LocalVariableBinding(SecretLocalDeclarationName, methodReturnType, 0, false);
                    finallyScope.addLocalVariable(this.secretReturnValue);
                    this.secretReturnValue.constant = NotAConstant;
                }
            }
            this.finallyBlock.resolveUsing(finallyScope);
            finallyScope.shiftScopes = new BlockScope[this.catchArguments == null ? 1 : this.catchArguments.length + 1];
            finallyScope.shiftScopes[0] = tryScope;
        }
        this.tryBlock.resolveUsing(tryScope);
        if (this.catchBlocks != null) {
            int length = this.catchArguments.length;
            TypeBinding[] argumentTypes = new TypeBinding[length];
            int i = 0;
            while (i < length) {
                BlockScope catchScope = new BlockScope(this.scope);
                if (finallyScope != null) {
                    finallyScope.shiftScopes[i + 1] = catchScope;
                }
                if ((argumentTypes[i] = this.catchArguments[i].resolveForCatch(catchScope)) == null) {
                    return;
                }
                this.catchBlocks[i].resolveUsing(catchScope);
                ++i;
            }
            this.caughtExceptionTypes = new ReferenceBinding[length];
            i = 0;
            while (i < length) {
                this.caughtExceptionTypes[i] = (ReferenceBinding)argumentTypes[i];
                int j = 0;
                while (j < i) {
                    if (this.caughtExceptionTypes[i].isCompatibleWith(argumentTypes[j])) {
                        this.scope.problemReporter().wrongSequenceOfExceptionTypesError(this, i, j);
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            this.caughtExceptionTypes = new ReferenceBinding[0];
        }
        if (finallyScope != null) {
            this.scope.addSubscope(finallyScope);
        }
    }

    public String toString(int tab) {
        String s = TryStatement.tabString(tab);
        s = String.valueOf(s) + "try ";
        s = this.tryBlock == Block.None ? String.valueOf(s) + "{}" : String.valueOf(s) + "\n" + this.tryBlock.toString(tab + 1);
        if (this.catchBlocks != null) {
            int i = 0;
            while (i < this.catchBlocks.length) {
                s = String.valueOf(s) + "\n" + TryStatement.tabString(tab) + "catch (" + this.catchArguments[i].toString(0) + ") " + this.catchBlocks[i].toString(tab + 1);
                ++i;
            }
        }
        if (this.finallyBlock != null) {
            s = this.finallyBlock == Block.None ? String.valueOf(s) + "\n" + TryStatement.tabString(tab) + "finally {}" : String.valueOf(s) + "\n" + TryStatement.tabString(tab) + "finally\n" + this.finallyBlock.toString(tab + 1);
        }
        return s;
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.tryBlock.traverse(visitor, this.scope);
            if (this.catchArguments != null) {
                int i = 0;
                int max = this.catchBlocks.length;
                while (i < max) {
                    this.catchArguments[i].traverse(visitor, this.scope);
                    this.catchBlocks[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
            if (this.finallyBlock != null) {
                this.finallyBlock.traverse(visitor, this.scope);
            }
        }
        visitor.endVisit(this, blockScope);
    }
}

