/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.Block;
import net.sourceforge.phpdt.internal.compiler.ast.CompilationUnitDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.FieldDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.TypeDeclaration;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.lookup.MethodScope;
import net.sourceforge.phpdt.internal.compiler.lookup.SourceTypeBinding;
import net.sourceforge.phpdt.internal.compiler.parser.UnitParser;

public class Initializer
extends FieldDeclaration {
    public Block block;
    public int lastFieldID;
    public int bodyStart;

    public Initializer(Block block, int modifiers) {
        this.block = block;
        this.modifiers = modifiers;
        this.sourceStart = this.bodyStart = block.sourceStart;
        this.declarationSourceStart = this.bodyStart;
    }

    public FlowInfo analyseCode(MethodScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.block.analyseCode(currentScope, flowContext, flowInfo);
    }

    public boolean isField() {
        return false;
    }

    public boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public void parseStatements(UnitParser parser, TypeDeclaration type, CompilationUnitDeclaration unit) {
        parser.parse(this, type, unit);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resolve(MethodScope scope) {
        int previous = scope.fieldDeclarationIndex;
        try {
            SourceTypeBinding declaringType;
            scope.fieldDeclarationIndex = this.lastFieldID;
            if (this.isStatic() && (declaringType = scope.enclosingSourceType()).isNestedType() && !declaringType.isStatic()) {
                scope.problemReporter().innerTypesCannotDeclareStaticInitializers(declaringType, this);
            }
            this.block.resolve(scope);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            scope.fieldDeclarationIndex = previous;
            throw throwable;
        }
        {
            Object var4_6 = null;
            scope.fieldDeclarationIndex = previous;
            return;
        }
    }

    public String toString(int tab) {
        if (this.modifiers != 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(Initializer.tabString(tab));
            buffer.append(Initializer.modifiersString(this.modifiers));
            buffer.append("{\n");
            buffer.append(this.block.toStringStatements(tab));
            buffer.append(Initializer.tabString(tab));
            buffer.append("}");
            return buffer.toString();
        }
        return this.block.toString(tab);
    }

    public void traverse(ASTVisitor visitor, MethodScope scope) {
        if (visitor.visit(this, scope)) {
            this.block.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

