/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.FieldReference;
import net.sourceforge.phpdt.internal.compiler.ast.QualifiedThisReference;
import net.sourceforge.phpdt.internal.compiler.ast.Reference;
import net.sourceforge.phpdt.internal.compiler.ast.SingleNameReference;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.lookup.BaseTypeBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.Binding;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;

public class Assignment
extends Expression {
    public Expression lhs;
    public Expression expression;

    public Assignment(Expression lhs, Expression expression, int sourceEnd) {
        this.lhs = lhs;
        lhs.bits |= 0x2000;
        this.expression = expression;
        this.sourceStart = lhs.sourceStart;
        this.sourceEnd = sourceEnd;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return ((Reference)this.lhs).analyseAssignment(currentScope, flowContext, flowInfo, this, false).unconditionalInits();
    }

    void checkAssignmentEffect(BlockScope scope) {
        Binding left = this.getDirectBinding(this.lhs);
        if (left != null && left == this.getDirectBinding(this.expression)) {
            scope.problemReporter().assignmentHasNoEffect(this, left.shortReadableName());
            this.bits |= 0x20000000;
        }
    }

    Binding getDirectBinding(Expression someExpression) {
        if (someExpression instanceof SingleNameReference) {
            return ((SingleNameReference)someExpression).binding;
        }
        if (someExpression instanceof FieldReference) {
            FieldReference fieldRef = (FieldReference)someExpression;
            if (fieldRef.receiver.isThis() && !(fieldRef.receiver instanceof QualifiedThisReference)) {
                return fieldRef.binding;
            }
        }
        return null;
    }

    public StringBuffer print(int indent, StringBuffer output) {
        Assignment.printIndent(indent, output);
        return this.printExpressionNoParenthesis(indent, output);
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append('(');
        return this.printExpressionNoParenthesis(0, output).append(')');
    }

    public StringBuffer printExpressionNoParenthesis(int indent, StringBuffer output) {
        this.lhs.printExpression(indent, output).append(" = ");
        return this.expression.printExpression(0, output);
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        return this.print(indent, output).append(';');
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.constant = NotAConstant;
        if (!(this.lhs instanceof Reference)) {
            scope.problemReporter().expressionShouldBeAVariable(this.lhs);
        }
        this.resolvedType = this.lhs.resolveType(scope);
        TypeBinding rhsType = this.expression.resolveType(scope);
        if (this.resolvedType == null || rhsType == null) {
            return null;
        }
        this.checkAssignmentEffect(scope);
        if (this.expression.isConstantValueOfTypeAssignableToType(rhsType, this.resolvedType) || this.resolvedType.isBaseType() && BaseTypeBinding.isWidening(this.resolvedType.id, rhsType.id) || rhsType.isCompatibleWith(this.resolvedType)) {
            this.expression.implicitWidening(this.resolvedType, rhsType);
            return this.resolvedType;
        }
        scope.problemReporter().typeMismatchErrorActualTypeExpectedType(this.expression, rhsType, this.resolvedType);
        return this.resolvedType;
    }

    public String toString(int tab) {
        return String.valueOf(Assignment.tabString(tab)) + this.toStringExpressionNoParenthesis();
    }

    public String toStringExpression() {
        return "(" + this.toStringExpressionNoParenthesis() + ")";
    }

    public String toStringExpressionNoParenthesis() {
        return String.valueOf(this.lhs.toStringExpression()) + " " + "=" + (this.expression.constant != null && this.expression.constant != NotAConstant ? " /*cst:" + this.expression.constant.toString() + "*/ " : " ") + this.expression.toStringExpression();
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.lhs.traverse(visitor, scope);
            this.expression.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

