/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xdebug.ui.php.launching;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.sourceforge.phpeclipse.xdebug.core.PathMapItem;
import net.sourceforge.phpeclipse.xdebug.core.XDebugCorePlugin;
import net.sourceforge.phpeclipse.xdebug.ui.EditPathMapDialog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PHPPathMapTab
extends AbstractLaunchConfigurationTab {
    protected TableViewer fPathMapTable;
    protected Button fAddButton;
    protected Button envAddCGIButton;
    protected Button fEditButton;
    protected Button fRemoveButton;
    protected Button fUpButton;
    protected Button fDownButton;
    protected String[] fPathMapTableColumnHeaders = new String[]{"Local", "Remote"};
    protected ColumnLayoutData[] fPathMapTableColumnLayouts = new ColumnLayoutData[]{new ColumnWeightData(50), new ColumnWeightData(50)};
    protected static final String P_REMOTE = "remote";
    protected static final String P_LOCAL = "local";
    protected static String[] fPathMapTableColumnProperties = new String[]{"remote", "local"};

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gridData = new GridData(768);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gridData);
        mainComposite.setFont(parent.getFont());
        this.createPathMapTable(mainComposite);
        this.createTableButtons(mainComposite);
        Dialog.applyDialogFont((Control)mainComposite);
    }

    protected void createTableButtons(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout glayout = new GridLayout();
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.numColumns = 1;
        GridData gdata = new GridData(130);
        buttonComposite.setLayout((Layout)glayout);
        buttonComposite.setLayoutData((Object)gdata);
        buttonComposite.setFont(parent.getFont());
        this.createVerticalSpacer(buttonComposite, 1);
        this.fAddButton = this.createPushButton(buttonComposite, "New", null);
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PHPPathMapTab.this.handleAddButtonSelected();
            }
        });
        this.fEditButton = this.createPushButton(buttonComposite, "Edit", null);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PHPPathMapTab.this.handleEditButtonSelected();
            }
        });
        this.fEditButton.setEnabled(false);
        this.fRemoveButton = this.createPushButton(buttonComposite, "Remove", null);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PHPPathMapTab.this.handleRemoveButtonSelected();
            }
        });
        this.fRemoveButton.setEnabled(false);
        this.fUpButton = this.createPushButton(buttonComposite, "Up", null);
        this.fUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PHPPathMapTab.this.handleUpButtonSelected();
            }
        });
        this.fUpButton.setEnabled(false);
        this.fDownButton = this.createPushButton(buttonComposite, "Down", null);
        this.fDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PHPPathMapTab.this.handleDownButtonSelected();
            }
        });
        this.fDownButton.setEnabled(false);
    }

    protected void createPathMapTable(Composite parent) {
        Font font = parent.getFont();
        Composite tableComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        GridData gridData = new GridData(1808);
        gridData.heightHint = 150;
        tableComposite.setLayout((Layout)layout);
        tableComposite.setLayoutData((Object)gridData);
        tableComposite.setFont(font);
        Label label = new Label(tableComposite, 0);
        label.setFont(font);
        label.setText("&Map remote path to local path");
        this.fPathMapTable = new TableViewer(tableComposite, 68354);
        Table table = this.fPathMapTable.getTable();
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setFont(font);
        gridData = new GridData(1808);
        this.fPathMapTable.getControl().setLayoutData((Object)gridData);
        this.fPathMapTable.setContentProvider((IContentProvider)new PathMapContentProvider());
        this.fPathMapTable.setLabelProvider((IBaseLabelProvider)new PathMapItemLabelProvider());
        this.fPathMapTable.setColumnProperties(fPathMapTableColumnProperties);
        this.fPathMapTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PHPPathMapTab.this.handleTableSelectionChanged(event);
            }
        });
        this.fPathMapTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!PHPPathMapTab.this.fPathMapTable.getSelection().isEmpty()) {
                    PHPPathMapTab.this.handleEditButtonSelected();
                }
            }
        });
        int i = 0;
        while (i < this.fPathMapTableColumnHeaders.length) {
            tableLayout.addColumnData(this.fPathMapTableColumnLayouts[i]);
            TableColumn tc = new TableColumn(table, 0, i);
            tc.setResizable(this.fPathMapTableColumnLayouts[i].resizable);
            tc.setText(this.fPathMapTableColumnHeaders[i]);
            ++i;
        }
    }

    protected void handleTableSelectionChanged(SelectionChangedEvent event) {
        int size = ((IStructuredSelection)event.getSelection()).size();
        int idx = this.fPathMapTable.getTable().getSelectionIndex();
        int count = this.fPathMapTable.getTable().getItemCount();
        if (size == 1) {
            this.fEditButton.setEnabled(idx > 0);
            this.fUpButton.setEnabled(idx > 0);
            this.fDownButton.setEnabled(idx >= 0 && idx < count - 1);
        }
        this.fRemoveButton.setEnabled(size > 0);
    }

    private void handleUpButtonSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.fPathMapTable.getSelection();
        PathMapItem mapItem = (PathMapItem)sel.getFirstElement();
        boolean found = false;
        if (mapItem == null) {
            return;
        }
        IPath local = mapItem.getLocalPath();
        TableItem[] items = this.fPathMapTable.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            PathMapItem item = (PathMapItem)items[i].getData();
            if (item.getLocalPath().equals((Object)local)) {
                found = true;
                break;
            }
            ++i;
        }
        if (i > 0 && found) {
            this.fPathMapTable.getControl().setRedraw(false);
            this.fPathMapTable.remove((Object)mapItem);
            this.fPathMapTable.insert((Object)mapItem, i - 1);
            this.fPathMapTable.getControl().setRedraw(true);
            this.fPathMapTable.setSelection((ISelection)new StructuredSelection((Object)mapItem), true);
            this.updateLaunchConfigurationDialog();
        }
    }

    private void handleDownButtonSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.fPathMapTable.getSelection();
        PathMapItem mapItem = (PathMapItem)sel.getFirstElement();
        boolean found = false;
        if (mapItem == null) {
            return;
        }
        IPath local = mapItem.getLocalPath();
        TableItem[] items = this.fPathMapTable.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            PathMapItem item = (PathMapItem)items[i].getData();
            if (item.getLocalPath().equals((Object)local)) {
                found = true;
                break;
            }
            ++i;
        }
        if (i < items.length - 1 && found) {
            this.fPathMapTable.getControl().setRedraw(false);
            this.fPathMapTable.remove((Object)mapItem);
            this.fPathMapTable.insert((Object)mapItem, i + 1);
            this.fPathMapTable.getControl().setRedraw(true);
            this.fPathMapTable.setSelection((ISelection)new StructuredSelection((Object)mapItem), true);
            this.updateLaunchConfigurationDialog();
        }
    }

    private void handleEditButtonSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.fPathMapTable.getSelection();
        PathMapItem item = (PathMapItem)sel.getFirstElement();
        if (item == null) {
            return;
        }
        EditPathMapDialog dialog = new EditPathMapDialog(this.getShell(), "Edit pathmap", new String[]{item.getLocalPath().toString(), item.getRemotePath().toString()});
        if (dialog.open() != 0) {
            return;
        }
        String[] pathPair = dialog.getPathPair();
        String newLocalPath = pathPair[0];
        String newRemotePath = pathPair[1];
        if (!item.getLocalPath().toString().equals(newLocalPath)) {
            if (this.addVariable(new PathMapItem(newLocalPath, newRemotePath))) {
                this.fPathMapTable.remove((Object)item);
            }
        } else {
            item.setRemotePath(newRemotePath);
            this.fPathMapTable.update((Object)item, null);
            this.updateLaunchConfigurationDialog();
        }
    }

    protected void handleAddButtonSelected() {
        EditPathMapDialog dialog = new EditPathMapDialog(this.getShell(), "Edit File Map", new String[]{"", ""});
        if (dialog.open() != 0) {
            return;
        }
        String[] pathPair = dialog.getPathPair();
        Path local = new Path(pathPair[0]);
        Path remote = new Path(pathPair[1]);
        String strlocal = local.toString();
        String strremote = remote.toString();
        if (strlocal != null && strremote != null && strlocal.length() > 0 && strremote.length() > 0) {
            this.addVariable(new PathMapItem(strlocal, strremote));
        }
    }

    private void handleRemoveButtonSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.fPathMapTable.getSelection();
        this.fPathMapTable.getControl().setRedraw(false);
        Iterator i = sel.iterator();
        while (i.hasNext()) {
            PathMapItem item = (PathMapItem)i.next();
            this.fPathMapTable.remove((Object)item);
        }
        this.fPathMapTable.getControl().setRedraw(true);
        this.updateLaunchConfigurationDialog();
    }

    protected boolean addVariable(PathMapItem mapItem) {
        IPath local = mapItem.getLocalPath();
        TableItem[] items = this.fPathMapTable.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            PathMapItem item = (PathMapItem)items[i].getData();
            if (item.getLocalPath().equals((Object)local)) {
                boolean overWrite = MessageDialog.openQuestion((Shell)this.getShell(), (String)"Overwrite variable?", (String)MessageFormat.format("A local path named {0} already exists. Overwrite?", local.toString()));
                if (!overWrite) {
                    return false;
                }
                this.fPathMapTable.remove((Object)item);
                break;
            }
            ++i;
        }
        this.fPathMapTable.add((Object)mapItem);
        this.updateLaunchConfigurationDialog();
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.fPathMapTable.setInput((Object)configuration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        TableItem[] items = this.fPathMapTable.getTable().getItems();
        Vector<String> vec = new Vector<String>(items.length);
        int i = 0;
        while (i < items.length) {
            PathMapItem item = (PathMapItem)items[i].getData();
            vec.add(item.getStringData());
            ++i;
        }
        if (vec.size() == 0) {
            configuration.setAttribute("net.sourceforge.phpeclipse.xdebug.php.ATTR_PHP_PATHMAP", null);
        } else {
            configuration.setAttribute("net.sourceforge.phpeclipse.xdebug.php.ATTR_PHP_PATHMAP", vec);
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (this.fPathMapTable.getTable().getItems().length == 0) {
            this.setErrorMessage("Mappath empty!");
            return false;
        }
        return true;
    }

    public String getName() {
        return "Pathmap";
    }

    protected class PathMapContentProvider
    implements IStructuredContentProvider {
        protected PathMapContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            List l;
            Object[] elements = new PathMapItem[]{};
            ILaunchConfiguration config = (ILaunchConfiguration)inputElement;
            try {
                l = config.getAttribute("net.sourceforge.phpeclipse.xdebug.php.ATTR_PHP_PATHMAP", null);
            }
            catch (CoreException e) {
                XDebugCorePlugin.log((IStatus)new Status(4, "net.sourceforge.phpeclipse.xdebug.core", 4, "Error reading configuration", (Throwable)e));
                return elements;
            }
            if (l != null && !l.isEmpty()) {
                elements = new PathMapItem[l.size()];
                int i = 0;
                while (i < l.size()) {
                    elements[i] = new PathMapItem((String)l.get(i));
                    ++i;
                }
            }
            return elements;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class PathMapItemLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element != null) {
                PathMapItem var = (PathMapItem)element;
                switch (columnIndex) {
                    case 0: {
                        result = var.getLocalPath().toOSString();
                        break;
                    }
                    case 1: {
                        result = var.getRemotePath().toString();
                    }
                }
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

