/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xdebug.ui;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class XDebugUIPlugin
extends AbstractUIPlugin {
    private static final String BUNDLE_NAME = "net.sourceforge.phpeclipse.xdebug.ui.XDebugUIMessages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("net.sourceforge.phpeclipse.xdebug.ui.XDebugUIMessages");
    private static final String PLUGIN_ID = "net.sourceforge.phpeclipse.xdebug.ui";
    private static XDebugUIPlugin plugin;

    public XDebugUIPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static XDebugUIPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static String getUniqueIdentifier() {
        return PLUGIN_ID;
    }

    public static void errorDialog(Shell shell, String title, String message, IStatus s) {
        if (s != null && message.equals(s.getMessage())) {
            message = null;
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)s);
    }

    public static void errorDialog(Shell shell, String title, String message, Throwable t) {
        IStatus status;
        if (t instanceof CoreException) {
            status = ((CoreException)t).getStatus();
            if (status != null && message.equals(status.getMessage())) {
                message = null;
            }
        } else {
            status = new Status(4, XDebugUIPlugin.getUniqueIdentifier(), 4, "Error within Debug UI: ", t);
            XDebugUIPlugin.log(status);
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
    }

    public static void log(IStatus status) {
        XDebugUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        XDebugUIPlugin.log((IStatus)new Status(4, XDebugUIPlugin.getUniqueIdentifier(), 4, "Internal Error", e));
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static String getString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return String.valueOf('!') + key + '!';
        }
    }
}

