/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.phphelp.actions;

import java.io.IOException;
import java.text.MessageFormat;
import net.sourceforge.phpdt.phphelp.PHPHelpPlugin;
import net.sourceforge.phpdt.phphelp.actions.PHPFunctionHelpResource;
import net.sourceforge.phpeclipse.phpeditor.PHPEditor;
import net.sourceforge.phpeclipse.phpeditor.php.PHPWordExtractor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionDelegate;

public class PHPEclipseShowContextHelp
extends ActionDelegate
implements IEditorActionDelegate {
    private IWorkbenchWindow window;
    private PHPEditor editor;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (!selection.isEmpty()) {
            if (selection instanceof TextSelection) {
                action.setEnabled(true);
            } else if (this.window.getActivePage() != null) {
                this.window.getActivePage().getActivePart();
            }
        }
    }

    public void run(IAction action) {
        IEditorPart targetEditor;
        if (this.editor == null && (targetEditor = this.window.getActivePage().getActiveEditor()) != null && targetEditor instanceof PHPEditor) {
            this.editor = (PHPEditor)targetEditor;
        }
        if (this.editor != null) {
            ITextSelection selection = (ITextSelection)this.editor.getSelectionProvider().getSelection();
            IDocument doc = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
            if (this.window == null) {
                this.window = this.editor.getSite().getWorkbenchWindow();
            }
            int pos = selection.getOffset();
            String word = this.getFunctionName(doc, pos);
            this.openContextHelp(word);
        }
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor != null && targetEditor instanceof PHPEditor) {
            this.editor = (PHPEditor)targetEditor;
        }
    }

    public void openContextHelp(String word) {
        IPreferenceStore store = PHPHelpPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("_php_chm_enabled")) {
            String[] arguments = new String[]{store.getString("_php_chm_file"), word};
            MessageFormat form = new MessageFormat(store.getString("_php_chm_command"));
            try {
                Runtime runtime = Runtime.getRuntime();
                String command = form.format(arguments);
                runtime.exec(command);
            }
            catch (IOException iOException) {}
        } else {
            PHPFunctionHelpResource helpResource = new PHPFunctionHelpResource(word);
            this.window.getWorkbench().getHelpSystem().displayHelpResource(helpResource.getHref());
        }
    }

    private String getFunctionName(IDocument doc, int pos) {
        Point word = PHPWordExtractor.findWord((IDocument)doc, (int)pos);
        if (word != null) {
            try {
                return doc.get(word.x, word.y).replace('_', '-');
            }
            catch (BadLocationException badLocationException) {}
        }
        return "";
    }
}

