/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.debug.ui;

import net.sourceforge.phpdt.internal.debug.ui.PHPDebugUiMessages;
import net.sourceforge.phpdt.internal.debug.ui.PHPDebugUiPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class PHPExecutionArgumentsPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    protected Text interpreterArgumentsText;
    protected Text programArgumentsText;

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        new Label(composite, 0).setText(PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPArguments.interpreter_args_box_title"));
        new Label(composite, 0).setText("                      ");
        this.interpreterArgumentsText = new Text(composite, 2048);
        GridData interpreterArgumentsData = new GridData(256);
        interpreterArgumentsData.horizontalSpan = 2;
        this.interpreterArgumentsText.setLayoutData((Object)interpreterArgumentsData);
        this.interpreterArgumentsText.setText(this.getArgument("interpreter"));
        new Label(composite, 0).setText(PHPDebugUiMessages.getString("LaunchConfigurationTab.PHPArguments.program_args_box_title"));
        this.programArgumentsText = new Text(composite, 2048);
        GridData programArgumentsData = new GridData(256);
        programArgumentsData.horizontalSpan = 2;
        this.programArgumentsText.setLayoutData((Object)programArgumentsData);
        this.programArgumentsText.setText(this.getArgument("program"));
        return composite;
    }

    protected String getArgument(String name) {
        String argumentValue = null;
        try {
            argumentValue = ((IFile)this.getElement()).getPersistentProperty(new QualifiedName("executionArguments", name));
        }
        catch (CoreException coreException) {}
        return argumentValue != null ? argumentValue : "";
    }

    public boolean performOk() {
        IFile phpFile = (IFile)this.getElement();
        try {
            phpFile.setPersistentProperty(new QualifiedName("executionArguments", "interpreter"), this.interpreterArgumentsText.getText());
            phpFile.setPersistentProperty(new QualifiedName("executionArguments", "program"), this.programArgumentsText.getText());
        }
        catch (CoreException e) {
            PHPDebugUiPlugin.log(e);
            return false;
        }
        return true;
    }
}

