/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.debug.core.watch;

import java.util.Vector;
import net.sourceforge.phpdt.internal.debug.core.PHPDBGProxy;
import net.sourceforge.phpdt.internal.debug.core.model.PHPDebugTarget;
import net.sourceforge.phpdt.internal.debug.core.model.PHPStackFrame;
import net.sourceforge.phpdt.internal.debug.core.model.PHPValue;
import net.sourceforge.phpdt.internal.debug.core.model.PHPVariable;
import net.sourceforge.phpdt.internal.debug.core.watch.PHPWatchExpressionResult;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;

public class PHPWatchExpressionDelegate
implements IWatchExpressionDelegate {
    public void evaluateExpression(String expression, IDebugElement context, IWatchExpressionListener listener) {
        PHPWatchExpressionResult x;
        if (!(context instanceof PHPStackFrame)) {
            PHPWatchExpressionResult x2 = new PHPWatchExpressionResult(expression, null, null);
            listener.watchEvaluationFinished((IWatchExpressionResult)x2);
            return;
        }
        PHPDBGProxy dbg = ((PHPDebugTarget)context.getDebugTarget()).getPHPDBGProxy();
        PHPStackFrame s = (PHPStackFrame)context;
        try {
            PHPVariable[] result = dbg.eval(s, expression);
            if (result.length == 0) {
                x = new PHPWatchExpressionResult(expression, null, null);
            } else {
                switch (result[0].getReferenceType()) {
                    case 4: 
                    case 5: {
                        result[0].setName(expression);
                        this.reset(result[0]);
                    }
                }
                x = new PHPWatchExpressionResult(expression, result[0].getValue(), null);
            }
        }
        catch (Exception e) {
            String[] s1 = new String[]{e.toString()};
            x = new PHPWatchExpressionResult(expression, null, s1);
        }
        listener.watchEvaluationFinished((IWatchExpressionResult)x);
    }

    private void reset(PHPVariable variable) {
        switch (variable.getReferenceType()) {
            case 4: {
                PHPValue value = (PHPValue)variable.getValue();
                Vector variables = value.getChildVariables();
                int i = 0;
                while (i < variables.size()) {
                    PHPVariable var = (PHPVariable)variables.get(i);
                    String name = var.getName();
                    if (var.getLongName().equals(name)) {
                        var.setName(name);
                    } else {
                        var.setParent(variable);
                    }
                    this.reset(var);
                    ++i;
                }
                break;
            }
            case 5: {
                PHPValue value = (PHPValue)variable.getValue();
                Vector variables = value.getChildVariables();
                int i = 0;
                while (i < variables.size()) {
                    PHPVariable var = (PHPVariable)variables.get(i);
                    var.setParent(variable);
                    this.reset(var);
                    ++i;
                }
                break;
            }
        }
    }
}

