/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.debug.core.breakpoints;

import java.util.Map;
import net.sourceforge.phpdt.internal.debug.core.breakpoints.PHPBreakpoint;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;

public class PHPLineBreakpoint
extends PHPBreakpoint
implements IBreakpoint,
ILineBreakpoint {
    private static final String PHP_LINE_BREAKPOINT = "net.sourceforge.phpeclipse.debug.core.phpLineBreakpointMarker";

    public PHPLineBreakpoint() {
    }

    public PHPLineBreakpoint(IResource resource, int lineNumber, int charStart, int charEnd, int hitCount, boolean add, Map attributes) throws DebugException {
        this(resource, lineNumber, charStart, charEnd, hitCount, add, attributes, PHP_LINE_BREAKPOINT);
    }

    public PHPLineBreakpoint(IResource resource, int lineNumber, int hitCount, boolean add, Map attributes) throws DebugException {
        this(resource, lineNumber, -1, -1, hitCount, add, attributes, PHP_LINE_BREAKPOINT);
    }

    protected PHPLineBreakpoint(final IResource resource, final int lineNumber, final int charStart, final int charEnd, final int hitCount, final boolean add, final Map attributes, final String markerType) throws DebugException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                PHPLineBreakpoint.this.setMarker(resource.createMarker(markerType));
                PHPLineBreakpoint.this.addLineBreakpointAttributes(attributes, PHPLineBreakpoint.this.getModelIdentifier(), true, lineNumber, charStart, charEnd, hitCount);
                PHPLineBreakpoint.this.ensureMarker().setAttributes(attributes);
                PHPLineBreakpoint.this.register(add);
            }
        };
        this.run(wr);
    }

    public void addLineBreakpointAttributes(Map attributes, String modelIdentifier, boolean enabled, int lineNumber, int charStart, int charEnd, int hitCount) {
        attributes.put("org.eclipse.debug.core.id", modelIdentifier);
        attributes.put("org.eclipse.debug.core.enabled", new Boolean(enabled));
        attributes.put("lineNumber", new Integer(lineNumber));
        if (charStart != -1) {
            attributes.put("charStart", new Integer(charStart));
            attributes.put("charEnd", new Integer(charEnd));
        }
        attributes.put("net.sourceforge.phpeclipse.debug.typeName", "typeName");
        attributes.put("net.sourceforge.phpeclipse.debug.hitCount", new Integer(hitCount));
        attributes.put("net.sourceforge.phpeclipse.debug.condition", new String(""));
        attributes.put("net.sourceforge.phpeclipse.debug.conditionEnabled", new Boolean(false));
        attributes.put("net.sourceforge.phpeclipse.debug.changeID", new Integer(0));
    }

    public int getLineNumber() throws CoreException {
        return this.ensureMarker().getAttribute("lineNumber", -1);
    }

    public int getCharStart() throws CoreException {
        return this.ensureMarker().getAttribute("charStart", -1);
    }

    public int getCharEnd() throws CoreException {
        return this.ensureMarker().getAttribute("charEnd", -1);
    }

    public static String getMarkerType() {
        return PHP_LINE_BREAKPOINT;
    }

    public int getHitCount() throws CoreException {
        return this.ensureMarker().getAttribute("net.sourceforge.phpeclipse.debug.hitCount", 1);
    }

    public int getChangeID() throws CoreException {
        return this.ensureMarker().getAttribute("net.sourceforge.phpeclipse.debug.changeID", 1);
    }

    public void setChangeID(int changeID) throws CoreException {
        this.ensureMarker().setAttribute("net.sourceforge.phpeclipse.debug.changeID", changeID);
    }

    public String getCondition() throws CoreException {
        return this.ensureMarker().getAttribute("net.sourceforge.phpeclipse.debug.condition", "");
    }

    public void setCondition(String condition) throws CoreException {
        this.ensureMarker().setAttribute("net.sourceforge.phpeclipse.debug.condition", (Object)condition);
    }

    public void setConditionEnabled(boolean enabled) throws CoreException {
        this.ensureMarker().setAttribute("net.sourceforge.phpeclipse.debug.conditionEnabled", enabled);
    }

    public boolean isConditionEnabled() throws CoreException {
        return this.ensureMarker().getAttribute("net.sourceforge.phpeclipse.debug.conditionEnabled", false);
    }
}

