/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.debug.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import net.sourceforge.phpdt.internal.debug.core.PHPDBGInterface;
import net.sourceforge.phpdt.internal.debug.core.PHPDebugCorePlugin;
import net.sourceforge.phpdt.internal.debug.core.SocketUtil;
import net.sourceforge.phpdt.internal.debug.core.breakpoints.PHPLineBreakpoint;
import net.sourceforge.phpdt.internal.debug.core.model.PHPDebugTarget;
import net.sourceforge.phpdt.internal.debug.core.model.PHPStackFrame;
import net.sourceforge.phpdt.internal.debug.core.model.PHPThread;
import net.sourceforge.phpdt.internal.debug.core.model.PHPVariable;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;

public class PHPDBGProxy {
    private ServerSocket server = null;
    private BufferedReader reader = null;
    private PHPDBGInterface DBGInt = null;
    private PHPDebugTarget debugTarget = null;
    private PHPDBGProxy thisProxy = this;
    private PHPLoop phpLoop;
    private PHPThread PHPMainThread;
    private Socket socket;
    private int port;
    private boolean remote;
    private boolean pathtranslation;
    private Map pathmap;
    private IPath remoteSourcePath;

    public PHPDBGProxy() {
    }

    public void updateView() {
        this.getDebugTarget().updateThreads(this.PHPMainThread);
    }

    public PHPDBGProxy(boolean remote, String remoteSourcePath, boolean pathTranslate, Map paths) {
        this.remote = remote;
        this.remoteSourcePath = new Path(remoteSourcePath);
        this.pathmap = paths;
        this.pathtranslation = pathTranslate;
    }

    public void start() {
        this.createServerSocket();
        this.startPHPLoop();
    }

    public void stop() {
        this.phpLoop.setShouldStop();
        if (this.DBGInt != null) {
            this.DBGInt.setShouldStop();
        }
        this.phpLoop.notifyWait();
    }

    public void setTerminated() {
        try {
            this.PHPMainThread.terminate();
        }
        catch (DebugException debugException) {}
    }

    protected ServerSocket getServerSocket() throws IOException {
        if (this.server == null) {
            this.createServerSocket();
        }
        return this.server;
    }

    protected void createServerSocket() {
        this.port = this.remote ? SocketUtil.findUnusedLocalPort("localhost", 10001, 10101) : SocketUtil.findUnusedLocalPort("localhost", 7869, 7869);
        if (this.port == -1) {
            PHPDebugCorePlugin.log(5, "Cannot find free port!!!!");
            return;
        }
        try {
            if (this.server == null) {
                this.server = new ServerSocket(this.port);
            }
        }
        catch (IOException e) {
            PHPDebugCorePlugin.log(e);
            this.stop();
        }
    }

    public Socket getSocket() throws IOException {
        return this.socket;
    }

    protected void setDBGInterface(PHPDBGInterface DBGInt) {
        this.DBGInt = DBGInt;
    }

    public PHPDBGInterface getDBGInterface() {
        return this.DBGInt;
    }

    public BufferedReader getReader() throws IOException {
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader(this.getSocket().getInputStream(), "ISO8859_1"));
        }
        return this.reader;
    }

    public BufferedReader getReader(Socket socket) throws IOException {
        if (socket != null) {
            return new BufferedReader(new InputStreamReader(socket.getInputStream(), "ISO8859_1"));
        }
        return null;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.getSocket().getOutputStream();
    }

    protected void setBreakPoints() throws IOException, CoreException {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
        int i = 0;
        while (i < breakpoints.length) {
            if (breakpoints[i].isEnabled()) {
                this.addBreakpoint(breakpoints[i]);
            }
            ++i;
        }
    }

    private String MapPath(PHPLineBreakpoint phpLBP) {
        IPath filename;
        if (this.remote) {
            filename = phpLBP.getMarker().getResource().getProjectRelativePath();
            filename = this.remoteSourcePath.append(filename);
        } else {
            filename = phpLBP.getMarker().getResource().getFullPath();
        }
        String path = filename.toOSString();
        if (this.pathmap != null && this.remote) {
            Iterator i = this.pathmap.keySet().iterator();
            while (i.hasNext()) {
                String k = (String)i.next();
                if (!path.startsWith(k)) continue;
                path = this.pathmap.get(k) + path.substring(k.length());
                break;
            }
        }
        if (this.remoteSourcePath.isEmpty()) {
            if (this.pathmap != null && this.remote) {
                Iterator iterator = this.pathmap.keySet().iterator();
                while (iterator.hasNext()) {
                    String local = (String)iterator.next();
                    Path remotePath = new Path((String)this.pathmap.get(local));
                    Path localPath = new Path(local);
                    if (!localPath.isPrefixOf(filename)) continue;
                    IPath newpath = filename.removeFirstSegments(localPath.matchingFirstSegments(filename));
                    path = (newpath = remotePath.append(newpath)).toString();
                    path = path.substring(0, 1).equals("/") ? path.replace('\\', '/') : path.replace('/', '\\');
                    return path;
                }
            }
        } else if (this.pathtranslation && this.remote) {
            path = this.remoteSourcePath.toString().substring(0, 1).equals("/") ? path.replace('\\', '/') : path.replace('/', '\\');
        }
        return path;
    }

    public void addBreakpoint(IBreakpoint breakpoint) {
        if (this.DBGInt == null) {
            return;
        }
        int bpNo = 0;
        try {
            if (breakpoint.getModelIdentifier() == PHPDebugCorePlugin.getUniqueIdentifier()) {
                PHPLineBreakpoint phpLBP = (PHPLineBreakpoint)breakpoint;
                bpNo = phpLBP.isConditionEnabled() ? this.DBGInt.addBreakpoint(this.MapPath(phpLBP), phpLBP.getLineNumber(), phpLBP.getHitCount(), phpLBP.getCondition()) : this.DBGInt.addBreakpoint(this.MapPath(phpLBP), phpLBP.getLineNumber(), phpLBP.getHitCount(), "");
                phpLBP.setDBGBpNo(bpNo);
            }
        }
        catch (IOException e) {
            PHPDebugCorePlugin.log(e);
            this.stop();
        }
        catch (CoreException e) {
            PHPDebugCorePlugin.log(e);
            this.stop();
        }
    }

    public void removeBreakpoint(IBreakpoint breakpoint) {
        if (this.DBGInt == null) {
            return;
        }
        try {
            if (breakpoint.getModelIdentifier() == PHPDebugCorePlugin.getUniqueIdentifier()) {
                PHPLineBreakpoint phpLBP = (PHPLineBreakpoint)breakpoint;
                this.DBGInt.removeBreakpoint(this.MapPath(phpLBP), phpLBP.getLineNumber(), phpLBP.getDBGBpNo());
            }
        }
        catch (IOException e) {
            PHPDebugCorePlugin.log(e);
            this.stop();
        }
        catch (CoreException e) {
            PHPDebugCorePlugin.log(e);
            this.stop();
        }
    }

    public void phpLoopNotify() {
        this.phpLoop.notifyWait();
    }

    public void startPHPLoop() {
        this.phpLoop = new PHPLoop();
        this.phpLoop.start();
    }

    public void resume() {
        try {
            this.DBGInt.continueExecution();
            this.phpLoop.notifyWait();
        }
        catch (IOException e) {
            PHPeclipsePlugin.log((String)"Debugging session ended.", (Throwable)e);
            this.stop();
        }
    }

    public void pause() {
        try {
            if (this.DBGInt != null) {
                this.DBGInt.pauseExecution();
            }
        }
        catch (IOException e) {
            PHPDebugCorePlugin.log(e);
            this.stop();
        }
    }

    protected PHPDebugTarget getDebugTarget() {
        return this.debugTarget;
    }

    public void setDebugTarget(PHPDebugTarget debugTarget) {
        this.debugTarget = debugTarget;
        debugTarget.setPHPDBGProxy(this);
    }

    public Vector readVariables(PHPStackFrame frame) {
        try {
            return this.DBGInt.getVariables(frame);
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
            throw new RuntimeException(ioex.getMessage());
        }
        catch (DebugException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex.getMessage());
        }
    }

    public PHPVariable[] eval(PHPStackFrame frame, String evalString) {
        try {
            return this.DBGInt.evalBlock(frame, evalString);
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
            throw new RuntimeException(ioex.getMessage());
        }
        catch (DebugException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void readStepOverEnd(PHPStackFrame stackFrame) {
        try {
            this.DBGInt.stepOver();
            this.phpLoop.notifyWait();
        }
        catch (Exception e) {
            PHPDebugCorePlugin.log(e);
        }
    }

    public void readStepReturnEnd(PHPStackFrame stackFrame) {
        try {
            this.DBGInt.stepOut();
            this.phpLoop.notifyWait();
        }
        catch (Exception e) {
            PHPDebugCorePlugin.log(e);
        }
    }

    public void readStepIntoEnd(PHPStackFrame stackFrame) {
        try {
            this.DBGInt.stepInto();
            this.phpLoop.notifyWait();
        }
        catch (Exception e) {
            PHPDebugCorePlugin.log(e);
        }
    }

    public void closeSocket() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public void closeServerSocket() throws IOException {
        if (this.server != null) {
            this.server.close();
        }
    }

    public int getPort() {
        return this.port;
    }

    class PHPLoop
    extends Thread {
        private boolean shouldStop = false;

        public PHPLoop() {
            this.setName("PHPDebuggerLoop");
        }

        public synchronized void setShouldStop() {
            this.shouldStop = true;
            try {
                PHPDBGProxy.this.closeServerSocket();
            }
            catch (IOException x) {
                PHPDebugCorePlugin.log(x);
            }
        }

        public synchronized void notifyWait() {
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    long interval = 200L;
                    boolean newconnect = false;
                    Socket newSocket = null;
                    PHPDBGProxy.this.PHPMainThread = new PHPThread(PHPDBGProxy.this.getDebugTarget(), PHPDBGProxy.this.getPort());
                    PHPDBGProxy.this.PHPMainThread.setName("Thread [main]");
                    PHPDBGProxy.this.getDebugTarget().addThread(PHPDBGProxy.this.PHPMainThread);
                    while (!this.shouldStop) {
                        newconnect = true;
                        try {
                            newSocket = PHPDBGProxy.this.server.accept();
                        }
                        catch (SocketTimeoutException socketTimeoutException) {
                            newconnect = false;
                        }
                        catch (IOException e) {
                            PHPDebugCorePlugin.log(e);
                            Object var9_11 = null;
                            try {
                                PHPDBGProxy.this.getDebugTarget().terminate();
                                PHPDBGProxy.this.closeSocket();
                                PHPDBGProxy.this.closeServerSocket();
                                return;
                            }
                            catch (IOException e2) {
                                PHPDebugCorePlugin.log(e2);
                                return;
                            }
                        }
                        if (newconnect) {
                            if (PHPDBGProxy.this.DBGInt == null) {
                                PHPDBGProxy.this.server.setSoTimeout(1);
                            }
                            PHPDBGInterface newDBGInt = new PHPDBGInterface(PHPDBGProxy.this.getReader(newSocket), newSocket.getOutputStream(), PHPDBGProxy.this.thisProxy);
                            newDBGInt.waitResponse(1000L);
                            newDBGInt.flushAllPackets();
                            if (PHPDBGProxy.this.DBGInt == null || PHPDBGProxy.this.DBGInt.getSID() == newDBGInt.getSID()) {
                                PHPDBGProxy.this.DBGInt = newDBGInt;
                                try {
                                    PHPDBGProxy.this.closeSocket();
                                }
                                catch (IOException e) {
                                    PHPDebugCorePlugin.log(e);
                                    this.shouldStop = true;
                                }
                                PHPDBGProxy.this.socket = newSocket;
                                PHPDBGProxy.this.setBreakPoints();
                                PHPDBGProxy.this.DBGInt.continueExecution();
                            } else {
                                newDBGInt.continueExecution();
                                newSocket.close();
                            }
                        }
                        if (PHPDBGProxy.this.DBGInt.waitResponse(interval)) {
                            PHPDBGProxy.this.DBGInt.flushAllPackets();
                            if (((PHPDBGProxy)PHPDBGProxy.this).DBGInt.BPUnderHit != 0) {
                                PHPStackFrame[] StackList = PHPDBGProxy.this.DBGInt.getStackList();
                                if (StackList.length > 0) {
                                    int i = 0;
                                    while (true) {
                                        if (i >= StackList.length) {
                                            PHPDBGProxy.this.PHPMainThread.setStackFrames(StackList);
                                            break;
                                        }
                                        StackList[i].setThread(PHPDBGProxy.this.PHPMainThread);
                                        if (PHPDBGProxy.this.DBGInt.getModByNo(StackList[i].getModNo()).equals("")) {
                                            PHPDBGProxy.this.DBGInt.getSourceTree();
                                        }
                                        StackList[i].setFile(PHPDBGProxy.this.DBGInt.getModByNo(StackList[i].getModNo()));
                                        ++i;
                                    }
                                }
                                PHPDBGProxy.this.PHPMainThread.suspend();
                                PHPLoop pHPLoop = this;
                                synchronized (pHPLoop) {
                                    this.wait();
                                }
                            }
                        }
                        if (PHPDBGProxy.this.remote) {
                            if (!PHPDBGProxy.this.PHPMainThread.isTerminated()) continue;
                            this.shouldStop = true;
                        } else {
                            if (!PHPDBGProxy.this.PHPMainThread.isTerminated() && !PHPDBGProxy.this.getDebugTarget().getProcess().isTerminated()) continue;
                            this.shouldStop = true;
                        }
                        break;
                    }
                }
                catch (Exception ex) {
                    PHPDebugCorePlugin.log(ex);
                    System.out.println(ex);
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                try {}
                catch (IOException e2) {
                    PHPDebugCorePlugin.log(e2);
                    return;
                }
                PHPDBGProxy.this.getDebugTarget().terminate();
                PHPDBGProxy.this.closeSocket();
                PHPDBGProxy.this.closeServerSocket();
                throw throwable;
            }
            {
                Object var9_13 = null;
            }
            try {}
            catch (IOException e2) {
                PHPDebugCorePlugin.log(e2);
                return;
            }
            PHPDBGProxy.this.getDebugTarget().terminate();
            PHPDBGProxy.this.closeSocket();
            PHPDBGProxy.this.closeServerSocket();
        }
    }
}

