/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.debug.core;

import java.util.Vector;
import net.sourceforge.phpdt.internal.debug.core.PHPDBGBase;

public class PHPDBGFrame {
    public static final int FRAME_HEADER_SIZE = 8;
    private char[] frameType = new char[4];
    private Vector frameData = new Vector();
    private int frameSize = 0;

    public PHPDBGFrame(int frameType) {
        this.frameType = PHPDBGBase.IntToChar4(frameType);
        this.frameSize += 8;
    }

    public void addInt(int num) {
        char[] newData = PHPDBGBase.IntToChar4(num);
        this.frameData.add(newData);
        this.frameSize += 4;
    }

    public void addChar(char ch) {
        char[] newData = new char[]{ch};
        this.frameData.add(newData);
        ++this.frameSize;
    }

    public void addString(String str) {
        this.frameData.add(str);
        this.frameSize += str.length();
    }

    public int getSize() {
        return this.frameSize;
    }

    public int getSizeOfData() {
        return this.frameSize - 8;
    }

    public char[] getHeader() {
        char[] ret = new char[8];
        PHPDBGBase.copyChars(ret, this.frameType, 4);
        PHPDBGBase.copyCharsTo(ret, PHPDBGBase.IntToChar4(this.getSizeOfData()), 4, 4);
        return ret;
    }

    public char[] getFrameData() {
        char[] ret = new char[this.getSizeOfData()];
        int pos = 0;
        int i = 0;
        while (i < this.frameData.size()) {
            Object conv;
            if (this.frameData.get(i).getClass().getName().equals("[C")) {
                conv = (char[])this.frameData.get(i);
                PHPDBGBase.copyCharsTo(ret, (char[])conv, ((char[])conv).length, pos);
                pos += ((char[])conv).length;
            } else if (this.frameData.get(i).getClass().getName().equals("java.lang.String")) {
                conv = (String)this.frameData.get(i);
                PHPDBGBase.copyCharsTo(ret, ((String)conv).toCharArray(), ((String)conv).length(), pos);
                pos += ((String)conv).length();
            }
            ++i;
        }
        return ret;
    }
}

