# PDFJ demo 
# 2002-5 Sey <nakajima@netstock.co.jp>
use PDFJ;
use strict;

my $doc = PDFJ::Doc->new(1.2, 792, 612);

$doc->add_info(Title => 'PDFJ demo', Author => '<nakajima@netstock.co.jp>');

my $f_h = $doc->new_font('Helvetica');
my $f_t = $doc->new_font('Times-Roman');
my $f_m = $doc->new_font('Ryumin-Light', '90ms-RKSJ-H');
my $f_mt = $doc->new_font('Ryumin-Light', '90ms-RKSJ-H', 'Times-Roman',
	'WinAnsiEncoding', 1.05);
my $f_g = $doc->new_font('GothicBBB-Medium', '90ms-RKSJ-H');
my $f_gh = $doc->new_font('GothicBBB-Medium', '90ms-RKSJ-H', 'Helvetica',
	'WinAnsiEncoding', 1.05);
my $f_mv = $doc->new_font('Ryumin-Light', '90ms-RKSJ-V');
my $f_mtv = $doc->new_font('Ryumin-Light', '90ms-RKSJ-V', 'Times-Roman',
	'WinAnsiEncoding', 1.05);
my $f_gv = $doc->new_font('GothicBBB-Medium', '90ms-RKSJ-V');
my $f_ghv = $doc->new_font('GothicBBB-Medium', '90ms-RKSJ-V', 'Helvetica',
	'WinAnsiEncoding', 1.05);

my $c_darkblue = Color('#191970');
my $c_cadetblue = Color('#5f9ea0');
my $c_lightcyan = Color('#e0ffff');
my $c_white = Color(1);
my $c_gray = Color(0.5);
my $c_red = Color(1,0,0);

my $ss_red = SStyle(fillcolor => $c_red);
my $ss_darkblue = SStyle(fillcolor => $c_darkblue);
my $ss_white = SStyle(fillcolor => $c_white);
my $ss_gray = SStyle(fillcolor => $c_gray);
my $ss_dash = SStyle(linedash => [2,2]);

my $s_bigtitle = TStyle(font => $f_gh, fontsize => 40, 
	shapestyle => $ss_darkblue);
my $s_smalltitle = TStyle(font => $f_gh, fontsize => 30, 
	shapestyle => $ss_darkblue);
my $s_normal = TStyle(font => $f_gh, fontsize => 25);
my $s_normalv = TStyle(font => $f_ghv, fontsize => 25);
my $s_small = TStyle(font => $f_gh, fontsize => 20);

my $width = 712;
my $padding = 20;

my $bs_topframe = 
	BStyle(padding => $padding, align => "mc", withbox => "sfr10", 
		height => 572,
		withboxstyle => 
		SStyle(linewidth => 5, strokecolor => $c_cadetblue, 
			fillcolor => $c_lightcyan));
my $bs_frame = 
	BStyle(padding => $padding, align => "tl", withbox => "sfr10", 
		height => 572,
		withboxstyle => 
		SStyle(linewidth => 5, strokecolor => $c_cadetblue, 
			fillcolor => $c_lightcyan));

my $bs_table = BStyle(adjust => 1);
my $bs_tr = BStyle(adjust => 1);
my $bs_td = BStyle(padding => 10, align => "tl", withbox => "sf", 
	withboxstyle => $ss_white);

my $LabelNum = 1;

sub resetlabelnum {
	$LabelNum = 1;
}

sub numlabel {
	my($fmt, $style) = @_;
	Text(sprintf($fmt, $LabelNum++), $style);
}

my $ps_c40 = PStyle(size => $width, align => 'm', linefeed => 40,
	preskip => 10, postskip => 10);
my $ps_c30 = PStyle(size => $width, align => 'm', linefeed => 30,
	preskip => 7.5, postskip => 7.5);
my $ps_50c = PStyle(size => 300, align => 'w', linefeed => 50,
	preskip => 12.5, postskip => 12.5);
my $ps_50v = PStyle(size => 400, align => 'w', linefeed => 50,
	preskip => 12.5, postskip => 12.5);
my $ps_40 = PStyle(size => $width, align => 'w', linefeed => 40,
	preskip => 10, postskip => 10);
my $ps_35 = PStyle(size => $width, align => 'w', linefeed => 35,
	preskip => 7.5, postskip => 7.5);
my $ps_35dl = $ps_35->clone(labelsize => 30, 
	labeltext => Text('', $s_smalltitle));
my $ps_30 = PStyle(size => $width, align => 'w', linefeed => 30,
	preskip => 7.5, postskip => 7.5);
my $ps_30dl = $ps_30->clone(labelsize => 25,
	labeltext => [\&numlabel, "%d.", $s_normal]);
#	labeltext => Text('', $s_normal));
my $ps_30i = $ps_30->clone(beginindent => 40);
my $ps_30c1 = $ps_30->clone(size => 150);
my $ps_30c2 = $ps_30->clone(size => 500);
my $ps_30c2dl = $ps_30c2->clone(labelsize => 25,
	labeltext => Text('', $s_normal));

my $sp_hr = Shape->style(SStyle(postskip => 5))->line(0,0,$width,0,
	SStyle(strokecolor => $c_cadetblue, linewidth => 2));

my $p1 = $doc->new_page;

Block('V', [
	Paragraph(
		Text('Perlō{PDF', 
		$s_bigtitle), $ps_c40),
	Paragraph(
		Text('{gŃ[gݍPDFW[ PDFJ', 
		$s_bigtitle), $ps_c40),
	Paragraph(
		Text('  <nakajima@netstock.co.jp>', 
		$s_smalltitle), $ps_c30),
	Paragraph(
		Text('2002/5/11 Kansan.pmQNCxg', 
		$s_smalltitle), $ps_c30),
	Paragraph(
		Text('2002/10/18,2003/10/7,2005/2/17,3/13 ', 
		$s_smalltitle), $ps_c30),
], $bs_topframe)->show($p1, 20, 20, 'bl');

my $p2 = $doc->new_page;

Block('V', [
	Paragraph(
		Text([Outline('wiƖړI`1'), 'wiƖړI`1'], 
		$s_bigtitle), $ps_40),
	$sp_hr,
	Paragraph(
		Text('WebAvP[VɈ@\邽߂ɃT[o[œIɓ{PDF𐶐', 
		$s_smalltitle), $ps_35),
	Block('HV', [
		[
			Block('V',
				Paragraph(
					Text('TeX+dvipdfm', $s_normal),
					$ps_30c1),
				$bs_td),
			Block('V',
				[
				Paragraph(Text('T[o[ɂ̃\tgCXg[ȂƂȂ', $s_normal), $ps_30c2dl),
				Paragraph(Text('GȐȂ炱ꂵȂArWlXAvɂ͕sv낤', $s_normal), $ps_30c2dl),
				],
				$bs_td),
		],
		[
			Block('V',
				Paragraph(
					Text('PDFLib', $s_normal),
					$ps_30c1),
				$bs_td),
			Block('V',
				[
				Paragraph(Text('{Ήׂ̍ȂƂ܂ł͖', $s_normal), $ps_30c2dl),
				Paragraph(Text('p̏ꍇCZXKv', $s_normal), $ps_30c2dl),
				],
				$bs_td),
		],
		[
			Block('V',
				Paragraph(
					Text('FOP', $s_normal),
					$ps_30c1),
				$bs_td),
			Block('V',
				[
				Paragraph(Text('[AJAVAc(^^;;;)', $s_normal), $ps_30c2dl),
				Paragraph(Text('XSL͖͂XSLT̂́c(^^;;;)', $s_normal), $ps_30c2dl),
				],
				$bs_td),
		],
	], $bs_table),
	Paragraph(
		Text('Perlł傢傢Ƃ肽Ȃ', $s_smalltitle), 
		$ps_35),
], $bs_frame)->show($p2, 20, 20, 'bl');

my $p3 = $doc->new_page;

Block('V', [
	Paragraph(
		Text([Outline('wiƖړI`2'), 'wiƖړI`2'], 
		$s_bigtitle), $ps_40),
	$sp_hr,
	Paragraph(
		Text('{̂LaTeX̃}N̑PerlXNvgŃCAEgł烉NȂ', 
		$s_smalltitle), $ps_35),
	Paragraph(Text(['LaTeXŕGȃ}Nsōc', Text('i݂܂ATeXnicianȂ̂Łj', $s_small)], $s_normal), $ps_30i),
	Paragraph(
		Text('샂W[Ȃ{gŃ[Ƒgݍ߂邾낤', 
		$s_smalltitle), $ps_35),
	Paragraph(Text(['TeXł͓Ar̔zuƂAǂ݂̎̋󔒂̋lߕƂc', Text('i݂܂ATeXnicianȂ̂Łj', $s_small)], $s_normal), $ps_30i),
], $bs_frame)->show($p3, 20, 20, 'bl');

my $p4 = $doc->new_page;

Block('V', [
	Paragraph(
		Text([Outline('ڕW'), 'ڕW'], 
		$s_bigtitle), $ps_40),
	$sp_hr,
	Paragraph(
		Text('PerlŏiC̃RpCłȂT[o[łg悤Ɂj', 
		$s_smalltitle), $ps_35dl),
	Paragraph(
		Text('{gŃ[iJIS X 4051jgݍ', 
		$s_smalltitle), $ps_35dl),
	Paragraph(
		Text('cOK', 
		$s_smalltitle), $ps_35dl),
	Paragraph(
		Text('iA\AӏA}ƂCAEgvf̃y[Wւ̓K؂Ȕzu', 
		$s_smalltitle), $ps_35dl),
	Paragraph(
		Text('AEgCnCp[NƂPDF@\pł悤ɂ', 
		$s_smalltitle), $ps_35dl),
	Paragraph(
		Text('łt[ɂ', 
		$s_smalltitle), $ps_35dl),
], $bs_frame)->show($p4, 20, 20, 'bl');

my $p5 = $doc->new_page;
resetlabelnum();

Block('V', [
	Paragraph(
		Text([Outline('{gŃ[`1'), '{gŃ[`1'], 
		$s_bigtitle), $ps_40),
	$sp_hr,
	Paragraph(
		Text('JIS X 4051u{ꕶ̍sgŕ@v(1995)̗p', 
		$s_smalltitle), $ps_35),
	Paragraph(
		Text('JIS X 4051̂̂̂T|[g', 
		$s_smalltitle), $ps_35),
	Paragraph(
		Text('񕨂̕ƊԊu', 
		$s_normal), $ps_30dl),
	Paragraph(
		Text('֑ƕ֎~', 
		$s_normal), $ps_30dl),
	Paragraph(
		Text('c', 
		$s_normal), $ps_30dl),
	Paragraph(
		Text('r', 
		$s_normal), $ps_30dl),
	Paragraph(
		Text('Y', 
		$s_normal), $ps_30dl),
	Paragraph(
		Text('_', 
		$s_normal), $ps_30dl),
	Paragraph(
		Text('ET', 
		$s_normal), $ps_30dl),
	Paragraph(
		Text('ŝ߂̊Ԋu@', 
		$s_normal), $ps_30dl),
	Paragraph(
		Text('̃nCtl[V', 
		$s_normal), $ps_30dl),
], $bs_frame)->show($p5, 20, 20, 'bl');

my $p6 = $doc->new_page;
resetlabelnum();

Block('V', [
	Paragraph(
		Text([Outline('{gŃ[`2'), '{gŃ[`2'], 
		$s_bigtitle), $ps_40),
	$sp_hr,
	Paragraph(
		Text('JIS X 4051ƈقȂ_', 
		$s_smalltitle), $ps_35),
	Paragraph(
		Text('Ԃ̊Ԋuׂ͂Č̃̕TCYɏ]', 
		$s_normal), $ps_30dl),
	Paragraph(
		Text('Xy[X͎O󂫂łȂtHgɏ]', 
		$s_normal), $ps_30dl),
	Paragraph(
		Text('͖T|[g', 
		$s_normal), $ps_30dl),
	Paragraph(
		Text('^u͖T|[g', 
		$s_normal), $ps_30dl),
], $bs_frame)->show($p6, 20, 20, 'bl');

my $p7 = $doc->new_page;

Block('V', [
	Paragraph(
		Text([Outline('͂͂ǂH'), '͂͂ǂH'], 
		$s_bigtitle), $ps_40),
	$sp_hr,
	Paragraph(
		Text('PerlXNvgŒڏ͎̂Rx͍ʓ|BȂ炩̃}[NAbv͂ƂPDF𐶐', 
		$s_smalltitle), $ps_35),
	Paragraph(
		Text('ƎAXSLALaTeXAHTML+CSSȂǁA낢l邪c', 
		$s_normal), $ps_30),
	Paragraph(
		Text('XMLx[Xɗ܂XPDFJ',
		$s_smalltitle), $ps_35),
	Paragraph(
		Text('PDFJ𒼐ڌĂԔbp[{}N@\ ',
		$s_normal), $ps_30),
	Paragraph(
		Text('text2pdfpod2pdf܂ByŌ\֗',
		$s_smalltitle), $ps_35),
], $bs_frame)->show($p7, 20, 20, 'bl');

my $p8 = $doc->new_page;
resetlabelnum();

Block('V', [
	Paragraph(
		Text([Outline('ƌv'), 'ƌv'], 
		$s_bigtitle), $ps_40),
	$sp_hr,
	Paragraph(
		Text('ꉞpɂȂ郌x܂łłĂ܂', 
		$s_smalltitle), $ps_35),
	Paragraph(
		Text('ȉۑ', 
		$s_smalltitle), $ps_35),
	Paragraph(
		Text('XPDFJ[Ė{Ă݂',
		$s_normal), $ps_30dl),
	Paragraph(
		Text('PDF̃tH[A߁AdqȂǂ̋@\ւ̑Ή',
		$s_normal), $ps_30dl),
	Paragraph(
		Text('PDF̕ҏW@\ ',
		$s_normal), $ps_30dl),
	Paragraph(
		Text('`[gAIȐ', 
		$s_normal), $ps_30dl),
	Paragraph(
		Text('܂܂oOƎv܂', 
		$s_smalltitle), $ps_35),
], $bs_frame)->show($p8, 20, 20, 'bl');

my $p9 = $doc->new_page;

Block('V', [
	Paragraph(
		Text([Outline('f'), 'f'], 
		$s_bigtitle), $ps_40),
	$sp_hr,
	10,
	Block('H', [
		Block('V', [
			Paragraph(
				Text("", $s_normal),
				$ps_50c),
			Paragraph(
				Text("@u񕨂́AiƊԊujv", $s_normal),
				$ps_50c),
			Paragraph(
				Text([
					Text("SVbNGothic", TStyle(font => $f_gh)),
					" ",
					Text("Minchou", TStyle(font => $f_mt)),
					" ",
					Text("SVbNHankaku", TStyle(font => $f_g)),
					" ",
					Text("Hankaku", TStyle(font => $f_m)),
					" ",
					Text("F", TStyle(shapestyle => $ss_red)),
					" ",
					Text("", TStyle(withline => 1)),
					" ",
					Text("j", 
						TStyle(withline => 1, withlinestyle => $ss_dash)),
					" ",
					Text("_", TStyle(withdot => 1)),
					" ",
					Text("Ԋ|", TStyle(withbox => 'f', withboxstyle => 
						$ss_gray, shapestyle => $ss_white)),
					" ",
					Text("{Α", TStyle(slant => 1)),
					" ",
					"Y", 
					Text("1j", TStyle(suffix => 'u')),
					" ",
					Text("ʒu", TStyle(ruby => "")),
					" ",
					Text("y", TStyle(ruby => "")),
					"",
					Text("x", TStyle(ruby => "oP[V")),
					"B",
					Text("e", TStyle(ruby => "{X")),
					" ",
					Text("e", TStyle(ruby => "boss")),
					" ",
					Text("fifteen", TStyle(ruby => "tBteB[")),
				], $s_normal),
				$ps_50c),
		], $bs_td),
		Block('R', [
			Paragraph(
				Text("", $s_normalv),
				$ps_50v),
			Paragraph(
				Text("@u񕨂́AiƊԊujv", $s_normalv),
				$ps_50v),
			Paragraph(
				Text(
					[
					Text("SVbNGothic", TStyle(font => $f_ghv)),
					" ",
					Text("Minchou", TStyle(font => $f_mtv)),
					" ",
					Text("SVbNHankaku", TStyle(font => $f_gv)),
					" ",
					Text("Hankaku", TStyle(font => $f_mv)),
					" ",
					Text("F", TStyle(shapestyle => $ss_red)),
					" ",
					Text("T", TStyle(withline => 1)),
					" ",
					Text("Tj", 
						TStyle(withline => 1, withlinestyle => $ss_dash)),
					" ",
					Text("_", TStyle(withdot => 1)),
					" ",
					Text("Ԋ|", TStyle(withbox => 'f', withboxstyle => 
						$ss_gray, shapestyle => $ss_white)),
					" ",
					Text("{Α", TStyle(slant => 1)),
					" ",
					Text("(1)", TStyle(vh => 1)),
					"c",
					" ",
					"Y", 
					Text("", TStyle(withnote => 
						Text(["i",Text("1", TStyle(vh => 1)),"j"], 
						TStyle(font => $f_ghv, fontsize => 12.5)))),
					" ",
					Text("ʒu", TStyle(ruby => "")),
					" ",
					Text("y", TStyle(ruby => "")),
					"",
					Text("x", TStyle(ruby => "oP[V")),
					"B",
					Text("e", TStyle(ruby => "{X")),
					" ",
					Text("e", TStyle(ruby => "boss")),
					" ",
					Text("fifteen", TStyle(ruby => "tBteB[")),
					],
					$s_normalv),
				$ps_50v),
			], $bs_td),
	], $bs_tr),
], $bs_frame)->show($p9, 20, 20, 'bl');

my $p10 = $doc->new_page;

my $img1 = $doc->new_image('frame.jpg', 20, 20, 25, 25);
my $shp1 = Shape->ellipse(0,0,50,25,'sf',0,$ss_red);
my $shp2 = Shape($ss_red)->box(0,0,25,25,"sr4")->
	obj(Text("`", TStyle(font => $f_m, fontsize => 21)), 2, 2, 'bl');

Block('V', [
	Paragraph(
		Text([Outline('}`Ɖ摜̃f'), '}`Ɖ摜̃f'], 
		$s_bigtitle), $ps_40),
	$sp_hr,
	10,
	Block('V', [
		Paragraph(
			Text([
				"eLXg̉摜", 
				$img1, 
				"AeLXg̐}`",
				Text($shp1, TStyle(objalign => 'm')),
				"AeLXg̐}`̃eLXg",
				$shp2,
			], $s_normal),
			$ps_50c),
	], $bs_td),
], $bs_frame)->show($p10, 20, 20, 'bl');

$doc->print('demo.pdf');
