/*
 * Decompiled with CFR 0.152.
 */
package dk.borderworlds;

import dk.borderworlds.MusicQueue;
import dk.borderworlds.MusicSearch;
import dk.borderworlds.MusicVolume;
import dk.borderworlds.SelectOnlyTableModel;
import dk.borderworlds.Song;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Random;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;

public class MusicList
implements ActionListener,
MouseListener {
    private JPanel panel;
    private MusicQueue queue;
    private JScrollPane scrollPane;
    private JButton enqueue;
    private JButton search;
    private Vector rowData;
    private Vector songs;
    private JTable table;
    private Vector volumes;
    private Random random;

    public MusicList(MusicQueue musicQueue, String[] stringArray) {
        this.queue = musicQueue;
        this.rowData = new Vector();
        this.songs = new Vector();
        Vector<String> vector = new Vector<String>();
        vector.add("Directory");
        vector.add("Filename");
        this.table = new JTable(new SelectOnlyTableModel(this.rowData, (Vector)vector));
        this.table.addMouseListener(this);
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setPreferredSize(new Dimension(200, 100));
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)new JLabel("Available music"), "North");
        this.panel.add((Component)this.scrollPane, "Center");
        JPanel jPanel = new JPanel(new GridLayout(1, 3));
        this.enqueue = new JButton("Enqueue");
        this.enqueue.addActionListener(this);
        this.search = new JButton("Search");
        this.search.addActionListener(this);
        jPanel.add(this.enqueue);
        jPanel.add(this.search);
        this.panel.add((Component)jPanel, "South");
        this.volumes = new Vector();
        for (int i = 0; i < stringArray.length; ++i) {
            this.volumes.add(new MusicVolume(stringArray[i], i + 1));
            ((MusicVolume)this.volumes.get(i)).rescan(this.songs);
        }
        this.syncRowData();
        this.random = new Random();
    }

    public Component getComponent() {
        return this.panel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        int[] nArray = this.table.getSelectedRows();
        if (string.equals("Enqueue")) {
            for (int i = 0; i < nArray.length; ++i) {
                this.queue.addSong((Song)this.songs.get(nArray[i]));
            }
        } else if (string.equals("Search")) {
            MusicSearch musicSearch = new MusicSearch(this.songs, this.queue);
        } else {
            System.err.println("huh? " + string);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.enqueue.doClick();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private void syncRowData() {
        this.rowData.removeAllElements();
        for (int i = 0; i < this.songs.size(); ++i) {
            Song song = (Song)this.songs.get(i);
            Vector<String> vector = new Vector<String>();
            vector.add(song.getDirectory());
            vector.add(song.getFilename());
            this.rowData.add(vector);
        }
        TableModel tableModel = this.table.getModel();
        TableModelEvent tableModelEvent = new TableModelEvent(tableModel);
        this.table.tableChanged(tableModelEvent);
    }

    public Song pickRandom() {
        if (this.songs.size() > 0) {
            return (Song)this.songs.get(this.random.nextInt(this.songs.size()));
        }
        return null;
    }

    public void rescan() {
        for (int i = 0; i < this.volumes.size(); ++i) {
            ((MusicVolume)this.volumes.get(i)).rescan(this.songs);
        }
        this.syncRowData();
    }

    public void rescanClean() {
        this.songs.removeAllElements();
        this.rescan();
    }

    public Vector getVolumes() {
        return this.volumes;
    }
}

