/*
 * Decompiled with CFR 0.152.
 */
package dk.borderworlds;

import dk.borderworlds.MusicList;
import dk.borderworlds.MusicVolume;
import dk.borderworlds.SelectOnlyTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;

public class MusicConfiguration
implements ActionListener {
    private JFrame confFrame = new JFrame("MusicControl configuration");
    private JTextField host;
    private JTextField newdir;
    private JComboBox deviceList;
    private Object selectedDevice;
    private MusicList ml;
    private Vector volumes;
    private Vector rowData;
    private JScrollPane scrollPane;
    private JTable table;
    private boolean volumesChanged;

    public MusicConfiguration() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.confFrame.getContentPane().add(jPanel);
        String[] stringArray = new String[]{"OSS", "STDOUT"};
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new JLabel("Audio device"), "North");
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        jPanel3.add(new JLabel("Device:"));
        this.deviceList = new JComboBox<String>(stringArray);
        this.selectedDevice = this.deviceList.getSelectedItem();
        jPanel3.add(this.deviceList);
        jPanel2.add((Component)jPanel3, "Center");
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)new JLabel("Music volumes"), "North");
        this.volumes = new Vector();
        this.rowData = new Vector();
        Vector<String> vector = new Vector<String>();
        vector.add("Directory");
        this.table = new JTable(new SelectOnlyTableModel(this.rowData, (Vector)vector));
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setPreferredSize(new Dimension(200, 100));
        jPanel4.add((Component)this.scrollPane, "Center");
        JPanel jPanel5 = new JPanel(new GridLayout(2, 2));
        JButton jButton = new JButton("Add");
        jButton.addActionListener(this);
        jPanel5.add(jButton);
        this.newdir = new JTextField("");
        jPanel5.add(this.newdir);
        JButton jButton2 = new JButton("Remove");
        jButton2.addActionListener(this);
        jPanel5.add(jButton2);
        jPanel4.add((Component)jPanel5, "South");
        jPanel.add((Component)jPanel4, "Center");
        this.volumesChanged = false;
        JPanel jPanel6 = new JPanel(new GridLayout(1, 2));
        JButton jButton3 = new JButton("Ok");
        jButton3.addActionListener(this);
        jPanel6.add(jButton3);
        JButton jButton4 = new JButton("Cancel");
        jButton4.addActionListener(this);
        jPanel6.add(jButton4);
        jPanel.add((Component)jPanel6, "South");
        this.confFrame.pack();
    }

    public String getDevice() {
        return (String)this.selectedDevice;
    }

    public void setDevice(String string) {
        this.selectedDevice = string;
    }

    public void setMusicList(MusicList musicList) {
        this.ml = musicList;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        String string = actionEvent.getActionCommand();
        if (string.equals("Configuration...")) {
            if (this.selectedDevice != null) {
                this.deviceList.setSelectedItem(this.selectedDevice);
            }
            this.volumes = this.ml.getVolumes();
            this.rowData.removeAllElements();
            for (int i = 0; i < this.volumes.size(); ++i) {
                MusicVolume musicVolume = (MusicVolume)this.volumes.get(i);
                Vector<String> vector = new Vector<String>();
                vector.add(musicVolume.getDirectory());
                this.rowData.add(vector);
            }
            TableModel tableModel = this.table.getModel();
            TableModelEvent tableModelEvent = new TableModelEvent(tableModel);
            this.table.tableChanged(tableModelEvent);
            this.volumesChanged = false;
            this.confFrame.setVisible(true);
        } else if (string.equals("Ok")) {
            this.selectedDevice = this.deviceList.getSelectedItem();
            if (this.volumesChanged) {
                this.volumes.removeAllElements();
                for (int i = 0; i < this.rowData.size(); ++i) {
                    Vector vector = (Vector)this.rowData.get(i);
                    this.volumes.add(new MusicVolume((String)vector.get(0), i + 1));
                }
                this.ml.rescanClean();
            }
            this.confFrame.setVisible(false);
        } else if (string.equals("Cancel")) {
            this.confFrame.setVisible(false);
        } else if (string.equals("Add")) {
            File file = new File(this.newdir.getText());
            if (file.isDirectory()) {
                Vector<String> vector = new Vector<String>();
                vector.add(this.newdir.getText());
                this.rowData.add(vector);
                TableModel tableModel = this.table.getModel();
                TableModelEvent tableModelEvent = new TableModelEvent(tableModel);
                this.table.tableChanged(tableModelEvent);
                this.volumesChanged = true;
            }
            this.newdir.setText("");
        } else if (string.equals("Remove") && (n = this.table.getSelectedRow()) != -1) {
            this.rowData.removeElementAt(n);
            TableModel tableModel = this.table.getModel();
            TableModelEvent tableModelEvent = new TableModelEvent(tableModel, n, n, -1, -1);
            this.table.tableChanged(tableModelEvent);
            this.volumesChanged = true;
        }
    }
}

