#include <iostream>
#include <iomanip>

#include "global.h"
#include "OSD.h"
#include "RaceExtras.h"
#include "Carrera.h"
#include "Particulas.h"
#include "Menu.h"
#include "MyFont.h"
#include "Loading.h"
#include "Confirm.h"
#include "Jukebox.h"
#include "SelectionWheel.h"
#include "Shader.h"
#include "ChampionshipData.h"
#include "Config.h"
#include "Profile.h"
#include "MyRenderWindow.h"
#include "SlideShow.h"
#include "version.h"
#include <string>
#include "Circuito.h"
#include "LangSelection.h"
#include "StyleOsd.h"
#include "Intro.h"
#include "text_hidden.h"
#include "HiddenDriver.h"
#include "TextViewer.h"
using namespace std;

int main(int argc, char *argv[]) {
	
	if (argc==2 && string(argv[1])=="--version") {
		cout<<"MotoGT v"<<VERSION<<" (by Pablo Novara)"<<endl;
		return 0;
	} else if (argc>1 && string(argv[1])=="--build") {
		srand(time(NULL));
		config = new Config();
		view=new View();
		loading = new Loading();
		App=new MyRenderWindow();
		loading->Draw();
		font = new MyFont();
		confirm = new Confirm();
		black=new Black();
		music = new Jukebox(); // si no pongo esto el destructor de circuito explota al cerrar los sonidos
		data = new Data(); profile=NULL; osd=NULL;
		for (int i=0;i<data->track_count;i++) {
			loading->Draw();
			if (argc==2 || string(argv[2])=="low") {
				global_scale=2;
				cout<<"Building low-res track "<<i<<"..."<<endl;
				Circuito *circuito = new Circuito(i);
				delete circuito;
			}
			if (argc==2 || string(argv[2])=="high") {
				global_scale=1;
				cout<<"Building high-res track "<<i<<"..."<<endl;
				circuito = new Circuito(i);
				delete circuito;
			}
		}
		return 0;
	} else if (argc==2 && string(argv[1])=="--help") {
		cout<<"Valid arguments: "<<endl;
		cout<<"   --help     show this text"<<endl;
		cout<<"   --version  show game version"<<endl;
		cout<<"   --build    build all tracks' images"<<endl;
		cout<<"   --nosound  run the game without sound"<<endl;
		return 0;
	}

#ifdef __WIN32__
	if (getenv("HOMEDRIVE")) {
		home_dir=getenv("HOMEDRIVE");
		home_dir+=getenv("HOMEPATH");
	}
#else
	if (getenv("HOME")) {
		home_dir=getenv("HOME");
	}
#endif
	if (home_dir.size()&&home_dir[home_dir.size()]!='/'&&home_dir[home_dir.size()]!='\\') home_dir+=SLASH;
	home_dir+=".motogt"; system((string("mkdir \"")+home_dir+"\"").c_str()); home_dir+=SLASH;
	
	config = new Config();
	if (argc==2 && string(argv[1])=="--nosound") {
		config->sound_on=config->music_on=false;
	} 
	
	
	view=new View();
	loading = new Loading();
	App=new MyRenderWindow();

	if (!config->know_lang) {
		LangSelection ls;
		ls.Run();
		config->changed=true;
		config->Save();
	}
	
	if (config->version!=VERSION) {
		font = new MyFont();
		music=NULL;
		TextViewer *text_viewer = new TextViewer("data/menu/help.png",config->spanish?"Bienvenido a MotoGT beta":"Welcome to MotoGT beta",config->spanish?text_es_incomplete:text_en_incomplete,false);
		text_viewer->Show(); delete text_viewer;
		config->Save(true);
	} else {
		font=NULL;
	}
	
	
	Intro *intro=new Intro();
	intro->Run();
	
	loading->Draw();
	
	profile=NULL;
	championship_data=NULL;
	racers=NULL;
	
	black=new Black();
	data = new Data();
	music = new Jukebox();
	confirm = new Confirm();
	race_extras = new RaceExtras();
	humo = new ParticulaExp("data/particle/humo.png",config->particles_low);
	tierra = new ParticulaExp("data/particle/tierra.png",config->particles_low);
	marca = new ParticulaFix("data/particle/marca.png",config->particles_hi);
	chispa = new ParticulaMove("data/particle/spark.png",config->particles_low);
	lluvia = new ParticulaRain("data/particle/rain.png",config->particles_hi);
	hidden = new HiddenDriver; 
	style_osd = new StyleOsd();
	if (config->shaders_on && sf::PostFX::CanUsePostFX()) shaders=new Shaders();
	sel_wheel = new SelectionWheel();
	
	osd = new OSD();
	
	if (!font) font = new MyFont();

	delete intro;
	
	srand(time(NULL));
	
//	for (int i=0;i<8;i++)
//	int i=4;
//	hidden->Run(th_tip_en[i],tips_imgs[i].fname,tips_imgs[i].x,tips_imgs[i].y);
//	return 0;
	Menu *menu = new Menu();
	menu->Main();
	delete menu;
	
	delete sel_wheel;
	delete config;
	delete data;
	delete confirm;
	delete race_extras;
	delete osd;
	delete tierra;
	delete marca;
	delete humo;
	delete music;
	if (profile) delete profile;
}
