#ifndef GLOBAL_H
#define GLOBAL_H

#include <SFML/Graphics.hpp>
#include <SFML/Audio.hpp>
#include <iostream>
#include <fstream>
using namespace std;
using namespace sf;
#define real float
#include "MyRenderWindow.h"

#ifdef DEBUG
#define CERR(a) cerr<<a<<endl;
#else
#define CERR(a)
#endif

#ifdef __WIN32__
#define SLASH "\\"
#else
#define SLASH "/"
#endif

#define load_wh(pref,file,cw,ch) \
	pref##image.LoadFromFile(file); \
	pref##w=pref##image.GetWidth()/cw; pref##h=pref##image.GetHeight()/ch; \
	pref##sprite.SetImage(pref##image);\
	pref##sprite.SetCenter(pref##w/2,pref##h/2);\
	pref##sprite.SetScale(global_scale,global_scale);\
	pref##sprite.SetSubRect(IntRect(0,0,pref##w,pref##h));

#define declare_wh(pref) \
	Image pref##image;\
	Sprite pref##sprite;\
	int pref##w,pref##h;

#define declare_fade \
	Image fimage; Sprite fsprite; void Fade(bool in)

#define load_fade \
	fimage.LoadFromFile("data/menu/black.png"); fsprite.SetImage(fimage); \
	fsprite.SetCenter(1,1); fsprite.SetPosition(0,0); \
	fsprite.SetScale(screen_w/10+20,screen_h/10+20)

#define implement_fade(classname) \
	void classname::Fade(bool in) {\
		if (!config->extra_fx) return;\
		if (in) { int alpha=255;\
			while(alpha>=0) {\
if (config->shaders_on) { FloatRect rect(0+alpha*alpha/256,0+alpha*alpha/512,screen_w-alpha*alpha/256,screen_h-alpha*alpha/512); view->SetFromRect(rect); App->SetView(*view); }\
				Draw(); fsprite.SetColor(Color(255,255,255,alpha));\
				App->Draw(fsprite); App->TimedDisplay();	alpha-=15;\
		} } else { int alpha=0; while(alpha<=255) {\
				if (config->shaders_on) { FloatRect rect(0+alpha*alpha/256,0+alpha*alpha/512,screen_w-alpha*alpha/256,screen_h-alpha*alpha/512); view->SetFromRect(rect); App->SetView(*view); }\
				Draw();	fsprite.SetColor(Color(255,255,255,alpha));\
				App->Draw(fsprite); App->TimedDisplay();	alpha+=20;\
			} } }

#define char_speed 1

#define profile_max 8
#define track_max 20
#define bike_max 20

#define bike_upgrade_max 30

extern bool head_label;
extern bool osd_on;
extern bool style_osd_on;
extern bool show_map;
extern bool show_names;

extern MyRenderWindow *App;
extern View *view;
#define screen_w 800
#define screen_h 600
extern int race_screen_h;
extern int race_screen_w;
extern int screen_d;
extern int fixed_zoom;

extern Key::Code last_key;

extern string home_dir;

extern int global_scale;
string fix_image_file(string fname);

extern bool night_mode;
extern bool rain_mode;

extern Color mult_color;

#include "Data.h"
#endif
