#ifndef TRACKSELECTION_H
#define TRACKSELECTION_H
#include "global.h"
#include "Drawer.h"

enum mi_track { 
	mit_fastlap, mit_fastlap_name, mit_fastlap_value, mit_personallap, mit_personallap_value, mit_pts, mit_pts_value,
	mit_name, mit_name_value, mit_laps, mit_laps_value, mit_level, mit_level_value, 
	mit_race, mit_count };

class TrackSelection:public Drawer {
public:
	int num_opts;
	
	int tostart;
	
	declare_fade;
	
	declare_wh(b);
	declare_wh(r);
	
	Image *itracks;
	Sprite *stracks;
	static int target_track;
	static real current_track;
	
	declare_wh(ws);
	declare_wh(wl);
	declare_wh(wn);
	declare_wh(wr);
		
	string items[mit_count];
	unsigned int charsdone[mit_count];
	int pos[mit_count][2];
	int sel_level[mit_count];
	bool selected[mit_count];
	bool visible[mit_count];
	int selection;
	
	static int laps;
	static int level;
	
	TrackSelection();
	void Draw();
	bool Select(int anumopts);
	void Reset();
	bool SelOk();
	void SelMove(bool up);
	void SelChange(bool right);
	void LoadTrackData();
	void Zoom();
	~TrackSelection();
};

#endif

