#ifndef PARTICULAS_H
#define PARTICULAS_H
#include "global.h"
#include <string>
using namespace std;

struct ParticulaExp {
	real *x,*y,*s;
	int max;
	int n0,n1;
	bool last;
	Color mycolor;
	declare_wh(p);
	ParticulaExp(string file, int amax);
	string fname; 
	void Reload();
	void New(real ax, real ay);
	void Update();
	void Resize(int amax);
	void Reset();
	~ParticulaExp();
};

struct ParticulaRain {
	int *rnd;
	int max, n, mmax;
	declare_wh(p);
	ParticulaRain(string file, int amax);
	int ox,oy;
	string fname; 
	void Reset();
	void Reload();
	void Update(int cam_x, int cam_y, real cam_z);
	void Resize(int amax);
	~ParticulaRain();
};

struct ParticulaFix {
	int max;
	real *x,*y,*a;
	int n0,n1,nc;
	declare_wh(p);
	string fname; 
	void Reload();
	ParticulaFix(string file, int amax);
	void New(real ax, real ay, real aa);
	void Update();
	void Resize(int amax);
	void Reset();
	~ParticulaFix();
};

struct ParticulaMove {
	int max;
	real *x,*y,*dx,*dy;
	int *s;
	int n0,n1,nc;
	declare_wh(p);
	string fname; 
	void Reload();
	ParticulaMove(string file, int amax);
	void New(real ax, real ay, real av);
	void Update();
	void Resize(int amax);
	void Reset();
	~ParticulaMove();
};

extern ParticulaExp *humo, *tierra;
extern ParticulaMove *chispa;
extern ParticulaFix *marca;
extern ParticulaRain *lluvia;


#endif

