#include "OSD.h"
#include "global.h"
#include "Carrera.h"
#include "Moto.h"
#include "MyFont.h"
#include "Config.h"

OSD *osd;

OSD::OSD() {
	Reload();
}

void OSD::Reload() {
	load_wh(t,fix_image_file("data/osd/btime.png"),1,1);
	tsprite.SetCenter(0,0);
//	timage.LoadFromFile(fix_image_file("data/osd/btime.png"));
//	tsprite.SetImage(timage);
//	tw=timage.GetWidth();
//	th=timage.GetHeight();
	
	load_wh(au,fix_image_file("data/misc/aid_up.png"),1,1);
	load_wh(ad,fix_image_file("data/misc/aid_down.png"),1,1);
	load_wh(ar,fix_image_file("data/misc/aid_right.png"),1,1);
	load_wh(al,fix_image_file("data/misc/aid_left.png"),1,1);
	load_wh(mb,fix_image_file("data/misc/bike4map.png"),1,1);
	load_wh(s0,fix_image_file("data/osd/speed0.png"),1,1);
	load_wh(s1,fix_image_file("data/osd/speed1.png"),1,1);
	load_wh(s2,fix_image_file("data/osd/speed2.png"),1,1);
	s1sprite.SetCenter(30/global_scale,5/global_scale);
	s2sprite.SetCenter(25/global_scale,5/global_scale);
	
	load_wh(b,fix_image_file("data/osd/blap.png"),1,1);
//	bimage.LoadFromFile(fix_image_file("data/osd/blap.png"));
//	bsprite.SetImage(bimage);
	bsprite.SetCenter(0,bimage.GetHeight());
}

void OSD::Reset() {
	if (config->extra_fx) {
		s0sprite.SetColor(Color(255,255,255,200));
		s1sprite.SetColor(Color(255,255,255,200));
		s2sprite.SetColor(Color(255,255,255,200));
		tsprite.SetColor(Color(255,255,255,150));
		bsprite.SetColor(Color(255,255,255,150));
	} else {
		s0sprite.SetColor(Color(255,255,255,255));
		s1sprite.SetColor(Color(255,255,255,255));
		s2sprite.SetColor(Color(255,255,255,255));
		tsprite.SetColor(Color(255,255,255,255));
		bsprite.SetColor(Color(255,255,255,255));
	}
}

void OSD::Draw(real x, real y, real z) {

	s0sprite.SetScale(z*global_scale,z*global_scale);
	s1sprite.SetScale(z*global_scale,z*global_scale);
	s2sprite.SetScale(z*global_scale,z*global_scale);
	s0sprite.SetPosition(x+z*(race_screen_w-s0w*global_scale)/2,y+z*(race_screen_h-s0h*global_scale)/2);
	App->Draw(s0sprite);
	
	char csaux[4];
	csaux[0]='1'+moto_target->cur_gear; csaux[1]='\0';
	font->RenderSmall(x+z*(race_screen_w-s0w*global_scale+45)/2,y+z*(race_screen_h-s0h*global_scale-16)/2,z/3.1,csaux);
	int v=int(moto_target->velocidad*5);
	csaux[0]='0'+v/100; csaux[1]='0'+(v/10)%10; csaux[2]='0'+v%10; csaux[3]='\0';
	font->RenderSmall(x+z*(race_screen_w-s0w*global_scale-110)/2,y+z*(race_screen_h-s0h*global_scale-3)/2,z/3.2,csaux);
	
	
	s1sprite.SetRotation(-3.7*moto_target->rangle);
	s1sprite.SetPosition(x+z*(race_screen_w-s0w*global_scale+86)/2,y+z*(race_screen_h-s0h*global_scale)/2);
	App->Draw(s1sprite);
	s2sprite.SetRotation(-3.7*moto_target->vangle);
	s2sprite.SetPosition(x+z*(race_screen_w-s0w*global_scale-84)/2,y+z*(race_screen_h-s0h*global_scale+15)/2);
	App->Draw(s2sprite);

	bsprite.SetScale(z*global_scale,z*global_scale);
	bsprite.SetPosition(x-z*(race_screen_w/2-5),y+z*(race_screen_h/2-7));
	App->Draw(bsprite);
	font->RenderSmall(x-z*(race_screen_w/2-14),y+z*(race_screen_h/2-50),z/2.25,config->spanish?"Vuelta: ":"Lap: ",moto_target->lap,"/",carrera->laps);
	
	carrera->Sort();
	if (!carrera->qualy_mode) {
		for (int i=0;i<carrera->num_racers;i++) {
			if (head_label) {
				if (show_names)
					font->RenderSmall(motos[i]->x,motos[i]->y,.35*z,motos[i]->name.c_str());
				else
					font->RenderSmall(motos[i]->x,motos[i]->y,.5*z,i+1);
			}
		}
	}
	
	font->RenderSmall(x-z*(race_screen_w/2-14),y+z*(race_screen_h/2-18),z/2.25,config->spanish?"Posicion: ":"Position:",moto_target->pos,"/",carrera->num_racers);

	tsprite.FlipX(false);
	tsprite.SetScale(z*global_scale,z*global_scale);
	tsprite.SetPosition(x-z*(race_screen_w/2),y-z*(race_screen_h/2));
	App->Draw(tsprite);
	if (carrera->qualy_mode) {
		real tl = (carrera->timer-moto_target->clock_lap)*TIMER_CTE;
		if (moto_target->lap>1 && tl<5)
			font->RenderTime(x-z*(race_screen_w/2-14),y-z*(race_screen_h/2-30),z/2.25,moto_target->time_last_lap);
		else
			font->RenderTime(x-z*(race_screen_w/2-14),y-z*(race_screen_h/2-30),z/2.25,tl);
		if (racers[moto_target->pos-1].best_lap>0)
			font->RenderTime(x-z*(race_screen_w/2-14),y-z*(race_screen_h/2-60),z/2.25,racers[moto_target->pos-1].best_lap);
	} else {
		if (moto_target->im_done)
			font->RenderTime(x-z*(race_screen_w/2-14),y-z*(race_screen_h/2-30),z/2.25,moto_target->time_total);
		else
			font->RenderTime(x-z*(race_screen_w/2-14),y-z*(race_screen_h/2-30),z/2.25,(carrera->timer-moto_target->clock_total)*TIMER_CTE);
		real tl = (carrera->timer-moto_target->clock_lap)*TIMER_CTE;
		if (moto_target->lap>1 && tl<5)
			font->RenderTime(x-z*(race_screen_w/2-14),y-z*(race_screen_h/2-60),z/2.25,moto_target->time_last_lap);
		else
			font->RenderTime(x-z*(race_screen_w/2-14),y-z*(race_screen_h/2-60),z/2.25,tl);
	}
	
	if (show_map) {
		int x0=circuito->mm_x0;
		int y0=circuito->mm_y0;
		int s=circuito->scale_mini;
		circuito->smini.SetPosition(x+z*(race_screen_w/2-x0),y+z*(-race_screen_h/2+y0));
		circuito->smini.SetScale(z*global_scale,z*global_scale);
		App->Draw(circuito->smini);
		mbsprite.SetScale(z*global_scale,z*global_scale);
		if (carrera->qualy_mode) {
			mbsprite.SetPosition(x+z*(race_screen_w/2+moto_target->x/s-x0),y+z*(-race_screen_h/2+moto_target->y/s+y0));
			mbsprite.SetColor(moto_target->minicolor);
			App->Draw(mbsprite);
		} else {
			for (int i=0;i<carrera->num_racers;i++) {
//				if ((carrera->timer/2)%2 && motos[i]==moto_target) continue;
				mbsprite.SetPosition(x+z*(race_screen_w/2+motos[i]->x/s-x0),y+z*(-race_screen_h/2+motos[i]->y/s+y0));
				mbsprite.SetColor(motos[i]->minicolor);
				App->Draw(mbsprite);
//				mbsprite.SetPosition(motos[i]->target_x,motos[i]->target_y);
//				App->Draw(mbsprite);
			}
		}
	} else {
		tsprite.FlipX(true);
		tsprite.SetPosition(x+z*(race_screen_w/2-tw*global_scale),y-z*(race_screen_h/2));
		App->Draw(tsprite);
		if (carrera->qualy_mode) {
//			real tl = (carrera->timer-moto_target->clock_lap)*TIMER_CTE;
//			font->RenderTime(x-z*(race_screen_w/2-14),y-z*(race_screen_h/2-30),z/2.25,tl);
//			if (racers[moto_target->pos-1].best_lap>0)
//				font->RenderTime(x-z*(race_screen_w/2-14),y-z*(race_screen_h/2-60),z/2.25,racers[moto_target->pos-1].best_lap);
			
			if (moto_target->pos>1) {
				font->RenderTime(x+z*(race_screen_w/2-80),y-z*(race_screen_h/2-30),z/2.25,racers[0].best_lap);
				font->RenderTime(x+z*(race_screen_w/2-80),y-z*(race_screen_h/2-60),z/2.25,racers[moto_target->pos-2].best_lap);
			}
			
		} else {
			mbsprite.SetScale(z*global_scale,z*global_scale);
			if (moto_target->pos>1) {
				int in=moto_target->pos-2;
				mbsprite.SetPosition(x+z*(+race_screen_w/2-10),y+z*(-race_screen_h/2+23));
				mbsprite.SetColor(motos[in]->minicolor);
				App->Draw(mbsprite);
				if (show_names) {
					font->RenderSmall(x+z*(race_screen_w/2-13)-font->Ancho(motos[in]->name.c_str(),z/2.75),y-z*(race_screen_h/2-30),z/2.75,motos[in]->name.c_str());
				} else {
					int lapd=motos[in]->lap-moto_target->lap;
					if (motos[in]->check_next<moto_target->check_next) lapd--;
					else if (motos[in]->check_next==moto_target->check_next
						&& motos[in]->check_dist>moto_target->check_dist) lapd--;
					if (lapd>0)
						font->RenderSmall(x+z*(race_screen_w/2-80),y-z*(race_screen_h/2-30),z/2.25,lapd,"L");
					else {
						real diff = moto_target->times_last_partials[moto_target->check_next]-motos[in]->times_last_partials[moto_target->check_next];
						if (diff>0)	font->RenderSmall(x+z*(race_screen_w/2-80),y-z*(race_screen_h/2-30),z/2.25,diff);
					}
				} 
			}
			if (moto_target->pos<carrera->num_racers-1) {
				int ip=moto_target->pos;
				mbsprite.SetPosition(x+z*(+race_screen_w/2-10),y+z*(-race_screen_h/2+53));
				mbsprite.SetColor(motos[ip]->minicolor);
				App->Draw(mbsprite);
				if (show_names) {
					font->RenderSmall(x+z*(race_screen_w/2-13)-font->Ancho(motos[ip]->name.c_str(),z/2.75),y-z*(race_screen_h/2-60),z/2.75,motos[ip]->name.c_str());
				} else {
					int lapd=moto_target->lap-motos[ip]->lap;
					if (motos[ip]->check_next>moto_target->check_next) lapd--;
					else if (motos[ip]->check_next==moto_target->check_next
						&& motos[ip]->check_dist<moto_target->check_dist) lapd--;
					if (lapd>0)
						font->RenderSmall(x+z*(race_screen_w/2-80),y-z*(race_screen_h/2-60),z/2.25,lapd,"L");
					else {
						real diff = motos[ip]->times_last_partials[motos[ip]->check_next]-moto_target->times_last_partials[motos[ip]->check_next];
						if (diff>0)	font->RenderSmall(x+z*(race_screen_w/2-80),y-z*(race_screen_h/2-60),z/2.25,diff);
					}
				}
			}
		}
	}
	
//	moto_target->Control(true);
//	if (moto_target->key_accel) {
//		ausprite.SetPosition(x,y+z*(race_screen_h/3-25));
//		ausprite.SetScale(z,z);
//		App->Draw(ausprite);
//	}
//	if (moto_target->key_brake) {
//		adsprite.SetPosition(x,y+z*(race_screen_h/3+25));
//		adsprite.SetScale(z,z);
//		App->Draw(adsprite);
//	}
//	if (moto_target->key_right) {
//		arsprite.SetPosition(x+z*50,y+z*race_screen_h/3);
//		arsprite.SetScale(z,z);
//		App->Draw(arsprite);
//	}
//	if (moto_target->key_left) {
//		alsprite.SetPosition(x-z*50,y+z*race_screen_h/3);
//		alsprite.SetScale(z,z);
//		App->Draw(alsprite);
//	}
}
