#include "Menu.h"
#include "Carrera.h"
#include "MyFont.h"
#include "Jukebox.h"
#include "Confirm.h"
#include "Loading.h"
#include "EnterName.h"
#include "SelectionWheel.h"
#include "TrackSelection.h"
#include "RaceResults.h"
#include "RaceExtras.h"
#include "Particulas.h"
#include <iomanip>
#include "TextViewer.h"
#include "Shader.h"
#include <sstream>
#include "Circuito.h"
#include "RaceMenu.h"
#include "version.h"
#include "BikeSelection.h"
#include "ChampionshipMenu.h"
#include "Config.h"
#include "Profile.h"
#include "OSD.h"
#include "Records.h"
#include "HiddenDriver.h"
using namespace std;

int Menu::my_global_scale;
int Menu::mx;
int Menu::my;
int Menu::m1w;
int Menu::m1h;

Menu::Menu() {
	stringstream ss;
	ss<<VERSION; sversion=ss.str();
	load_fade; la=0;
	my_global_scale=0; 
	Reload();
	Reset();
	Fade(true);
}

void Menu::Reload() {
	if (my_global_scale==global_scale) return;
	my_global_scale=global_scale;
	lsprite.SetImage(loading->image);
	lw=loading->image.GetWidth(); lh=loading->image.GetHeight();
	lsprite.SetCenter(lw/2,lh/2); lsprite.SetSubRect(IntRect(0,0,lw,lh));
	load_wh(m1,fix_image_file("data/menu/menu1.png"),1,1);
	load_wh(m2,fix_image_file("data/menu/menu2.png"),1,1);
	load_wh(s,fix_image_file("data/menu/sel.png"),1,4); 
	load_wh(b,fix_image_file("data/menu/back.png"),1,1);
	load_wh(bl,fix_image_file("data/menu/baloon.png"),1,1);
	font->Reload(); race_extras->Reload(); sel_wheel->Reload(); osd->Reload();
	humo->Reload(); marca->Reload(); chispa->Reload(); tierra->Reload(); lluvia->Reload();
	loading->Reload();
	
	if (config->extra_fx) {
		m1sprite.SetColor(Color(255,255,255,200));
		m2sprite.SetColor(Color(255,255,255,200));
	} else {
		m1sprite.SetColor(Color(255,255,255,255));
		m2sprite.SetColor(Color(255,255,255,255));
	}
}

void Menu::SetMenu() {
	
	items[mim_quickrace].Set(0,0,config->spanish?"CORRER YA!":"QUICKRACE",false,false,false,
		config->spanish?"comenzar a correr ya en":"start racing right now",
		config->spanish?"un circuito aleatorio con":"on a random track with",
		config->spanish?"una motocicleta aleatoria":"a random bike.");
	items[mim_career].Set(0,1,config->spanish?"PERFILES":"CAREER",false,false,false,
		config->spanish?"intenta ganar carreras para":"win races and championships",
		config->spanish?"mejorar tu motocicleta y":"to improve your bike and",
		config->spanish?"desbloquear opciones ocultas":"unlock new features.");
	items[mim_options].Set(0,2,config->spanish?"OPCIONES":"OPTIONS",false,false,false,
		config->spanish?"configura los graficos, el":"tune graphics, sound and music,",
		config->spanish?"sonido y la musica, los":"define your preferred controls,",
		config->spanish?"controles o el idioma":"or change the game language");
	items[mim_records].Set(0,3,config->spanish?"MEJORES":"TOP RIDERS",false,false,false,
		config->spanish?"ver los puntajes mas altos":"see the name of the top scorers",
		config->spanish?"del modo campeonato y los":"in championship mode and the",
		config->spanish?"mejores tiempos de vuelta":"fastest lap for each track");
	items[mim_exit].Set(0,4,config->spanish?"SALIR":"EXIT",true,false,false,
		config->spanish?"deja de perder el tiempo":"stop loosing your time, get",
		config->spanish?"y abandona el juego para":"out of this game, and do",
		config->spanish?"hacer algo mas util... o no?":"something usefull... or not?");
	
	items[mim_practice].Set(1,0,config->spanish?"PRACTICA":"PRACTICE",false,false,false,
		config->spanish?"elige un circuito y entrena":"select a track and test your",
		config->spanish?"tus habilidades en una sesion":"bike and your skills in a private",
		config->spanish?"privada, sin oponentes":"session, without opponents around");
	items[mim_single_race].Set(1,1,config->spanish?"CARRERA":"SINGLE RACE",false,false,false,
		config->spanish?"participa de un fin de semana de carrera":"participate in a complete race",
		config->spanish?"completo (con practicas y clasificacion)":"weekend (practice, qualify and",
		config->spanish?"en el circuito que escojas":"race) in any track you choose");
	items[mim_championship].Set(1,2,config->spanish?"CAMPEONATO":"CHAMPIONSHIP",false,false,false,
		config->spanish?"corre en todos los circuitos y suma":"race on all tracks and get more",
		config->spanish?"mas puntos que los demas para ser":"points than any other racer to",
		config->spanish?"el nuevo campeon":"raice the cup an became a master");
	items[mim_setup_bike].Set(1,3,config->spanish?"CONF. MOTO":"BIKE SETUP",false,false,false,
		config->spanish?"invierte tus creditos de experiencia":"use the experience points that",
		config->spanish?"en tu motocicleta y transformala":"you earned in races to improve",
		config->spanish?"en las mas rapida de la categoria":"your bike and became faster");
	items[mim_change_profile].Set(1,4,config->spanish?"OTRO PERFIL":"CHANGE PROFILE",false,false,false,
		config->spanish?"si en el titulo de este menu no":"if the title of this menu is",
		config->spanish?"dice tu nombre usa esta opcion para":"not your name, use this option",
		config->spanish?"volver a la lista de perfiles":"to return to profile selection");
	items[mim_help_career].Set(1,5,config->spanish?"AYUDA":"HELP!",true,false,false,
		config->spanish?"mas ayuda acerca del modo":" ",
		config->spanish?"carrera profesional":"more help about career mode",
		config->spanish?" ":" ");
	
	
	items[mim_opt_controls].Set(1,0,config->spanish?"CONTROLES":"CONTROLS",false,false,false,
		"assign custom keys or enable","joystick buttons and movements","to control the bike");
	items[mim_opt_graphics].Set(1,1,config->spanish?"GRAFICOS":"GRAPHICS",false,false,false,
		"tune graphic detail to fit your system"," change screen resolution or toggle","between fullscreen and windowed mode"); 
	items[mim_opt_sound].Set(1,2,config->spanish?"SONIDO":"SOUND",false,false,false,
		"enable or disable music and","sound effects, and change","volume levels");
	items[mim_opt_language].Set(1,3,config->spanish?"IDIOMA":"LANGUAGE",false,true,false,
		"toggle between","spanish and english","translations");
	items[mim_opt_language_value].Set(1,4,"",false,false,true);
	items[mim_opt_about].Set(1,5,config->spanish?"ACERCA DE...":"ABOUT...",true,false,false,
		"read some random stuff about","the game, its development and","find how to contact the author");
	items[mim_controls_assign_keys].Set(1,0,config->spanish?"Conf. Teclas":"Assign Keys",false,false,false,
		"change wich key should be assigned","to each control for your bike","(acceleration, braking, and turning)"); 
	items[mim_controls_use_joystick].Set(1,1,config->spanish?"Usar Joystick":"Use Joystick",false,true,false,
		"choose wich joystick would you","like to use to control the","bike, or disable joystick usage");
	items[mim_controls_use_joystick_value].Set(1,2,"",false,false,true);
	items[mim_controls_assign_joystick].Set(1,3,config->spanish?"Conf. Joystick":"Setup Joystick",true,false,false,
		"define wich joystick buttons or","axis movements should be assigned","to each bike control");
	items[mim_graphics_particles].Set(2,0,config->spanish?"Efectos":"Graphics FX",false,true,false,
		"fx includes effects such as skid-marks,","dust and smoke clouds, rain drops,"," sparks, shader effects...");
	items[mim_graphics_particles_value].Set(2,1,"",false,false,true);
	items[mim_graphics_textures].Set(2,2,config->spanish?"Texturas":"Textures",false,true,false,
		"if your graphic card is very old or isn't","properly configured in your system","choose low, else choose normal"); 
	items[mim_graphics_textures_value].Set(2,3,"",false,false,true);
	items[mim_graphics_resolution].Set(2,4,config->spanish?"Modo Video":"Video Mode",false,true,false,
		"choose the resolution for fullscreen","mode or the window size for windowed","mode that you want for the game"); 
	items[mim_graphics_resolution_value].Set(2,5,"",false,false,true);
	items[mim_graphics_fullscreen].Set(2,6,config->spanish?"Modo Ventana":"Window Mode",true,true,false,
		"toggle between windowed mode and","fullscreen mode, changes will","apply when you return to main menu"); 
	items[mim_graphics_fullscreen_value].Set(2,7,"",false,false,true);
	items[mim_sound_fx_on].Set(2,0,config->spanish?"Sonido":"Sound FX",false,true,false,
		"enable or disable sound effects","such as bike engine, crowd,","and menu selection sound"); 
	items[mim_sound_fx_on_value].Set(2,1,"",false,false,true); 
	items[mim_sound_fx_vol].Set(2,2,config->spanish?"Vol. Sonido":"FX Volume",false,true,false,
		"setup the sound volume for effects","such as bike engine, crowd,","and menu selection sound");
	items[mim_sound_fx_vol_value].Set(2,3,"",false,false,true);
	items[mim_sound_music_on].Set(2,4,config->spanish?"Musica":"Music",false,true,false,
		"enable or disable","the background music that you can listen","in menues, while not racing");
	items[mim_sound_music_on_value].Set(2,5,"",false,false,true);
	items[mim_sound_music_vol].Set(2,6,config->spanish?"Vol. Musica":"Music Volume",true,true,false,
		"setup the volume for","the background music that you can listen","in menues, while not racing"); 
	items[mim_sound_music_vol_value].Set(2,7,"",false,false,true);
	
//	help[mim_sound][0]="turn on and off music and/or";
//	help[mim_sound][1]="sound effects like the bike's";
//	help[mim_sound][2]=" engine, crashes and people";
//	
//	help[mim_particles][0]="choose a level for graphics fx";
//	help[mim_particles][1]="  like dust, sparks, shadows,";
//	help[mim_particles][2]="reflexions and special shaders";
//	
//	help[mim_textures][0]="   if you have had problems to see";
//	help[mim_textures][1]="tracks or bikes in an old machines,";
//	help[mim_textures][2]="choose low textures and try again";
//	
//	help[mim_mode][0]="toggle fullscreen/windowed mode";
//	help[mim_mode][1]="  and change the window size or";
//	help[mim_mode][2]="          screen resolution";
	
	for (int i=0;i<profile_max;i++)
		items[mim_count+i].Set(2,i,
		(i<data->profile_count)?data->profile_names[i]:""
		,false,false,false,
		"select <new profile> if it's your first","time. if it's not, choose your name to","continue, or press delete to remove it");
	
	ReloadOptions();
}

void Menu::Reset(bool all) {
	
	if (config->music_on) music->PlayMusic();
	
	FloatRect rect(0,0,screen_w,screen_h);
	view->SetFromRect(rect);
	App->SetView(*view);
	
	if (all) {
		
		second_x=850; second_y=120;
		show_help=false;
		in_options=false;
		last_move_time=0;
		prev_menu=prev_quit;
		second_w=0; show_second=false;
		
		bsprite.SetPosition(screen_w/2,screen_h/2);
		m1sprite.SetPosition(mx=screen_w/4,my=3*screen_h/4);
		main_h=0.05;
		main_done=false;
		
		SetMenu();
//		ReloadOptions();
		
		selection=mim_career;
		lsprite.SetPosition(screen_w/4,screen_h/6);
	}
}

void Menu::Main() {
	while(App->IsOpened()) {

		sf::Event event;
		while(App->GetEvent(event)) {
			if(event.Type == event.Closed) {
				music->StopMusic(); Fade(false); loading->Draw(); App->Close();
			} if(App->GetInput().IsKeyDown(sf::Key::Escape) && last_key!=sf::Key::Escape) {
				if (config->sound_on) music->snd_selcancel.Play();
				last_key=sf::Key::Escape; SelCancel();
			} else if(App->GetInput().IsKeyDown(sf::Key::Return) && last_key!=sf::Key::Return) {
				last_key=sf::Key::Return; SelOk();
			} else if(App->GetInput().IsKeyDown(sf::Key::Up) && last_key!=sf::Key::Up) {
				last_key=sf::Key::Up; SelMove(true);
			} else if(App->GetInput().IsKeyDown(sf::Key::Down) && last_key!=sf::Key::Down) {
				last_key=sf::Key::Down; SelMove(false);
			} else if(App->GetInput().IsKeyDown(sf::Key::Left) && last_key!=sf::Key::Left) {
				last_key=sf::Key::Left; SelSide(false);
			} else if(App->GetInput().IsKeyDown(sf::Key::Right) && last_key!=sf::Key::Right) {
				last_key=sf::Key::Right; SelSide(true);
			} else if(App->GetInput().IsKeyDown(sf::Key::Delete) && last_key!=sf::Key::Delete) {
				last_key=sf::Key::Delete; Delete();
			} else if(App->GetInput().IsKeyDown(sf::Key::F1) && last_key!=sf::Key::F1) {
				last_key=sf::Key::F1; show_help=!show_help;
			} else if(App->GetInput().IsKeyDown(sf::Key::J) && last_key!=sf::Key::J) {
				config->ChangeJoystick(true); ReloadOptions(); last_key=Key::J;
			} else if (!App->GetInput().IsKeyDown(last_key)) {
				last_key=sf::Key::Count;
			}
		}
		
		Draw();
			
		App->TimedDisplay();
	}
}

void Menu::Draw() {

	sel_target_y=items[selection].pos[1]-15;
	sel_target_x=items[selection].pos[0]-50;
	
	App->Draw(bsprite);
	if (config->extra_fx) {
		la+=.1;
		real da=sin(la)*3;
		lsprite.SetScale(1+da/200,1/*-da/10*/);
		lsprite.SetPosition(screen_w/4,screen_h/6+da);
	}
	App->Draw(lsprite);
	
	if (main_h<m1h) { 
		main_h*=1.3;
		m1sprite.SetScale(my_global_scale,real(main_h)/m1h*my_global_scale);
	} else 
		m1sprite.SetScale(my_global_scale,my_global_scale);
	App->Draw(m1sprite);
	
	if (show_second && second_w<400) second_w+=25;
	else if (!show_second && second_w>0) second_w-=25;
	if (second_w) {
		m2sprite.SetPosition(screen_w-second_w+m2w/2*my_global_scale,30+m2h/2*my_global_scale);
		App->Draw(m2sprite);
		if (second_x!=screen_w-second_w+60) second_x=(3*second_x+screen_w-second_w+60)/4;
		if (second_y!=120) second_y=(4*second_y+120)/5;
		font->RenderSmall(second_x,second_y,.8,second_title.c_str());
	}
	
	
	if (main_done) sel_wheel->Draw(items[selection].pos[0],items[selection].pos[1]);
	
	for (int i=0;i<mim_count+data->profile_count;i++) {
		if (!items[i].visible) continue;
		if (items[i].selected) {
			if (items[i].sel_level<8) items[i].sel_level+=1;
		} else {
			if (items[i].sel_level>0) items[i].sel_level-=1;
		}
		if (items[i].is_value)
			font->RenderPartialI(items[i].pos[0]-items[i].sel_level,items[i].pos[1]+items[i].sel_level,.55+.035*items[i].sel_level,items[i].label,items[i].charsdone/char_speed);
		else
			font->RenderPartial(items[i].pos[0]-items[i].sel_level,items[i].pos[1]+items[i].sel_level,.55+.035*items[i].sel_level,items[i].label,items[i].charsdone/char_speed);
		if (items[i].charsdone==char_speed*items[i].label.size()) continue;
		if (items[i].tostart) { items[i].tostart--; continue; }
		items[i].charsdone++;
		if (!main_done && i==mim_exit && items[mim_exit].charsdone==items[mim_exit].label.size()*char_speed) {
			main_done=true;
			items[selection].selected=true;
		}
	}
	
	if (show_help && items[selection].help[0].size() && last_move_time++>15) {
		if (selection<=mim_exit) {
			blsprite.FlipX(false);
			blsprite.SetScale(my_global_scale,my_global_scale);
			blsprite.SetPosition(sel_target_x+300,sel_target_y-50);
		} else {
			blsprite.FlipX(true);
			blsprite.SetScale(1.3*my_global_scale,my_global_scale);
			blsprite.SetPosition(sel_target_x-100,sel_target_y-50);
		}
		App->Draw(blsprite);
		if (selection<=mim_exit) {
			font->RenderCenter(sel_target_x+405,sel_target_y-80,.5,items[selection].help[0].c_str());
			font->RenderCenter(sel_target_x+405,sel_target_y-45,.5,items[selection].help[1].c_str());
			font->RenderCenter(sel_target_x+405,sel_target_y-10,.5,items[selection].help[2].c_str());
		} else {
			font->RenderCenter(sel_target_x-230,sel_target_y-80,.5,items[selection].help[0].c_str());
			font->RenderCenter(sel_target_x-230,sel_target_y-45,.5,items[selection].help[1].c_str());
			font->RenderCenter(sel_target_x-230,sel_target_y-10,.5,items[selection].help[2].c_str());
		}
	}
	
	string shelp(config->spanish?"presione H para ver los globos de ayuda":"press H for help baloons");
	shelp[config->spanish?9:6]=1;
	if (main_h>=m1h)
		font->RenderPartialI(790,590,.4,shelp.c_str(),shelp.size());
	font->RenderSmall(705,50,.4,sversion.c_str());
	font->RenderSmall(700,25,.4,"still beta");
	
}

void Menu::SelMove(bool up) {
	last_move_time=0;
	if (up) {
		if (items[selection].is_top) return;
		if (config->sound_on) music->snd_selmove.Play();
		items[selection].selected=false;
		if (items[selection].is_double) items[selection+1].selected=false;
		selection--; if (items[selection].is_value) selection--;
		items[selection].selected=true;
		if (items[selection].is_double) items[selection+1].selected=true;
	} else {
		if (items[selection].is_bottom || selection==mim_count+data->profile_count-1) return;
		if (config->sound_on) music->snd_selmove.Play();
		items[selection].selected=false;
		if (items[selection].is_double) items[selection+1].selected=false;
		selection++; if (items[selection].is_value) selection++;
		items[selection].selected=true;
		if (items[selection].is_double) items[selection+1].selected=true;
	}
	return;
}

void Menu::SelCancel() {
	if (config->sound_on) music->snd_selcancel.Play();
	if (in_options &&prev_menu==prev_main) {
		if (config->old_fullscreen!=config->fullscreen||config->old_mode!=config->cur_mode) {
			delete App;
			App=new MyRenderWindow();
			App->SetView(*view);
		}
		Reload(); config->Save(); 
	}
	last_move_time=0;
	if (prev_menu==prev_main) {
		items[selection].selected=false;
		if (items[selection].is_double) items[selection+1].selected=false;
		for (int i=mim_quickrace;i<=mim_exit;i++)
			if (items[i].selected)
				selection=i;
		prev_menu=prev_quit;
		in_options=false;
	} else if (prev_menu==prev_options) {
		items[selection].selected=false;
		if (items[selection].is_double) items[selection+1].selected=false;
		ViewSecond(false, config->spanish?"Configuracion":"MotoGT Settings",mim_opt_controls,mim_opt_about);
		for (int i=mim_opt_controls;i<mim_opt_about;i++)
			if (items[i].selected) { selection=i; break; }
		prev_menu=prev_main;
	} else if (prev_menu==prev_quit) {
		if (confirm->Ask(this,config->spanish?"Salir del Juego?":"Leave The Game?")) {
			data->SaveSomething();
			music->StopMusic();
			Fade(false);
			loading->Draw();
			App->Close();
		} else {
			FloatRect rect(0,0,screen_w,screen_h);
			view->SetFromRect(rect);
			App->SetView(*view);
		}
	}
}

void Menu::SelOkMain() {
	items[selection].selected=true;
	if (selection==mim_quickrace) {
		Fade(false);
		loading->Draw();
		if (profile) {
			data->SelectProfile();
			ViewSecond(false, config->spanish?"Elige un perfil":"Choose your profile",mim_count,mim_count+data->profile_count);
			prev_menu=prev_quit;
			items[selection].selected=false;
			selection=mim_quickrace;
		}
		racers=new Racer[data->bike_count];
		int the_one = rand()%data->bike_count;
		int *nums=new int[data->bike_count];
		for (int i=0;i<data->bike_count;i++) nums[i]=i;
		for (int i=0;i<data->bike_count-1;i++) {
			int aux,rnd=i+rand()%(data->bike_count-i);
			aux=nums[i]; nums[i]=nums[rnd]; nums[rnd]=aux;
		}
		for (int i=0;i<data->bike_count;i++) {
			if (nums[i]==the_one)
				racers[i].SetUnnamedPlayer(i);
			else
				racers[i].SetForQuickrace(i);
			racers[i].start_pos=nums[i]+1;
		}
		delete [] nums;
		for (int i=0;i<data->bike_count-1;i++) {
			int r=rand()%(data->bike_count-i);
			Racer aux = racers[i];
			racers[i] = racers[r];
			racers[r] = aux;
		}
#ifdef DEBUG		
		carrera = new Carrera(0,1);
#else
		carrera = new Carrera(rand()%data->track_count,3);
#endif
		if (!circuito->IsOk()) {
			Fade(true);
			delete carrera;
			return;
		}
		bool done=carrera->Race();
		loading->Draw();
		carrera->DeleteSomething();
		if (done) {
			loading->Draw();
			RaceResults *results = new RaceResults();
			results->Calculate(carrera);
			results->Show();
			loading->Draw();
			delete results;
		}
		delete carrera; carrera=NULL;
		delete [] racers; racers=NULL;
		Reset(false);
		Fade(true);
	} else if (selection==mim_records) {
		Fade(false);
		Records *r=new Records();
		r->Run();
		delete r;
		Fade(true);
	} else if (selection==mim_career) {
		if (profile) {
			ViewSecond(false, profile->name,mim_practice,mim_help_career);
		} else {
			if (data->profile_count==1) {
				string pname = confirm->Input(this,config->spanish?"Ingresa tu nombre":"Enter your name:");
				if (pname.size()) {
					string pfile = data->NewProfile(pname);
//					items[profile_max].label=pname;
//					ReloadProfiles();
					data->SelectProfile(pfile);
					Fade(false); hidden->Run(config->spanish?th_career_start_es:th_career_start_en); Fade(true);
					ViewSecond(false, profile->name,mim_practice,mim_help_career);
				}
			} else {
				ViewSecond(false, config->spanish?"Elige un perfil":"Choose your profile",mim_count,mim_count+data->profile_count);
			}
		} 
	} else if (selection==mim_options) {
		ViewSecond(false, config->spanish?"Configuracion":"MotoGT Settings",mim_opt_controls,mim_opt_about);
		items[selection=mim_opt_controls].selected=true;
		in_options=true;
	} else if (selection==mim_exit) {
		SelCancel();
	}
}

void Menu::SelOkProfile() {
	if (selection==mim_change_profile) {
		data->SelectProfile();
		ViewSecond(false, config->spanish?"Elige un perfil":"Choose your profile",mim_count,mim_count+data->profile_count);
	} else if (selection==mim_championship) {
		Fade(false);
		if (!profile->tips_seen) {
			hidden->Run(config->spanish?th_champ_start_es:th_champ_start_en); 
			profile->tips_seen=1;
		}
		ChampionshipMenu *champ_menu = new ChampionshipMenu();
		champ_menu->Run();
		delete champ_menu;
//		TextViewer *text_viewer = new TextViewer("data/menu/help.png","Championship Mode",text_help_championship);
//		text_viewer->Show(); delete text_viewer;
		Fade(true);
	} else if (selection==mim_help_career) {
		Fade(false);
		TextViewer *text_viewer = new TextViewer("data/menu/help.png",config->spanish?"PERFILES":"Career Mode",config->spanish?text_es_help_career:text_en_help_career);
		text_viewer->Show(); delete text_viewer;
		Fade(true);
	} else if (selection==mim_setup_bike) {
		Fade(false);
		BikeSelection *bike_selection = new BikeSelection(true);
		bike_selection->Select(1);
		delete bike_selection;
		Fade(true);
	} else if (selection==mim_single_race) {
		Fade(false);
		TrackSelection *track_selection = new TrackSelection();
		if (track_selection->Select(2)) {
			loading->Draw();
			delete track_selection;
			RaceMenu *race_menu = new RaceMenu(TrackSelection::target_track, TrackSelection::laps, TrackSelection::level);
			race_menu->Run();
			delete race_menu;
		} else 
			delete track_selection;
		Fade(true);
	} else if (selection==mim_practice) {
		Fade(false);
		loading->Draw();
		TrackSelection *track_selection = new TrackSelection();
		if (track_selection->Select(0)) {
			loading->Draw();
//			App->SetFramerateLimit(0);
			delete track_selection;
			circuito = new Circuito(TrackSelection::target_track);
			racers=new Racer[1];
			racers[0].SetFromProfile(0);
			carrera = new Carrera(50,1,true);
			if (!circuito->IsOk()) {
				Fade(true);
				delete carrera;
				return;
			}
//			App->SetFramerateLimit(FPS);
			carrera->Race();
			loading->Draw();
			delete carrera; carrera=NULL;
			delete circuito; circuito=NULL;
			delete [] racers; racers=NULL;
		} else 
			delete track_selection;
		Fade(true);
	}
}

void Menu::SelOkOptions(bool up) {
	if (selection==mim_opt_controls) {
		ViewSecond(true,config->spanish?"Controles":"Controls Settings",mim_controls_assign_keys,mim_controls_assign_joystick);
		prev_menu=prev_options;
	} else if (selection==mim_opt_about) {
		Fade(false);
		TextViewer *text_viewer = new TextViewer("data/menu/about.png",config->spanish?"Acerca del Juego":"About The Game...",config->spanish?text_es_about:text_en_about);
		text_viewer->Show(); delete text_viewer;
		Fade(true);
	} else if (selection==mim_opt_graphics) {
		ViewSecond(true,config->spanish?"Graficos":"Graphics Settings",mim_graphics_particles,mim_graphics_fullscreen_value);
		prev_menu=prev_options;
	} else if (selection==mim_opt_sound) {
		ViewSecond(true,config->spanish?"Sonido":"Sound Settings",mim_sound_fx_on,mim_sound_music_vol_value);
		prev_menu=prev_options;
	} else if (selection==mim_sound_fx_on) {
		config->ChangeSound(up);
		ReloadOptions();
	} else if (selection==mim_sound_fx_vol) {
		config->ChangeSoundVol(up);
		ReloadOptions();
	} else if (selection==mim_sound_music_on) {
		config->ChangeMusic(up);
		ReloadOptions();
		if (config->music_on) music->PlayMusic(); else music->StopMusic();
	} else if (selection==mim_sound_music_vol) {
		config->ChangeMusicVol(up);
		ReloadOptions();
	} else if (selection==mim_graphics_resolution) {
		config->ChangeResolution(up);
		ReloadOptions();
	} else if (selection==mim_graphics_fullscreen) {
		config->ChangeFullscreen(up);
		ReloadOptions();
	} else if (selection==mim_graphics_textures) {
		config->ChangeTextures(up);
		ReloadOptions();
	} else if (selection==mim_graphics_particles) {
		config->ChangeParticles(up);
		ReloadOptions();
	} else if (selection==mim_opt_language) {
		config->ChangeLanguage(up);
		if (data->profile_files[data->profile_count-1]=="")
			data->profile_names[data->profile_count-1]=config->spanish?"<nuevo perfil>":"<new profile>";
		SetMenu(); items[mim_options].selected=true;
		ViewSecond(false, config->spanish?"Configuracion":"MotoGT Settings",mim_opt_controls,mim_opt_about);
		items[selection].selected=false; items[mim_opt_language].selected=true; items[mim_opt_language+1].selected=true; selection=mim_opt_language;
	} else if (selection==mim_controls_use_joystick) {
		config->ChangeJoystick(up);
		ReloadOptions();
	} else if (selection==mim_controls_assign_keys) {
		int ka=confirm->KeyFor(this,
			config->spanish?"Presione la tecla para ACELERAR":"Press a key for ACCELERATE",
			config->spanish?"o Escape para cancelar los cambios":"or Escape to discard changes");
		if (ka==Key::Escape) return;
		int kb=confirm->KeyFor(this,
			config->spanish?"Presione la tecla para FRENAR":"Press a key for BRAKE",
			config->spanish?"o Escape para cancelar los cambios":"or Escape to discard changes");
		if (kb==Key::Escape) return;
		int kr=confirm->KeyFor(this,
			config->spanish?"Presione la tecla para DERECHA":"Press a key for TURN RIGHT",
			config->spanish?"o Escape para cancelar los cambios":"or Escape to discard changes");
		if (kr==Key::Escape) return;
		int kl=confirm->KeyFor(this,
			config->spanish?"Presione la tecla para IZQUIERDA":"Press a key for TURN LEFT",
			config->spanish?"o Escape para cancelar los cambios":"or Escape to discard changes");
		if (kl==Key::Escape) return;
		config->SetKeys(ka,kb,kr,kl);
		ReloadOptions();
	} else if (selection==mim_controls_assign_joystick) {
		if (config->joystick==0) { config->joystick=1; ReloadOptions(); }
		int ja,jb,jl,jr;
		bool bja,bjb,bjl,bjr;
		if (!confirm->JoyFor(this,
			config->spanish?"Presione un boton o mueva el":"Press a button or move",
			config->spanish?"joystick para ACELERAR. Use":"for ACCELERATE or",
			config->spanish?"Escape para cancelar los cambios":"Escape to discard changes",config->joystick,bja,ja))
			return;
		if (!confirm->JoyFor(this,
			config->spanish?"Presione un boton o mueva el":"Press a button or move",
			config->spanish?"joystick para FRENAR. Use":"for BRAKE or",
			config->spanish?"Escape para cancelar los cambios":"Escape to discard changes",config->joystick,bjb,jb))
			return;
		if (!confirm->JoyFor(this,
			config->spanish?"Presione un boton o mueva el":"Press a button or move",
			config->spanish?"joystick para DERECHA. Use":"for TURN RIGHT or",
			config->spanish?"Escape para cancelar los cambios":"Escape to discard changes",config->joystick,bjr,jr))
			return;
		if (!confirm->JoyFor(this,
			config->spanish?"Presione un boton o mueva el":"Press a button or move",
			config->spanish?"joystick para IZQUIERDA. Use":"for TURN LEFT or",
			config->spanish?"Escape para cancelar los cambios":"Escape to discard changes",config->joystick,bjl,jl))
			return;
		config->SetJoys(bja,ja,bjb,jb,bjr,jr,bjl,jl);
		ReloadOptions();
	}
}

void Menu::SelOk() {
	if (!in_options && config->sound_on) music->snd_selok.Play();
	last_move_time=0;
	if (selection>=mim_quickrace && selection<=mim_exit) SelOkMain();
	else if (in_options) { 
		SelOkOptions(true);
		if (config->sound_on) music->snd_selok.Play();
	}
	else if (selection>=mim_practice && selection<=mim_help_career) SelOkProfile();
	else if (selection>=mim_count) {
		string pfile = data->profile_files[selection-mim_count];
		while (!pfile.size()) {
			string pname = confirm->Input(this,config->spanish?"Ingresa tu nombre:":"Enter your name:");
			if (pname.size()) {
				if (data->ProfileExists(pname))
					confirm->Tell(this,config->spanish?"El perfil ya existe.":"Profile name already in use.",config->spanish?"Elige otro nombre.":"Choose another one.");
				else {
					pfile = data->NewProfile(pname);
					ReloadProfiles();
					Fade(false); hidden->Run(config->spanish?th_career_start_es:th_career_start_en); Fade(true);
				}
			} else return;
		}
		data->SelectProfile(pfile);
		for (int i=mim_count;i<mim_count+data->profile_count;i++) {
			items[i].charsdone=0;
			items[i].label=data->profile_names[i-mim_count];
		}
		ViewSecond(true,profile->name,mim_practice,mim_help_career);
	}
}

void Menu::SelSide(bool right) {
	if (config->sound_on) music->snd_selmove.Play();
	if (in_options) SelOkOptions(right);
}

void Menu::ReloadProfiles() {
	for (int i=mim_count;i<mim_count+data->profile_count;i++) {
		items[i].visible=true;
		if (items[i].label!=data->profile_names[i-mim_count]) {
			items[i].charsdone=0;
			items[i].label=data->profile_names[i-mim_count];
			items[i].tostart=0;
		}
	}
	for (int i=mim_count+data->profile_count;i<mim_count+profile_max;i++) {
		items[i].visible=false;
		items[i].charsdone=0;
		items[i].label="";
		if (items[i].selected && selection==i) {
			selection=mim_count+data->profile_count-1;
			items[mim_count+data->profile_count-1].selected=true;
		}
	}
	
}
void Menu::ViewSecond(bool move_from_sel, string title, int i1, int i2, int is) {
	if (items[i2].is_double) i2++;
	if (move_from_sel) {
		second_x=items[selection].pos[0]; second_y=items[selection].pos[1];
	} else if (title!=second_title) {
		second_x=850; second_y=120;
	}
	if (prev_menu!=prev_quit&&!(in_options&&prev_menu==prev_main)) {
		items[selection].selected=false;
		if (items[selection].is_double) 
			items[selection+1].selected=false;
	}
	show_second=true;
	second_title=title;
	for (int i=mim_exit+1;i<mim_count+profile_max;i++) {
		if (i<i1||i>i2) {
			items[i].visible=false; items[i].charsdone=0;
		} else {
			items[i].visible=true; items[i].tostart=(i-i1)*5*char_speed+(400-second_w)/25;
		}
	}
	selection=is?is:i1;
	if (prev_menu!=prev_options) {
		items[selection].selected=true;
		if (items[selection].is_double)
			items[selection+1].selected=true;
	}
	prev_menu=prev_main;
}

#define check_and_apply(id) if (items[id].label!=aux) {items[id].label=aux; items[id].charsdone=1;}

void Menu::ReloadOptions() {
	
	string aux;
		
	if (config->joystick) {
		stringstream js;
		js<<"<Joystick "<<config->joystick<<">";
		aux=js.str();
	} else aux=config->spanish?"<Deshabilit.>":"<Disabled>";
	check_and_apply(mim_controls_use_joystick_value); 

	string particles=config->spanish?"<propias>":"<custom>";
	if (!config->shaders_on && !config->extra_fx && config->particles_low==0 && config->particles_hi==0)
		particles=config->spanish?"<ninguno>":"<none>";
	else if (!config->shaders_on && !config->extra_fx && config->particles_low==50 && config->particles_hi==100)
		particles=config->spanish?"<bajos>":"<low>";
	else if (!config->shaders_on && config->extra_fx && config->particles_low==100 && config->particles_hi==300)
		particles=config->spanish?"<normales>":"<normal>";
	else if (!config->shaders_on && config->extra_fx && config->particles_low==250 && config->particles_hi==600)
		particles=config->spanish?"<altos>":"<high>";
	else if (config->shaders_on && config->extra_fx && config->particles_low==250 && config->particles_hi==600)
		particles=config->spanish?"<extremos>":"<extreme>";
	aux=particles;
	check_and_apply(mim_graphics_particles_value); 
	
	aux=config->low_textures?(config->spanish?"<Baja Res>":"<Low Res>"):(config->spanish?"<Normal>":"<Normal>");
	check_and_apply(mim_graphics_textures_value); 
	
	stringstream smode;
	smode<<"<"<<config->real_w<<"x"<<config->real_h<<">";
	aux=smode.str();
	check_and_apply(mim_graphics_resolution_value); 
	
	aux=config->fullscreen?(config->spanish?"<Pant. Comp.>":"<Fullscreen>"):(config->spanish?"<Ventana>":"<Windowed>");
	check_and_apply(mim_graphics_fullscreen_value);
	
	aux=config->sound_on?(config->spanish?"<Habilitado>":"<Enabled>"):(config->spanish?"<Deshabilit.>":"<Disable>");
	check_and_apply(mim_sound_fx_on_value); 
	
	items[mim_sound_fx_vol_value].label=string("<")+string(config->sound_vol,'|')+string(MAX_VOLUME-config->sound_vol,' ')+">";
	
	aux=config->music_on?(config->spanish?"<Habilitado>":"<Enabled>"):(config->spanish?"<Deshabilit.>":"<Disable>");
	check_and_apply(mim_sound_music_on_value); 
	
	items[mim_sound_music_vol_value].label=string("<")+string(config->music_vol,'|')+string(MAX_VOLUME-config->music_vol,' ')+">";
	
	aux=config->spanish?"<Espaol>":"<English>";
	check_and_apply(mim_opt_language_value); 
	if (items[mim_opt_language_value].charsdone==1)
		items[mim_opt_language_value].charsdone--;
	
}

void Menu::Delete() {
	if (selection<mim_count) return;
	string pfile = data->profile_files[selection-mim_count];
	if (!pfile.size()) return;
	if (confirm->Ask(this,config->spanish?"Eliminar perfil?":"Delete profile?")) {
		data->DeleteProfile(selection-mim_count);
		for (int i=mim_count;i<mim_count+data->profile_count;i++) {
			items[i].charsdone=0; items[i].label=data->profile_names[i-mim_count];
		}
		items[mim_count+data->profile_count].visible=false;
	}
}

implement_fade(Menu)
