#include <iostream>
#include <cstdlib>
#include <cmath>
#include <cstdio>
#define PNG_DEBUG 3
#include <png.h>
#include <fstream>
#include "global.h"
#include "Config.h"
#include "Confirm.h"
using namespace std;

#define RAND_PRESITION 100000

typedef unsigned char byte;

#define px(p,i,j,k) (p)->row_pointers[i][(j)*4+k]

class PilaXY {
	int *x,*y,n,s;
public:
	PilaXY(int ax, int ay) { 
		n=1; s=1000;
		x=(int*)malloc(sizeof(int)*s); x[0]=ax;
		y=(int*)malloc(sizeof(int)*s); y[0]=ay;
	}
	void Push(int ax, int ay) {
		if (++n==s) {
			s*=1.5;
			x=(int*)realloc(x,sizeof(int)*s); 
			y=(int*)realloc(y,sizeof(int)*s); 
		}
		x[n-1]=ax; y[n-1]=ay;
	}
	bool Pop(int &ax, int &ay) {
		if (n) {
			int i=rand()%n;
			n--; ax=x[i]; ay=y[i];
			x[i]=x[n]; y[i]=y[n];
			return true;
		} else
			return false;
	}
	~PilaXY() { 
		free(x); free(y);
	}
};

struct PngFile {
	
	
	// read/write process based on code from Guillaume Cottenceau taken from (http://zarb.org/~gc/html/libpng.html)
	
	int width, height;
	png_byte color_type;
	png_byte bit_depth;
	png_structp png_ptr;
	png_infop info_ptr;
	int number_of_passes;
	png_bytep * row_pointers;
	PngFile() { row_pointers=NULL; }
	~PngFile() { 
		Free();
	}
	void Free(){
		if (!row_pointers) return;
		cerr<<"Free..."<<endl;
		for (int i=0;i<height;i++)
			free(row_pointers[i]);
		free(row_pointers);
	}
	bool Load(const char* file_name) {
		
		cerr<<"Loading "<<file_name<<"..."<<endl;
		Free();
		png_byte header[8];	// 8 is the maximum size that can be checked
		
		/* open file and test for it being a png */
		FILE *fp = fopen(file_name, "rb");
		if (!fp) {
			cerr<<"   File could not be opened for reading"<<endl;
			return false;
		}
		fread(header, 1, 8, fp);
		if (png_sig_cmp(header, 0, 8)) {
			cerr<<"   File is not recognized as a PNG file"<<endl;
			return false;
		}
		
		/* initialize stuff */
		png_ptr = png_create_read_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);
		if (!png_ptr) {
			cerr<<"   png_create_read_struct failed"<<endl;
			return false;
		}
		
		info_ptr = png_create_info_struct(png_ptr);
		if (!info_ptr) {
			cerr<<"   png_create_info_struct failed"<<endl;
			return false;
		}
		
		if (setjmp(png_jmpbuf(png_ptr))) {
			cerr<<"   Error during init_io"<<endl;
			return false;
		}
		png_init_io(png_ptr, fp);
		png_set_sig_bytes(png_ptr, 8);
		
		png_read_info(png_ptr, info_ptr);
		
		width = info_ptr->width;
		height = info_ptr->height;
		color_type = info_ptr->color_type;
		bit_depth = info_ptr->bit_depth;
		
		number_of_passes = png_set_interlace_handling(png_ptr);
		png_read_update_info(png_ptr, info_ptr);
		
		/* read file */
		if (setjmp(png_jmpbuf(png_ptr))) {
			cerr<<"   Error during read_image"<<endl;
			return false;
		}
		
		row_pointers = (png_bytep*) malloc(sizeof(png_bytep) * height);
		for (int y=0; y<height; y++)
			row_pointers[y] = (png_byte*) malloc(info_ptr->rowbytes);
		
		png_read_image(png_ptr, row_pointers);
		
		fclose(fp);
		
		return true;
	}
	bool Save(const char* file_name) {
		
		cerr<<"Saving "<<file_name<<"..."<<endl;
		
		/* create file */
		FILE *fp = fopen(file_name, "wb");
		if (!fp) {
			cerr<<"   File could not be opened for writing"<<endl;
			return false;
		}
		
		/* initialize stuff */
		png_ptr = png_create_write_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);
		
		if (!png_ptr) {
			cerr<<"   png_create_write_struct failed"<<endl;
			return false;
		}
		
		info_ptr = png_create_info_struct(png_ptr);
		if (!info_ptr) {
			cerr<<"   png_create_info_struct failed"<<endl;
			return false;
		}
		
		if (setjmp(png_jmpbuf(png_ptr))) {
			cerr<<"   Error during init_io"<<endl;
			return false;
		}
		
		png_init_io(png_ptr, fp);
		
		/* write header */
		if (setjmp(png_jmpbuf(png_ptr))) {
			cerr<<"   Error during writing header"<<endl;
			return false;
		}
		
		png_set_IHDR(png_ptr, info_ptr, width, height,
			bit_depth, color_type, PNG_INTERLACE_NONE,
			PNG_COMPRESSION_TYPE_BASE, PNG_FILTER_TYPE_BASE);
		
		png_write_info(png_ptr, info_ptr);
		
		/* write bytes */
		if (setjmp(png_jmpbuf(png_ptr))) {
			cerr<<"   Error during writing bytes"<<endl;
			return false;
		}
		
		png_write_image(png_ptr, row_pointers);
		
		/* end write */
		if (setjmp(png_jmpbuf(png_ptr))) {
			cerr<<"   Error during end of write"<<endl;
			return false;
		}
		
		png_write_end(png_ptr, NULL);
		
		fclose(fp);
		
		return true;
	}
	
	
	// filters based on source code from The GIMP (http://www.gimp.org)
	
	static double gauss () {
		double u, v, x;
		do {
			v = double(rand()%RAND_PRESITION)/RAND_PRESITION;
			do
				u = double(rand()%RAND_PRESITION)/RAND_PRESITION;
			while (u == 0);
			/* Const 1.715... = sqrt(8/e) */
			x = 1.71552776992141359295 * (v - 0.5) / u;
		}
		while (x * x > -4.0 * log (u));
		return x;
	}
	
	void Noise (double amount) {
		
		cerr<<"Noise..."<<endl;
		int dot=0, h5=height/6;
		for (int i=0;i<height;i++) {
			if (config&&i/h5>dot) { confirm->ShowBuilding(1); dot++; }
			for (int j=0;j<width;j++) {
				for (int k=0;k<3;k++) {
					int r = px(this,i,j,k)+(int)(amount*gauss()* 127);
					if (r<0) r=0; if (r>255) r=255; px(this,i,j,k)=r;
				}
			}
		}
	}
	
	void Spread (int amount) {
		amount/=global_scale;
		cerr<<"Spread..."<<endl;
		double angle;
		int xdist, ydist;
		int xi, yi;
		/* get random angle, x distance, and y distance */
		int dot=0, h3=height/4;
		for (int i=0;i<height;i++) {
			if (config&&i/h3>dot) { confirm->ShowBuilding(1); dot++; }
			for (int j=0;j<width;j++) {
				xdist = rand()%(amount*2+1)-amount;
				ydist = rand()%(amount*2+1)-amount;
				angle = rand()%(int(RAND_PRESITION*2*M_PI))/RAND_PRESITION-M_PI;
				xi = i + floor (sin (angle) * xdist);
				yi = j + floor (cos (angle) * ydist);
				/* Only displace the pixel if it's within the bounds of the image. */
				if (xi >= 0 && xi < height && yi >= 0 && yi < width) {
					for (int k=0;k<3;k++) {
						int r = px(this,i,j,k);
						px(this,i,j,k)=px(this,xi,yi,k);
						px(this,xi,yi,k)=r;
					}
				}
			}
		}
	}
	
	
	// my operations
	
	void Blend (PngFile *f2) {
		cerr<<"Blend..."<<endl;
		for (int i=0;i<height;i++) {
			for (int j=0;j<width;j++) {
				for (int k=0;k<3;k++) {
					px(this,i,j,k) = (px(this,i,j,k)*(255-px(f2,i,j,3))+px(f2,i,j,k)*px(f2,i,j,3))/255;
				}
			}
		}
	}
	
	void PeopleColor(png_byte &r, png_byte &g, png_byte &b) {
		int x=rand()%10;
		if (x<3) {
			r=180-40+rand()%80;
			g=155-40+rand()%80;
			b=145-40+rand()%80;
//		} else if (x<7) {
//			r=rand()%80;
//			g=rand()%80;
//			b=rand()%80;
		} else {
			r=rand()%256;
			g=rand()%256;
			b=rand()%256;
		}
	}
	
	void People(int x, int y) {
		x/=global_scale; y/=global_scale;
		cerr<<"People..."<<endl;
		png_byte r=px(this,y,x,0),cr;
		png_byte g=px(this,y,x,1),cg;
		png_byte b=px(this,y,x,2),cb;
		PilaXY p(y,x);
		int dr,dg,db;
		while (p.Pop(y,x)) {
			PeopleColor(cr,cg,cb);
			for (int i=-1;i<2;i++) {
				for (int j=-1;j<2;j++) {
					dr=r-px(this,y+i,x+j,0);
					dg=g-px(this,y+i,x+j,1);
					db=b-px(this,y+i,x+j,2);
					if (!((i|j)==0 ||
						dr*dr>100 || dg*dg>100 || db*db>100))
						p.Push(y+i,x+j);
					px(this,y+i,x+j,0)=cr;
					px(this,y+i,x+j,1)=cg;
					px(this,y+i,x+j,2)=cb;
				}
			}
		}
	}
	
	void Multiply(PngFile *f2) {
		cerr<<"Multiply..."<<endl;
		int d=height/(f2->height-100/global_scale);
		for (int i=0;i<height;i++) {
			for (int j=0;j<width;j++) {
				for (int k=0;k<3;k++) {
					px(this,i,j,k) = png_byte(int(px(this,i,j,k))*int(px(f2,i/d,j/d,k))/255);
				}
			}
		}
	}
	
	void Thumb(PngFile *f2) {
		int ow=f2->width, oh=f2->height;
		int rw=width, rh=height;
		int nh=f2->height=400; 
		int nw=f2->width=rw/rh*nh;
		int ii,jj;
		for (int i=0;i<nh;i++) {
			for (int j=0;j<nh;j++) {
				px(this,i,j,3)=255;
				ii=(rh*i)/nh;
				jj=(rw*j)/nw;
				for (int k=0;k<3;k++)
					px(f2,i,j,k) = px(this,ii,jj,k);
			}
		}
		f2->Save("thumbnail.png");
		f2->width=ow; f2->height=oh; 
	}
	
	bool Cut(string dir, PngFile *f2) {
		int ancho1=global_scale==1?500:250;
		int ancho2=global_scale==1?506:254;
		int ow=f2->width, oh=f2->height;
		f2->height=f2->width=ancho2; 
		cerr<<"Cut..."<<endl;
		for (int ii=0;ii<ancho2;ii++)
			for (int jj=0;jj<ancho2;jj++)
				px(f2,ii,jj,3)=255;
		char fname[]="t00.png";
		for (int ii=0;ii<ancho2;ii++)
			for (int jj=0;jj<ancho2;jj++)
				px(f2,ii,jj,3)=255;
		int nh=height/ancho1+((height%ancho1)?1:0);
		int nw=width/ancho1+((width%ancho1)?1:0);
		for (int i=0;i<nh;i++) {
			int bi=i*ancho1;
			if (config) confirm->ShowBuilding(1);
			for (int j=0;j<nw;j++) {
				int bj=j*ancho1;
				for (int ii=0;ii<ancho2;ii++) {
					if (bi+ii==height) { f2->height=ii; break; }
					for (int jj=0;jj<ancho2;jj++) {
						if (bj+jj==width) { f2->width=jj; break; }
						for (int kk=0;kk<3;kk++)
							px(f2,ii,jj,kk)=px(this,bi+ii,bj+jj,kk);
					}
				}
				fname[2]='0'+i; 
				fname[1]='0'+j;
				if (!f2->Save((dir+fname).c_str()))
					return false;
				f2->width=ancho2; f2->height=ancho2;
			}
		}
		f2->width=ow; f2->height=oh;
		return true;
	}
};


bool MakeData(string dir, int version) {
	ifstream b((dir+"build.mps").c_str());
	dir=fix_image_file(dir);
	PngFile *p=NULL; bool is_error=false;
	string s; int i, j, k; float f;
	while (b>>s) {
		if (s=="imgs") {
			b>>i; delete []p; p=new PngFile[i];
		} else if (s=="load") {
			b>>i; b>>s; 
			if (!p[i].Load((dir+s).c_str()))
			{ is_error=true; break; }
			if (config) confirm->ShowBuilding(2);
		} else if (s=="save") {
			b>>i; b>>s; 
			if (!p[i].Save((dir+s).c_str())) 
			{ is_error=true; break; }
			if (config) confirm->ShowBuilding(3);
		} else if (s=="cut") {
			b>>i; b>>j; 
			if (!p[i].Cut(dir,p+j))
			{ is_error=true; break; }
		} else if (s=="people") {
			b>>i; b>>j; b>>k; p[i].People(j,k);
			if (config) confirm->ShowBuilding(1);
		} else if (s=="spread") {
			b>>i; b>>j; p[i].Spread(j);
		} else if (s=="noise") {
			b>>i; b>>f; p[i].Noise(f);
		} else if (s=="blend") {
			b>>i; b>>j; p[i].Blend(p+j);
			if (config) confirm->ShowBuilding(2);
		} else if (s=="multiply") {
			b>>i; b>>j; p[i].Multiply(p+j);
			if (config) confirm->ShowBuilding(2);
#ifdef DEBUG
		} else if (s=="debugsave") {
			b>>i; b>>s; p[i].Save((dir+s).c_str());
#endif
		}
		b.ignore(256,'\n');
	}
	delete []p;
	if (!is_error) {
		ofstream fout((dir+"build.ver").c_str());
		fout<<version<<endl;
		fout.close();
	}
	return !is_error;
}
